/*
 * Decompiled with CFR 0.152.
 */
package org.jbundle.util.calendarpanel.util;

import java.awt.Container;
import java.awt.Rectangle;
import java.util.Date;
import java.util.Vector;
import org.jbundle.util.calendarpanel.CalendarPanel;
import org.jbundle.util.calendarpanel.model.CalendarItem;
import org.jbundle.util.calendarpanel.model.CalendarModel;
import org.jbundle.util.calendarpanel.util.JUnderlinedLabel;

public class CalendarCache {
    protected Date m_dateDescEnd = null;
    protected int m_iLine = -1;
    protected CalendarPanel m_calendarPanel = null;
    protected boolean m_bSelected = false;
    protected CalendarModel m_model = null;
    protected int m_iIndex = -1;
    public Vector<JUnderlinedLabel> m_vectorComponents = null;

    public CalendarCache() {
    }

    public CalendarCache(CalendarPanel calendarPanel, CalendarModel model, int iIndex) {
        this();
        this.init(calendarPanel, model, iIndex);
    }

    public void init(CalendarPanel calendarPanel, CalendarModel model, int iIndex) {
        this.m_calendarPanel = calendarPanel;
        this.m_iLine = -1;
        this.cacheItem(model, iIndex);
    }

    public void free() {
        this.removeComponents();
    }

    public Date getEndDesc() {
        Date endTime = this.getItem().getEndDate();
        if (endTime == null) {
            endTime = this.getItem().getStartDate();
        }
        if (this.m_dateDescEnd != null && endTime != null && this.m_dateDescEnd.after(endTime)) {
            return this.m_dateDescEnd;
        }
        return endTime;
    }

    public int getLine(Date dateDescEnd) {
        if (dateDescEnd != null && this.m_iLine == -1) {
            this.m_dateDescEnd = dateDescEnd;
            this.findLine();
        }
        return this.m_iLine;
    }

    public void setLine(int iLine) {
        this.m_iLine = iLine;
    }

    public void findLine() {
        long lBitmap = 0L;
        CalendarItem calendarItem = this.getItem();
        if (calendarItem == null) {
            return;
        }
        Date dateCalendarStart = calendarItem.getStartDate();
        if (dateCalendarStart == null || dateCalendarStart.getTime() == 0L) {
            return;
        }
        Date dateDescEnd = this.getEndDesc();
        if (dateDescEnd == null || dateDescEnd.getTime() == 0L) {
            return;
        }
        int i = 0;
        while (i < this.m_calendarPanel.getCacheCount(true)) {
            Date dateCurrentDescEnd;
            Date dateCurrentItemStart;
            CalendarItem item;
            CalendarCache cacheItem = this.m_calendarPanel.getCacheItem(i);
            if (this != cacheItem && cacheItem.getLine(null) != -1 && (item = cacheItem.getItem()) != null && (dateCurrentItemStart = item.getStartDate()) != null && dateCurrentItemStart.getTime() != 0L && (dateCurrentDescEnd = cacheItem.getEndDesc()) != null && dateCurrentDescEnd.getTime() != 0L && !dateCalendarStart.after(dateCurrentDescEnd) && !dateDescEnd.before(dateCurrentItemStart)) {
                lBitmap |= (long)(1 << cacheItem.getLine(null));
            }
            ++i;
        }
        int iTargetLine = 1;
        iTargetLine = 1;
        while (iTargetLine < 63) {
            if ((lBitmap & (long)(1 << iTargetLine)) == 0L) break;
            ++iTargetLine;
        }
        this.setLine(iTargetLine);
    }

    public void cacheItem(CalendarModel model, int iIndex) {
        if (model != null) {
            this.m_model = model;
        }
        this.m_iIndex = iIndex;
        this.setLine(-1);
        this.m_dateDescEnd = null;
    }

    public CalendarItem getItem() {
        if (this.m_iIndex == -1) {
            return null;
        }
        return this.m_model.getItem(this.m_iIndex);
    }

    public void addComponent(JUnderlinedLabel component) {
        if (this.m_vectorComponents == null) {
            this.m_vectorComponents = new Vector();
        }
        this.m_vectorComponents.addElement(component);
    }

    public void removeComponent(JUnderlinedLabel component) {
        if (this.m_vectorComponents == null) {
            return;
        }
        int i = 0;
        while (i < this.m_vectorComponents.size()) {
            if (this.m_vectorComponents.elementAt(i) == component) {
                this.m_vectorComponents.remove(i);
                return;
            }
            ++i;
        }
    }

    public void setUnderlined(boolean bSelected) {
        for (JUnderlinedLabel label : this.m_vectorComponents) {
            label.setUnderlined(bSelected);
        }
    }

    public void setSelected(boolean bSelected) {
        this.m_bSelected = bSelected;
        if (this.m_vectorComponents == null) {
            return;
        }
        for (JUnderlinedLabel label : this.m_vectorComponents) {
            label.setSelected(bSelected);
        }
    }

    public boolean isSelected() {
        return this.m_bSelected;
    }

    public void removeComponents() {
        if (this.m_model != null && this.m_vectorComponents != null) {
            int iIndex = this.m_vectorComponents.size() - 1;
            while (iIndex >= 0) {
                JUnderlinedLabel component = this.m_vectorComponents.elementAt(iIndex);
                Container parent = component.getParent();
                Rectangle rect = component.getBounds();
                component.free();
                if (parent != null) {
                    parent.repaint(rect.x, rect.y, rect.width, rect.height);
                }
                --iIndex;
            }
        }
    }

    public CalendarModel getModel() {
        return this.m_model;
    }

    public int getIndex() {
        return this.m_iIndex;
    }

    public void setIndex(int iIndex) {
        this.m_iIndex = iIndex;
    }
}

