/*
 * Decompiled with CFR 0.152.
 */
package org.jbundle.util.calendarpanel.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.RoundRectangle2D;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jbundle.util.calendarpanel.CalendarPane;
import org.jbundle.util.calendarpanel.dnd.CalendarItemTransferHandler;
import org.jbundle.util.calendarpanel.dnd.CalendarItemTransferable;
import org.jbundle.util.calendarpanel.util.CalendarCache;
import org.jbundle.util.calendarpanel.util.LabelMouseListener;

public class JUnderlinedLabel
extends JLabel
implements ActionListener,
TableCellRenderer {
    private static final long serialVersionUID = 1L;
    protected static int m_iUnderline = -1;
    protected static FontMetrics m_fm = null;
    protected CalendarCache m_itemCache = null;
    protected boolean bSelectable = false;
    protected int m_iStringWidth = 0;
    protected Color m_colorNormal = null;
    protected Color m_colorHighlight = null;
    protected Color m_colorSelect = null;
    protected boolean m_bUnderlined = false;
    private int m_iComponentType = 1011;
    private String m_strToolTip = null;
    protected LabelMouseListener m_mouseListener = null;
    protected ImageIcon m_imageBackground = null;
    protected boolean m_bStartRound = false;
    protected boolean m_bEndRound = false;
    private static RoundRectangle2D.Double gClip = new RoundRectangle2D.Double(0.0, 0.0, 0.0, 0.0, 4.0, 4.0);
    protected TableModel m_tableModel = null;
    protected int m_iThisRow = -1;
    private static final int MAX_ICONS = 16;
    private ImageIcon[] m_rgIcons = null;
    private Timer m_timer = null;
    private int m_iCurrentIcon = 0;

    public JUnderlinedLabel(CalendarCache itemCache, String strLabel, boolean bSelectable, Color colorHighlight, Color colorSelect, int iComponentType, String strToolTip) {
        super(strLabel);
        this.init(itemCache, strLabel, bSelectable, colorHighlight, colorSelect, iComponentType, null, strToolTip, true);
    }

    public JUnderlinedLabel(CalendarCache itemCache, ImageIcon icon, boolean bSelectable, Color colorHighlight, Color colorSelect, int iComponentType, String strToolTip) {
        super(icon);
        this.init(itemCache, null, bSelectable, colorHighlight, colorSelect, iComponentType, icon, strToolTip, true);
    }

    public JUnderlinedLabel(CalendarCache itemCache, String strLabel, boolean bSelectable, Color colorHighlight, Color colorSelect, int iComponentType, String strToolTip, boolean bEnableDnD) {
        super(strLabel);
        this.init(itemCache, strLabel, bSelectable, colorHighlight, colorSelect, iComponentType, null, strToolTip, bEnableDnD);
    }

    public JUnderlinedLabel(CalendarCache itemCache, ImageIcon icon, boolean bSelectable, Color colorHighlight, Color colorSelect, int iComponentType, String strToolTip, boolean bEnableDnD) {
        super(icon);
        this.init(itemCache, null, bSelectable, colorHighlight, colorSelect, iComponentType, icon, strToolTip, bEnableDnD);
    }

    public void init(CalendarCache itemCache, String strLabel, boolean bSelectable, Color colorHighlight, Color colorSelect, int iComponentType, ImageIcon icon, String strToolTip, boolean bEnableDnD) {
        this.m_itemCache = itemCache;
        this.m_iComponentType = iComponentType;
        this.m_strToolTip = strToolTip;
        if (itemCache != null) {
            itemCache.addComponent(this);
        }
        if (colorHighlight != null || icon != null) {
            this.setForeground(CalendarPane.ITEM_TEXT_COLOR);
        } else {
            this.setForeground(CalendarPane.ITEM_LIGHT_TEXT_COLOR);
        }
        if (strLabel != null) {
            if (m_fm == null) {
                m_fm = this.getFontMetrics(this.getFont());
            }
            m_iUnderline = m_fm.getDescent();
        }
        if (bSelectable) {
            if (strLabel != null) {
                this.m_iStringWidth = m_fm.stringWidth(strLabel);
            }
            if (icon != null) {
                this.m_iStringWidth = icon.getIconWidth();
            }
        }
        this.m_colorHighlight = colorHighlight;
        this.m_colorSelect = colorSelect;
        if (this.m_colorSelect == null && this.m_colorHighlight != null) {
            this.m_colorSelect = this.m_colorHighlight.darker();
        }
        if (bEnableDnD) {
            this.m_mouseListener = new LabelMouseListener(itemCache, this, true);
            this.addMouseListener(this.m_mouseListener);
            this.addMouseMotionListener(this.m_mouseListener);
        }
        this.setTransferHandler(new CalendarItemTransferHandler(CalendarItemTransferable.CALENDAR_ITEM_TRANSFER_TYPE));
    }

    public void free() {
        if (this.m_itemCache != null) {
            this.m_itemCache.removeComponent(this);
        }
        if (this.m_mouseListener != null) {
            this.removeMouseListener(this.m_mouseListener);
        }
        this.m_mouseListener = null;
        this.m_itemCache = null;
        if (this.m_timer != null) {
            this.removeTimer();
        }
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
        this.m_imageBackground = null;
    }

    @Override
    public void paintComponent(Graphics g) {
        Rectangle rectClip;
        Rectangle rectangle = this.getBounds();
        Insets insets = this.getInsets();
        if (this.m_colorNormal == null) {
            this.m_colorNormal = this.getForeground();
        }
        Color colorOld = g.getColor();
        if (rectangle.x < 0) {
            rectClip = g.getClipBounds();
            rectClip.x += 2;
            rectClip.width -= 2;
            g.setClip(rectClip);
        }
        if (this.m_colorHighlight != null) {
            g.setColor(this.m_colorHighlight);
            if (this.m_itemCache != null && this.m_itemCache.isSelected()) {
                g.setColor(this.m_colorSelect);
            }
            if ((this.m_bStartRound || this.m_bEndRound) && rectangle.height > 8) {
                rectClip = g.getClipBounds();
                int x = rectClip.x;
                int width = rectClip.width;
                int xShift = 4;
                if (rectangle.x < 0) {
                    xShift -= 2;
                }
                if (!this.m_bStartRound) {
                    x -= xShift;
                    width += xShift;
                } else if (!this.m_bEndRound) {
                    width += xShift;
                }
                gClip.setRoundRect(x, rectClip.y, width, rectClip.height, 4.0, 4.0);
                g.setClip(gClip);
            }
            g.fillRect(0, 0, rectangle.width, rectangle.height);
            if (this.m_imageBackground != null) {
                int iOffsetx = 0;
                int iOffsety = 0;
                Point ptThis = this.getLocationOnScreen();
                Container parent = this;
                while ((parent = parent.getParent()) != null) {
                    if (!(parent instanceof JApplet)) continue;
                    Point ptTile = parent.getLocationOnScreen();
                    iOffsetx = ptTile.x - ptThis.x;
                    iOffsety = ptTile.y - ptThis.y;
                    break;
                }
                int y = 0 + iOffsety;
                while (y < rectangle.height) {
                    int x = 0 + iOffsetx;
                    while (x < rectangle.width) {
                        this.m_imageBackground.paintIcon(this, g, x, y);
                        x += this.m_imageBackground.getIconWidth();
                    }
                    y += this.m_imageBackground.getIconHeight();
                }
            }
        }
        if (this.m_itemCache != null && this.m_itemCache.isSelected()) {
            this.setForeground(Color.black);
            g.setColor(Color.black);
        } else {
            this.setForeground(this.m_colorNormal);
            g.setColor(colorOld);
        }
        if (this.m_bUnderlined && m_iUnderline != -1) {
            g.drawLine(1, rectangle.height - m_iUnderline + 1, rectangle.width - 1 + insets.left, rectangle.height - m_iUnderline + 1);
        }
        super.paintComponent(g);
        g.setColor(colorOld);
    }

    public void setSelected(boolean bSelected) {
        this.repaint();
    }

    public void setUnderlined(boolean bUnderlined) {
        this.m_bUnderlined = bUnderlined;
        this.repaint();
    }

    public int getComponentType() {
        return this.m_iComponentType;
    }

    public CalendarCache getItemCache() {
        return this.m_itemCache;
    }

    public String getTooltip() {
        return this.m_strToolTip;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.m_tableModel == null) {
            this.m_iThisRow = row;
            this.m_tableModel = table.getModel();
        }
        return this;
    }

    public void addIcon(ImageIcon icon, int iIndex) {
        if (this.m_rgIcons == null) {
            this.m_rgIcons = new ImageIcon[16];
            this.m_rgIcons[0] = (ImageIcon)this.getIcon();
        }
        if (iIndex < 16) {
            this.m_rgIcons[iIndex] = icon;
        }
        if (this.m_timer == null && this.getIconCount() > 1) {
            this.m_timer = new Timer(500, this);
            this.m_timer.start();
        }
    }

    public void removeIcon(int iIndex) {
        if (this.m_rgIcons != null) {
            this.m_rgIcons[iIndex] = null;
            if (this.m_timer != null && this.getIconCount() <= 1) {
                this.removeTimer();
            }
            if (this.getIconCount() == 0) {
                this.m_rgIcons = null;
            }
        }
    }

    public int getIconCount() {
        int iCount = 0;
        int i = 0;
        while (i < 16) {
            if (this.m_rgIcons[i] != null) {
                ++iCount;
            }
            ++i;
        }
        return iCount;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ++this.m_iCurrentIcon;
        if (e.getSource() instanceof Timer) {
            if (this.m_tableModel != null) {
                TableModelEvent event = new TableModelEvent(this.m_tableModel, 0, Integer.MAX_VALUE, this.m_iThisRow);
                ((AbstractTableModel)this.m_tableModel).fireTableChanged(event);
            } else {
                String objValue = Integer.toString(this.m_itemCache.getItem().getStatus());
                ImageIcon icon = this.getImageIcon(objValue);
                if (icon != null) {
                    this.setIcon(icon);
                    Rectangle rect = this.getBounds();
                    this.repaint(rect);
                }
            }
        }
    }

    public ImageIcon getImageIcon(Object value) {
        int iRelIndex;
        int i = 0;
        if (value == null) {
            return this.m_rgIcons[0];
        }
        String strType = value.toString();
        int iType = 0;
        try {
            iType = Integer.parseInt(strType);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int iIconCount = 0;
        i = 1;
        while (i < 16) {
            if (this.m_rgIcons[i] != null && (1 << i & iType) != 0) {
                ++iIconCount;
            }
            ++i;
        }
        if (iIconCount == 0) {
            iIconCount = 1;
        }
        if ((iType & 1) == 0) {
            iRelIndex = this.m_iCurrentIcon % iIconCount;
        } else if ((this.m_iCurrentIcon & 1) == 0) {
            iRelIndex = 16;
        } else {
            int iIconIndex = this.m_iCurrentIcon / 2 + 1;
            iRelIndex = iIconIndex % iIconCount;
        }
        i = 1;
        while (i < 16) {
            if (this.m_rgIcons[i] != null && (1 << i & iType) != 0) {
                --iRelIndex;
            }
            if (iRelIndex < 0) break;
            ++i;
        }
        if (i >= 16) {
            i = 0;
        }
        return this.m_rgIcons[i];
    }

    public synchronized void removeTimer() {
        if (this.m_timer != null) {
            this.m_timer.stop();
            this.m_timer.removeActionListener(this);
            this.m_timer = null;
        }
    }

    public void setStartRound(boolean bStartRound) {
        this.m_bStartRound = bStartRound;
    }

    public void setEndRound(boolean bEndRound) {
        this.m_bEndRound = bEndRound;
    }

    public void setBackgroundImage(ImageIcon imageIcon) {
        this.m_imageBackground = imageIcon;
    }
}

