/*
 * Decompiled with CFR 0.152.
 */
package org.jbundle.util.calendarpanel.util;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.Timer;
import org.jbundle.util.calendarpanel.CalendarPanel;
import org.jbundle.util.calendarpanel.dnd.CalendarDnDMouseListener;
import org.jbundle.util.calendarpanel.util.CalendarCache;
import org.jbundle.util.calendarpanel.util.JUnderlinedLabel;

public class LabelMouseListener
extends CalendarDnDMouseListener
implements ActionListener {
    private JUnderlinedLabel m_component = null;
    private CalendarCache m_cacheItem = null;
    private boolean m_bEnableDnD = false;
    private Timer m_timer = null;

    public LabelMouseListener() {
    }

    public LabelMouseListener(CalendarCache cacheItem, JUnderlinedLabel component, boolean bEnableDnD) {
        this();
        this.init(cacheItem, component, bEnableDnD);
    }

    public void init(CalendarCache cacheItem, JUnderlinedLabel component, boolean bEnableDnD) {
        super.init(component);
        this.m_cacheItem = cacheItem;
        this.m_component = component;
        this.m_bEnableDnD = bEnableDnD;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.m_cacheItem != null) {
            this.m_cacheItem.setUnderlined(true);
        }
        if (this.m_timer == null) {
            this.m_timer = new Timer(500, this);
            this.m_timer.setRepeats(false);
            this.m_timer.start();
        }
        if (this.m_component.getTooltip() != null && this.m_component.getTooltip().length() > 0 && this.getCalendarPanel() != null) {
            this.getCalendarPanel().setStatusText(this.m_component.getTooltip());
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.m_cacheItem != null) {
            this.m_cacheItem.setUnderlined(false);
        }
        if (this.m_timer != null) {
            this.removeTimer();
        }
        if (this.m_component.getTooltip() != null && this.m_component.getTooltip().length() > 0 && this.getCalendarPanel() != null) {
            this.getCalendarPanel().setStatusText(null);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        CalendarPanel parent = this.getCalendarPanel();
        if (this.m_ptMouseAtClick != null && !this.movedEnough(e) && parent != null && this.m_cacheItem != null) {
            int iIndex = parent.getItemIndex(this.m_cacheItem);
            parent.getModel().fireTableRowSelected(this, iIndex, 35);
            parent.requestFocus();
            e.consume();
            this.m_ptMouseAtClick = null;
        }
        super.mouseReleased(e);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CalendarPanel parent = this.getCalendarPanel();
        if (parent != null && this.m_cacheItem != null) {
            int iIndex = parent.getItemIndex(this.m_cacheItem);
            if (!parent.isShifted()) {
                parent.getModel().fireTableRowSelected(this, iIndex, 1);
            } else {
                parent.getModel().fireTableRowSelected(this, iIndex, 17);
            }
            parent.requestFocus();
        }
        this.removeTimer();
    }

    public synchronized void removeTimer() {
        if (this.m_timer != null) {
            this.m_timer.stop();
            this.m_timer.removeActionListener(this);
            this.m_timer = null;
        }
    }

    public CalendarPanel getCalendarPanel() {
        Container parent = this.m_component;
        while ((parent = parent.getParent()) != null) {
            if (!(parent instanceof CalendarPanel)) continue;
            return (CalendarPanel)parent;
        }
        return null;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.m_bEnableDnD) {
            super.mouseDragged(e);
        }
    }
}

