/*
 * Decompiled with CFR 0.152.
 */
package org.jbundle.util.calendarpanel.util;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Date;
import org.jbundle.util.calendarpanel.CalendarPane;
import org.jbundle.util.calendarpanel.CalendarPanel;
import org.jbundle.util.calendarpanel.util.JUnderlinedLabel;

public class MouseDateListener
extends MouseMotionAdapter
implements MouseListener {
    protected CalendarPanel m_calendarPanel = null;
    protected transient PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);

    public MouseDateListener(CalendarPanel calendarPanel) {
        this.m_calendarPanel = calendarPanel;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        CalendarPanel calPanel = (CalendarPanel)e.getComponent();
        Component component = calPanel.getComponentAt(e.getPoint());
        if (component == null) {
            return;
        }
        if (component instanceof JUnderlinedLabel) {
            component = component.getParent();
        }
        if (component instanceof CalendarPane) {
            CalendarPane pane = (CalendarPane)component;
            int iX = e.getPoint().x - component.getBounds().x;
            Date dateTarget = pane.convertXToDate(iX, component.getBounds().width);
            this.firePropertyChange("dateDisplay", null, dateTarget);
        } else {
            this.firePropertyChange("dateDisplay", null, null);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        e.getComponent();
        this.firePropertyChange("dateDisplay", null, null);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChange.addPropertyChangeListener(listener);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.propertyChange != null) {
            this.propertyChange.firePropertyChange(propertyName, oldValue, newValue);
        }
    }
}

