/*
 * Decompiled with CFR 0.152.
 */
package charva.awt;

import charva.awt.ColorPair;
import charva.awt.TerminfoCapabilityException;
import charva.awt.Toolkit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Color {
    private static final Log LOG = LogFactory.getLog((Class)(class$charva$awt$Color == null ? (class$charva$awt$Color = Color.class$("charva.awt.Color")) : class$charva$awt$Color));
    private int _red;
    private int _green;
    private int _blue;
    public static final Color black = new Color(0, 0, 0);
    public static final Color red = new Color(255, 0, 0);
    public static final Color green = new Color(0, 255, 0);
    public static final Color yellow = new Color(255, 255, 0);
    public static final Color blue = new Color(0, 0, 255);
    public static final Color magenta = new Color(255, 0, 255);
    public static final Color cyan = new Color(0, 255, 255);
    public static final Color white = new Color(255, 255, 255);
    static /* synthetic */ Class class$charva$awt$Color;

    public Color(int n, int n2, int n3) {
        this._red = n != 0 ? 255 : 0;
        this._green = n2 != 0 ? 255 : 0;
        this._blue = n3 != 0 ? 255 : 0;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Color)) {
            return false;
        }
        Color color = (Color)object;
        if (this._red != color._red) {
            return false;
        }
        if (this._green != color._green) {
            return false;
        }
        return this._blue == color._blue;
    }

    public int getCursesColor() {
        if (this._red != 0) {
            if (this._green != 0) {
                if (this._blue != 0) {
                    return Toolkit.WHITE;
                }
                return Toolkit.YELLOW;
            }
            if (this._blue != 0) {
                return Toolkit.MAGENTA;
            }
            return Toolkit.RED;
        }
        if (this._green != 0) {
            if (this._blue != 0) {
                return Toolkit.CYAN;
            }
            return Toolkit.GREEN;
        }
        if (this._blue != 0) {
            return Toolkit.BLUE;
        }
        return Toolkit.BLACK;
    }

    public String toString() {
        if (this._red != 0) {
            if (this._green != 0) {
                if (this._blue != 0) {
                    return "white";
                }
                return "cyan";
            }
            if (this._blue != 0) {
                return "magenta";
            }
            return "red";
        }
        if (this._green != 0) {
            if (this._blue != 0) {
                return "white";
            }
            return "green";
        }
        if (this._blue != 0) {
            return "blue";
        }
        return "black";
    }

    public static int getCursesColor(Color color, Color color2) {
        if (!Toolkit.isColorEnabled) {
            return 0;
        }
        int n = 0;
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (toolkit.hasColors()) {
                ColorPair colorPair = new ColorPair(color, color2);
                n = toolkit.getColorPairIndex(colorPair);
            }
        }
        catch (TerminfoCapabilityException terminfoCapabilityException) {
            LOG.warn((Object)("can't set color pair: foreground " + color + " background " + color2));
        }
        return n;
    }

    public static String getColorName(int n) {
        if (n == Toolkit.BLACK) {
            return "black";
        }
        if (n == Toolkit.RED) {
            return "red";
        }
        if (n == Toolkit.GREEN) {
            return "green";
        }
        if (n == Toolkit.YELLOW) {
            return "yellow";
        }
        if (n == Toolkit.BLUE) {
            return "blue";
        }
        if (n == Toolkit.MAGENTA) {
            return "magenta";
        }
        if (n == Toolkit.CYAN) {
            return "cyan";
        }
        if (n == Toolkit.WHITE) {
            return "white";
        }
        return "UNKNOWN";
    }

    public static Color fromCursesColor(int n) {
        if (n == Toolkit.BLACK) {
            return black;
        }
        if (n == Toolkit.RED) {
            return red;
        }
        if (n == Toolkit.GREEN) {
            return green;
        }
        if (n == Toolkit.YELLOW) {
            return yellow;
        }
        if (n == Toolkit.BLUE) {
            return blue;
        }
        if (n == Toolkit.MAGENTA) {
            return magenta;
        }
        if (n == Toolkit.CYAN) {
            return cyan;
        }
        if (n == Toolkit.WHITE) {
            return white;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

