/*
 * Decompiled with CFR 0.152.
 */
package charva.awt;

import charva.awt.Color;
import charva.awt.Container;
import charva.awt.Dimension;
import charva.awt.EventQueue;
import charva.awt.IllegalComponentStateException;
import charva.awt.Point;
import charva.awt.Rectangle;
import charva.awt.Toolkit;
import charva.awt.Window;
import charva.awt.event.AWTEvent;
import charva.awt.event.FocusEvent;
import charva.awt.event.FocusListener;
import charva.awt.event.KeyEvent;
import charva.awt.event.KeyListener;
import charva.awt.event.MouseEvent;
import charva.awt.event.PaintEvent;
import charva.awt.event.SyncEvent;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Component {
    private static final Log LOG = LogFactory.getLog((Class)(class$charva$awt$Component == null ? (class$charva$awt$Component = Component.class$("charva.awt.Component")) : class$charva$awt$Component));
    private boolean _hadFocus = false;
    protected Point _origin = new Point(0, 0);
    protected WeakReference _parent = null;
    protected boolean _enabled = true;
    protected boolean _visible = true;
    protected Vector _keyListeners = null;
    protected Vector _focusListeners = null;
    protected float _alignmentX = 0.0f;
    protected float _alignmentY = 0.0f;
    private String _name = "";
    protected Color _foreground = null;
    protected Color _background = null;
    protected int _cursesColor = 0;
    public static final float TOP_ALIGNMENT = 0.0f;
    public static final float CENTER_ALIGNMENT = 0.5f;
    public static final float BOTTOM_ALIGNMENT = 1.0f;
    public static final float LEFT_ALIGNMENT = 0.0f;
    public static final float RIGHT_ALIGNMENT = 1.0f;
    static /* synthetic */ Class class$charva$awt$Component;

    public void setVisible(boolean bl) {
        if (bl) {
            this.show();
        } else {
            this.hide();
        }
    }

    public void show() {
        if (!this._visible) {
            this._visible = true;
            this.repaint();
        }
    }

    public void hide() {
        if (this._visible) {
            this._visible = false;
            if (this.hasFocus()) {
                this.getParent().nextFocus();
                if (this.hasFocus()) {
                    this.getParent().previousFocus();
                    if (this.hasFocus()) {
                        throw new IllegalComponentStateException("cannot hide component; it was the only focusTraversable component in this window");
                    }
                }
            }
            this.repaint();
        }
    }

    public boolean isVisible() {
        return this._visible;
    }

    public abstract void draw();

    public boolean isDisplayed() {
        Container container = this.getParent();
        if (container == null) {
            return false;
        }
        return container.isDisplayed();
    }

    public Point getLocation() {
        return new Point(this._origin);
    }

    public void setLocation(Point point) {
        this._origin = new Point(point);
    }

    public void setLocation(int n, int n2) {
        this._origin.x = n;
        this._origin.y = n2;
    }

    public Point getLocationOnScreen() {
        Container container = this.getParent();
        if (container == null) {
            throw new IllegalComponentStateException("cannot get component location before it has been added to a container");
        }
        return container.getLocationOnScreen().addOffset(this._origin);
    }

    public abstract Dimension getSize();

    public abstract int getWidth();

    public abstract int getHeight();

    public Rectangle getBounds() {
        return new Rectangle(this._origin, this.getSize());
    }

    public void setBounds(Rectangle rectangle) {
        this.setLocation(rectangle.getLeft(), rectangle.getTop());
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.setLocation(n2, n);
    }

    public void setBounds(Point point, Dimension dimension) {
        this.setLocation(point);
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(int n, int n2) {
        return this.getBounds().contains(n, n2);
    }

    public abstract Dimension minimumSize();

    public void setParent(Container container) {
        this._parent = new WeakReference<Container>(container);
        if (this.getForeground() == null) {
            this.setForeground(container.getForeground());
        }
        if (this.getBackground() == null) {
            this.setBackground(container.getBackground());
        }
    }

    public Container getParent() {
        if (this._parent == null) {
            return null;
        }
        return (Container)this._parent.get();
    }

    public void addKeyListener(KeyListener keyListener) {
        if (this._keyListeners == null) {
            this._keyListeners = new Vector();
        }
        if (!this._keyListeners.contains(keyListener)) {
            this._keyListeners.add(keyListener);
        }
    }

    public void addFocusListener(FocusListener focusListener) {
        if (this._focusListeners == null) {
            this._focusListeners = new Vector();
        }
        if (!this._focusListeners.contains(focusListener)) {
            this._focusListeners.add(focusListener);
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)aWTEvent;
            this.getAncestorWindow().processKeyEvent(keyEvent);
        } else if (aWTEvent instanceof FocusEvent) {
            this.processFocusEvent((FocusEvent)aWTEvent);
        } else if (aWTEvent instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            this.processMouseEvent(mouseEvent);
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (this._keyListeners != null) {
            Enumeration enumeration = this._keyListeners.elements();
            while (enumeration.hasMoreElements()) {
                KeyListener keyListener = (KeyListener)enumeration.nextElement();
                if (keyEvent.getID() == 1) {
                    keyListener.keyPressed(keyEvent);
                } else if (keyEvent.getID() == 2) {
                    keyListener.keyTyped(keyEvent);
                }
                if (!keyEvent.isConsumed()) continue;
                break;
            }
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && mouseEvent.getModifiers() == 100 && this.isFocusTraversable()) {
            this.requestFocus();
        }
    }

    public void processFocusEvent(FocusEvent focusEvent) {
        LOG.debug((Object)("processFocusEvent:" + this.toString() + " ev:" + focusEvent.toString()));
        if (this._focusListeners != null) {
            Enumeration enumeration = this._focusListeners.elements();
            while (enumeration.hasMoreElements()) {
                FocusListener focusListener = (FocusListener)enumeration.nextElement();
                if (focusEvent.getID() == 7) {
                    focusListener.focusGained(focusEvent);
                    continue;
                }
                focusListener.focusLost(focusEvent);
            }
        }
    }

    public Window getAncestorWindow() {
        if (this instanceof Window) {
            return (Window)this;
        }
        Container container = this.getParent();
        while (!(container instanceof Window)) {
            if (container == null) {
                return null;
            }
            Container container2 = container.getParent();
            if (container2 == null) {
                return null;
            }
            container = container2;
        }
        return (Window)container;
    }

    public void requestFocus() {
        boolean bl = false;
        Window window = this.getAncestorWindow();
        Component component = window.getCurrentFocus();
        Window window2 = Toolkit.getDefaultToolkit().getTopWindow();
        Component component2 = window2.getCurrentFocus();
        if (component != this || component2 == this && !this._hadFocus) {
            FocusEvent focusEvent;
            this._hadFocus = true;
            EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            FocusEvent focusEvent2 = Toolkit.getDefaultToolkit().getLastFocusEvent();
            if (focusEvent2 != null) {
                component = (Component)focusEvent2.getSource();
                bl = component != null && component.getAncestorWindow() != null && component.getAncestorWindow().isEnabled() && component.getAncestorWindow() != window;
                focusEvent = new FocusEvent(6, component, bl, this);
                eventQueue.postEvent(focusEvent);
            } else {
                component = null;
            }
            focusEvent = new FocusEvent(7, this, bl, component);
            eventQueue.postEvent(focusEvent);
            this.getParent().setFocus(this);
            this.repaint();
        }
    }

    public boolean hasFocus() {
        Window window = this.getAncestorWindow();
        if (window == null) {
            return false;
        }
        return window.getCurrentFocus() == this;
    }

    public boolean isFocusTraversable() {
        return this._enabled && this._visible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTotallyObscured() {
        Rectangle rectangle = this.getBounds();
        Window window = this.getAncestorWindow();
        Vector vector = Toolkit.getDefaultToolkit().getWindowList();
        boolean bl = false;
        Vector vector2 = vector;
        synchronized (vector2) {
            Window window2;
            int n;
            for (n = 0; n < vector.size() && (window2 = (Window)vector.elementAt(n)) != window; ++n) {
            }
            ++n;
            while (n < vector.size()) {
                window2 = (Window)vector.elementAt(n);
                Rectangle rectangle2 = window2.getBounds();
                if (rectangle.equals(rectangle2.intersection(rectangle))) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    public float getAlignmentX() {
        return this._alignmentX;
    }

    public float getAlignmentY() {
        return this._alignmentY;
    }

    public Color getForeground() {
        return this._foreground;
    }

    public Color getBackground() {
        return this._background;
    }

    public void setForeground(Color color) {
        this._foreground = color;
        this.validateCursesColor();
    }

    public void setBackground(Color color) {
        this._background = color;
        this.validateCursesColor();
    }

    public void setEnabled(boolean bl) {
        this._enabled = bl;
        this.repaint();
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void invalidate() {
        Container container = this.getParent();
        if (container != null) {
            container.invalidate();
        }
    }

    public void validate() {
    }

    public void repaint() {
        if (!this.isDisplayed()) {
            return;
        }
        PaintEvent paintEvent = new PaintEvent(this, this.getBounds());
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        eventQueue.postEvent(paintEvent);
    }

    public void requestSync() {
        SyncEvent syncEvent = new SyncEvent(this);
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        eventQueue.postEvent(syncEvent);
    }

    public boolean isValid() {
        return true;
    }

    public abstract void debug(int var1);

    public void setName(String string) {
        this._name = string;
    }

    public String getName() {
        return this._name;
    }

    public void validateCursesColor() {
        if (this._foreground == null || this._background == null) {
            return;
        }
        this._cursesColor = Color.getCursesColor(this._foreground, this._background);
    }

    public int getCursesColor() {
        return this._cursesColor;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

