/*
 * Decompiled with CFR 0.152.
 */
package charva.awt;

import charva.awt.BorderLayout;
import charva.awt.Color;
import charva.awt.Component;
import charva.awt.Dimension;
import charva.awt.IllegalComponentStateException;
import charva.awt.Insets;
import charva.awt.LayoutManager;
import charva.awt.LayoutManager2;
import charva.awt.Point;
import charva.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Container
extends Component {
    protected Vector _components = new Vector();
    protected Dimension _size = new Dimension(1, 1);
    protected LayoutManager _layoutMgr = null;
    protected Component _currentFocus = null;
    protected Insets _insets = new Insets(0, 0, 0, 0);
    protected boolean _isValid = false;
    protected Dimension _minimumSize;

    public void doLayout() {
        if (this._isValid) {
            return;
        }
        if (this._layoutMgr != null) {
            this._layoutMgr.doLayout(this);
            if (!(this._layoutMgr instanceof LayoutManager2)) {
                this._isValid = true;
            }
        }
    }

    public Dimension getSize() {
        return new Dimension(this._size);
    }

    public int getHeight() {
        return this._size.height;
    }

    public int getWidth() {
        return this._size.width;
    }

    public void setSize(Dimension dimension) {
        this._size = new Dimension(dimension);
        this.invalidate();
    }

    public void setSize(int n, int n2) {
        this._size.width = n;
        this._size.height = n2;
        this.invalidate();
    }

    public void setHeight(int n) {
        this._size.height = n;
        this.invalidate();
    }

    public void setWidth(int n) {
        this._size.width = n;
        this.invalidate();
    }

    public Dimension minimumSize() {
        if (this._layoutMgr == null) {
            return this._size;
        }
        if (!this._isValid) {
            this._minimumSize = this._layoutMgr.minimumSize(this);
        }
        return this._minimumSize;
    }

    public Component getComponent(int n) {
        return (Component)this._components.elementAt(n);
    }

    public Component getComponentAt(Point point) {
        return this.getComponentAt(point.x, point.y);
    }

    public Component getComponentAt(int n, int n2) {
        Enumeration enumeration = this._components.elements();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            if (!component.contains(n, n2)) continue;
            if (component instanceof Container) {
                Point point = component.getLocation();
                return ((Container)component).getComponentAt(n - point.x, n2 - point.y);
            }
            return component;
        }
        return null;
    }

    public Component add(Component component) {
        this._addComponent(component);
        if (this._layoutMgr != null && this._layoutMgr instanceof LayoutManager2) {
            if (this._layoutMgr instanceof BorderLayout) {
                ((BorderLayout)this._layoutMgr).addLayoutComponent(component, "Center");
            } else {
                throw new IllegalArgumentException("LayoutManager2 requires a constraint object");
            }
        }
        this.invalidate();
        return component;
    }

    public void remove(Component component) {
        this._components.remove(component);
        component.setParent(null);
        if (this._currentFocus == component) {
            this._currentFocus = null;
            this._currentFocus = this.getCurrentFocus();
        }
        this.invalidate();
    }

    private void _addComponent(Component component) {
        this._components.addElement(component);
        component.setParent(this);
    }

    public void add(Component component, Object object) {
        this._addComponent(component);
        if (this._layoutMgr != null && this._layoutMgr instanceof LayoutManager2) {
            ((LayoutManager2)this._layoutMgr).addLayoutComponent(component, object);
        }
    }

    public void setLayout(LayoutManager layoutManager) {
        this._layoutMgr = layoutManager;
    }

    public Component[] getComponents() {
        int n = this._components.size();
        Component[] componentArray = new Component[n];
        for (int i = 0; i < n; ++i) {
            componentArray[i] = (Component)this._components.elementAt(i);
        }
        return componentArray;
    }

    public int getComponentCount() {
        return this._components.size();
    }

    public void draw() {
        if (!this.isVisible()) {
            return;
        }
        Enumeration enumeration = this._components.elements();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            if (!component.isVisible()) continue;
            component.draw();
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        Enumeration enumeration = this._components.elements();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            if (component.getForeground() != null) continue;
            component.setForeground(color);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        Enumeration enumeration = this._components.elements();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            if (component.getBackground() != null) continue;
            component.setBackground(color);
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        if (this._currentFocus != null) {
            this._currentFocus.processKeyEvent(keyEvent);
        }
    }

    public void requestFocus() {
        this.getCurrentFocus().requestFocus();
    }

    public Component getCurrentFocus() {
        if (this._currentFocus == null) {
            Enumeration enumeration = this._components.elements();
            while (enumeration.hasMoreElements()) {
                Component component = (Component)enumeration.nextElement();
                if (!component.isFocusTraversable()) continue;
                this._currentFocus = component;
                break;
            }
        }
        if (this._currentFocus == null) {
            throw new IllegalComponentStateException("no focus-traversable components inside this Container");
        }
        if (this._currentFocus instanceof Container) {
            return ((Container)this._currentFocus).getCurrentFocus();
        }
        return this._currentFocus;
    }

    public void nextFocus() {
        Component component;
        int n = this._components.indexOf(this._currentFocus);
        if (n == -1) {
            throw new IllegalComponentStateException("focus component not found in parent");
        }
        do {
            if (++n < this._components.size()) continue;
            if (this.getParent() != null) {
                this.getParent().nextFocus();
                return;
            }
            n = 0;
        } while (!(component = (Component)this._components.elementAt(n)).isFocusTraversable());
        if (component instanceof Container) {
            ((Container)component).firstFocus();
        }
        component.requestFocus();
    }

    public void previousFocus() {
        Component component;
        int n = this._components.indexOf(this._currentFocus);
        if (n == -1) {
            throw new IllegalArgumentException("focus component not found in parent");
        }
        do {
            if (--n >= 0) continue;
            if (this.getParent() != null) {
                this.getParent().previousFocus();
                return;
            }
            n = this._components.size() - 1;
        } while (!(component = (Component)this._components.elementAt(n)).isFocusTraversable());
        if (component instanceof Container) {
            ((Container)component).lastFocus();
        }
        component.requestFocus();
    }

    public void setFocus(Component component) {
        this._currentFocus = component;
        if (this.getParent() != null) {
            this.getParent().setFocus(this);
        }
    }

    public boolean isFocusTraversable() {
        if (!super.isFocusTraversable()) {
            return false;
        }
        Enumeration enumeration = this._components.elements();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            if (!component.isFocusTraversable()) continue;
            return true;
        }
        return false;
    }

    public Insets getInsets() {
        return this._insets;
    }

    public void debug(int n) {
        Enumeration enumeration = this._components.elements();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            component.debug(n + 1);
        }
    }

    private void firstFocus() {
        Enumeration enumeration = this._components.elements();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            if (!component.isFocusTraversable()) continue;
            if (component instanceof Container) {
                ((Container)component).firstFocus();
            }
            this._currentFocus = component;
            return;
        }
    }

    private void lastFocus() {
        for (int i = this._components.size() - 1; i >= 0; --i) {
            Component component = (Component)this._components.elementAt(i);
            if (!component.isFocusTraversable()) continue;
            if (component instanceof Container) {
                ((Container)component).lastFocus();
            }
            this._currentFocus = component;
            return;
        }
    }

    public void validate() {
        if (this._isValid) {
            return;
        }
        this.doLayout();
    }

    public boolean isValid() {
        return this._isValid;
    }

    public void invalidate() {
        this._isValid = false;
        super.invalidate();
    }
}

