/*
 * Decompiled with CFR 0.152.
 */
package charva.awt;

import charva.awt.Toolkit;
import charva.awt.event.AWTEvent;
import charva.awt.event.FocusEvent;
import charva.awt.event.InvocationEvent;
import charva.awt.event.SyncEvent;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventQueue {
    private static final Log LOG = LogFactory.getLog((Class)(class$charva$awt$EventQueue == null ? (class$charva$awt$EventQueue = EventQueue.class$("charva.awt.EventQueue")) : class$charva$awt$EventQueue));
    private LinkedList _lowPriorityQueue = new LinkedList();
    private LinkedList _highPriorityQueue = new LinkedList();
    private static volatile EventQueue _instance = null;
    static /* synthetic */ Class class$charva$awt$EventQueue;

    private EventQueue() {
    }

    public static synchronized EventQueue getInstance() {
        if (_instance == null) {
            _instance = new EventQueue();
        }
        return _instance;
    }

    public synchronized void postEvent(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 7) {
            Toolkit.getDefaultToolkit().setLastFocusEvent((FocusEvent)aWTEvent);
        }
        this.addLast(aWTEvent);
        this.notifyAll();
    }

    public synchronized AWTEvent waitForNextEvent() {
        while (this.queuesAreEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return (AWTEvent)this.removeFirst();
    }

    public synchronized AWTEvent getNextEvent() {
        return (AWTEvent)this.removeFirst();
    }

    public static void invokeLater(Runnable runnable) {
        EventQueue.getInstance().postEvent(new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable));
    }

    public synchronized boolean queuesAreEmpty() {
        return this._lowPriorityQueue.size() == 0 && this._highPriorityQueue.size() == 0;
    }

    private void addLast(AWTEvent aWTEvent) {
        if (aWTEvent instanceof SyncEvent) {
            this._lowPriorityQueue.addLast(aWTEvent);
        } else {
            this._highPriorityQueue.addLast(aWTEvent);
        }
    }

    private Object removeFirst() {
        if (this._highPriorityQueue.size() > 0) {
            return this._highPriorityQueue.removeFirst();
        }
        if (LOG.isDebugEnabled()) {
            if (this._lowPriorityQueue.size() > 1) {
                LOG.debug((Object)("Coalescing " + this._lowPriorityQueue.size() + " SyncEvents on queue"));
            } else {
                LOG.debug((Object)"1 SyncEvent");
            }
        }
        Object var1_1 = null;
        while (this._lowPriorityQueue.size() > 0) {
            var1_1 = this._lowPriorityQueue.removeFirst();
        }
        return var1_1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

