/*
 * Decompiled with CFR 0.152.
 */
package charva.awt;

import charva.awt.Component;
import charva.awt.Container;
import charva.awt.Dimension;
import charva.awt.Insets;
import charva.awt.LayoutManager;
import java.util.Enumeration;
import java.util.Vector;

public class FlowLayout
implements LayoutManager {
    private int _align = 2;
    private int _hgap = 1;
    private int _vgap = 0;
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;

    public FlowLayout() {
        this(2, 1, 0);
    }

    public FlowLayout(int n, int n2, int n3) {
        this._align = n;
        this._hgap = n2;
        this._vgap = n3;
    }

    public void setAlignment(int n) {
        this._align = n;
    }

    public int getAlignment() {
        return this._align;
    }

    public Dimension minimumSize(Container container) {
        int n = 0;
        int n2 = 0;
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Dimension dimension = componentArray[i].minimumSize();
            if (i != 0) {
                n += this._hgap;
            }
            n += dimension.width;
            if (dimension.height <= n2) continue;
            n2 = dimension.height;
        }
        Insets insets = container.getInsets();
        return new Dimension(n += insets.left + insets.right, n2 += insets.top + insets.bottom);
    }

    public void doLayout(Container container) {
        int n;
        Insets insets = container.getInsets();
        int n2 = n = container.getSize().width - insets.left - insets.right;
        int n3 = container.getSize().height - insets.top - insets.bottom;
        int n4 = insets.top;
        Component[] componentArray = container.getComponents();
        Vector<Component> vector = new Vector<Component>();
        for (int i = 0; i < componentArray.length; ++i) {
            Container container2;
            Component component = componentArray[i];
            if (component instanceof Container && !(container2 = (Container)component).isValid()) {
                container2.setSize(container2.minimumSize());
                container2.doLayout();
            }
            int n5 = component.getSize().width;
            if (i != 0) {
                n5 += this._hgap;
            }
            if (n5 > n2) {
                int n6 = 0;
                if (vector.size() != 0) {
                    n6 = this.layoutRow(container, vector, n2, n3, n4);
                    vector.removeAllElements();
                }
                n4 += n6 + this._vgap;
                n2 = n;
                n3 -= n6 + this._vgap;
            }
            n2 -= n5;
            vector.add(component);
        }
        this.layoutRow(container, vector, n2, n3, n4);
    }

    private int layoutRow(Container container, Vector vector, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        Insets insets = container.getInsets();
        switch (this._align) {
            case 1: {
                n4 = insets.left;
                break;
            }
            case 2: {
                n4 = insets.left + n / 2;
                break;
            }
            case 3: {
                n4 = insets.left + n;
            }
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            if (component.getSize().height > n5) {
                n5 = component.getSize().height;
            }
            if (n5 > n2) {
                container.remove(component);
                continue;
            }
            component.setLocation(n4, n3);
            n4 += component.getSize().width + this._hgap;
        }
        return n5;
    }
}

