/*
 * Decompiled with CFR 0.152.
 */
package charva.awt;

import charva.awt.MouseEventInfo;
import charva.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlaybackThread
extends Thread {
    private File _scriptFile;
    private Toolkit _toolkit;
    private int numberOfLoops = 1;
    private long playbackRate = 1L;
    private static final Log LOG = LogFactory.getLog((Class)(class$charva$awt$PlaybackThread == null ? (class$charva$awt$PlaybackThread = PlaybackThread.class$("charva.awt.PlaybackThread")) : class$charva$awt$PlaybackThread));
    static /* synthetic */ Class class$charva$awt$PlaybackThread;

    PlaybackThread(File file) {
        String string;
        this._scriptFile = file;
        this._toolkit = Toolkit.getDefaultToolkit();
        String string2 = System.getProperty("charva.script.playbackLoops");
        if (string2 != null) {
            try {
                this.numberOfLoops = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                LOG.warn((Object)("Property charva.script.playbackLoops (value=[" + string2 + "" + "]) must be an integer!"));
            }
            if (this.numberOfLoops <= 0) {
                LOG.warn((Object)("Property charva.script.playbackLoops (value=[" + string2 + "" + "]) must be greater than 0!"));
                this.numberOfLoops = 1;
            }
        }
        if ((string = System.getProperty("charva.script.playbackRate")) != null) {
            this.playbackRate = Long.parseLong(string);
            if (this.playbackRate < 1L) {
                LOG.warn((Object)("Property charva.script.playbackRate (value=" + string + ") must be greater than 1!"));
                this.playbackRate = 1L;
            }
        }
    }

    public void run() {
        try {
            for (int i = 0; i < this.numberOfLoops; ++i) {
                LOG.debug((Object)("Starting script loop " + (i + 1) + " out of " + this.numberOfLoops));
                this.runScriptOnce(this._scriptFile);
                LOG.debug((Object)("Ended script loop " + (i + 1)));
            }
        }
        catch (IOException iOException) {
            LOG.warn((Object)("Error reading script file: " + iOException.getMessage()));
        }
    }

    private void runScriptOnce(File file) throws IOException {
        String string;
        int n = 0;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        while ((string = bufferedReader.readLine()) != null) {
            int n2;
            String string2;
            String string3;
            ++n;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string4 = stringTokenizer.nextToken();
            long l = Long.parseLong(string4);
            if (l > 500L) {
                l /= this.playbackRate;
            }
            if ((string3 = stringTokenizer.nextToken()).equals("KEY")) {
                string2 = stringTokenizer.nextToken();
                n2 = Integer.parseInt(string2, 16);
                if (l != 0L) {
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this._toolkit.fireKeystroke(n2);
                continue;
            }
            if (string3.equals("MOUSE")) {
                string2 = stringTokenizer.nextToken();
                n2 = Integer.parseInt(string2);
                String string5 = stringTokenizer.nextToken();
                int n3 = Integer.parseInt(string5);
                String string6 = stringTokenizer.nextToken();
                int n4 = Integer.parseInt(string6);
                MouseEventInfo mouseEventInfo = new MouseEventInfo(n2, n3, n4);
                if (l != 0L) {
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Mouse-click (button " + n2 + ") at (" + mouseEventInfo.getX() + "," + mouseEventInfo.getY() + ")"));
                }
                this._toolkit.fireMouseEvent(mouseEventInfo);
                continue;
            }
            throw new IOException("Parse error [" + string + "] on line " + n + " of script file " + file.getAbsolutePath());
        }
        bufferedReader.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

