/*
 * Decompiled with CFR 0.152.
 */
package charva.awt;

import charva.awt.Dimension;
import charva.awt.Rectangle;

public class Point
implements Cloneable {
    public int x;
    public int y;

    public Point(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public Point(Point point) {
        this.x = point.x;
        this.y = point.y;
    }

    public Point addOffset(Point point) {
        return new Point(this.x + point.x, this.y + point.y);
    }

    public Point addOffset(Dimension dimension) {
        return new Point(this.x + dimension.width, this.y + dimension.height);
    }

    public Point addOffset(int n, int n2) {
        return new Point(this.x + n, this.y + n2);
    }

    public Point subtractOffset(Point point) {
        return new Point(this.x - point.x, this.y - point.y);
    }

    public void translate(int n, int n2) {
        this.x += n;
        this.y += n2;
    }

    public void translate(Point point) {
        this.x += point.x;
        this.y += point.y;
    }

    public boolean isInside(Rectangle rectangle) {
        if (this.x < rectangle.getLeft()) {
            return false;
        }
        if (this.x > rectangle.getRight()) {
            return false;
        }
        if (this.y < rectangle.getTop()) {
            return false;
        }
        return this.y <= rectangle.getBottom();
    }

    public boolean equals(Point point) {
        return this.x == point.x && this.y == point.y;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public Object clone() {
        return new Point(this);
    }
}

