/*
 * Decompiled with CFR 0.152.
 */
package charva.awt;

import charva.awt.Dimension;
import charva.awt.Point;

public class Rectangle {
    private int _top;
    private int _left;
    private int _bottom;
    private int _right;

    public Rectangle(int n, int n2, int n3, int n4) {
        this._top = n;
        this._left = n2;
        this._bottom = n3;
        this._right = n4;
    }

    public Rectangle(Point point, Point point2) {
        this._top = point.y;
        this._left = point.x;
        this._bottom = point2.y;
        this._right = point2.x;
    }

    public Rectangle(Point point, Dimension dimension) {
        this._top = point.y;
        this._left = point.x;
        this._bottom = this._top + dimension.height - 1;
        this._right = this._left + dimension.width - 1;
    }

    public Rectangle(Rectangle rectangle) {
        this._top = rectangle.getTop();
        this._left = rectangle.getLeft();
        this._bottom = rectangle.getBottom();
        this._right = rectangle.getRight();
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(int n, int n2) {
        return n >= this._left && n <= this._right && n2 >= this._top && n2 <= this._bottom;
    }

    public int getLeft() {
        return this._left;
    }

    public int getRight() {
        return this._right;
    }

    public int getTop() {
        return this._top;
    }

    public int getBottom() {
        return this._bottom;
    }

    public boolean intersects(Rectangle rectangle) {
        if (rectangle._left > this._right) {
            return false;
        }
        if (rectangle._right < this._left) {
            return false;
        }
        if (rectangle._top > this._bottom) {
            return false;
        }
        return rectangle._bottom >= this._top;
    }

    public Rectangle intersection(Rectangle rectangle) {
        if (this._top > rectangle._bottom) {
            return null;
        }
        if (this._bottom < rectangle._top) {
            return null;
        }
        if (this._left > rectangle._right) {
            return null;
        }
        if (this._right < rectangle._left) {
            return null;
        }
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        rectangle2._left = this._left > rectangle._left ? this._left : rectangle._left;
        rectangle2._right = this._right < rectangle._right ? this._right : rectangle._right;
        rectangle2._top = this._top > rectangle._top ? this._top : rectangle._top;
        rectangle2._bottom = this._bottom < rectangle._bottom ? this._bottom : rectangle._bottom;
        return rectangle2;
    }

    public boolean equals(Rectangle rectangle) {
        if (rectangle == null) {
            return false;
        }
        if (this._top != rectangle._top) {
            return false;
        }
        if (this._bottom != rectangle._bottom) {
            return false;
        }
        if (this._left != rectangle._left) {
            return false;
        }
        return this._right == rectangle._right;
    }

    public Object clone() {
        return new Rectangle(this._top, this._left, this._bottom, this._right);
    }

    public String toString() {
        return "(" + this._top + "," + this._left + "," + this._bottom + "," + this._right + ")";
    }
}

