/*
 * Decompiled with CFR 0.152.
 */
package charva.awt;

import charva.awt.EventQueue;
import charva.awt.SyncThread;
import charva.awt.event.AWTEvent;
import java.util.LinkedList;

class SyncQueue
extends LinkedList {
    private static SyncQueue _instance;

    private SyncQueue() {
    }

    public static SyncQueue getInstance() {
        if (_instance == null) {
            _instance = new SyncQueue();
            SyncThread syncThread = new SyncThread(_instance, EventQueue.getInstance());
            syncThread.setDaemon(true);
            syncThread.setName("sync thread");
            syncThread.start();
        }
        return _instance;
    }

    public synchronized void postEvent(AWTEvent aWTEvent) {
        _instance.addLast(aWTEvent);
        _instance.notifyAll();
    }

    public synchronized AWTEvent getNextEvent() {
        while (super.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return (AWTEvent)_instance.removeFirst();
    }

    public synchronized boolean isEmpty() {
        return _instance.size() == 0;
    }
}

