/*
 * Decompiled with CFR 0.152.
 */
package charva.awt;

import charva.awt.Color;
import charva.awt.ColorPair;
import charva.awt.Component;
import charva.awt.Container;
import charva.awt.Dimension;
import charva.awt.EventQueue;
import charva.awt.MouseEventInfo;
import charva.awt.Point;
import charva.awt.Rectangle;
import charva.awt.TerminfoCapabilityException;
import charva.awt.Window;
import charva.awt.event.FocusEvent;
import charva.awt.event.GarbageCollectionEvent;
import charva.awt.event.KeyEvent;
import charva.awt.event.MouseEvent;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Toolkit {
    private static final Log LOG = LogFactory.getLog((Class)(class$charva$awt$Toolkit == null ? (class$charva$awt$Toolkit = Toolkit.class$("charva.awt.Toolkit")) : class$charva$awt$Toolkit));
    private static Toolkit _instance = null;
    private static FocusEvent _lastFocusEvent = null;
    private Vector _windowList = new Vector();
    private Vector _colorPairs = new Vector();
    private EventQueue _evtQueue;
    private static PrintStream _scriptPrintStream = null;
    private long _prevTimeMillis = 0L;
    private long _lastMousePressTime;
    private long _lastMouseClickTime;
    public static final char Auml = '\u00c4';
    public static final char Ccedil = '\u00c7';
    public static final char Eacute = '\u00c9';
    public static final char Euml = '\u00cb';
    public static final char Ouml = '\u00d6';
    public static final char Uuml = '\u00dc';
    public static final boolean isColorEnabled;
    private StringBuffer scriptbuffer = new StringBuffer();
    public static final int A_NORMAL;
    public static final int A_STANDOUT;
    public static final int A_UNDERLINE;
    public static final int A_REVERSE;
    public static final int A_BLINK;
    public static final int A_DIM;
    public static final int A_BOLD;
    public static final int A_ALTCHARSET;
    public static final int A_INVIS;
    public static final int ACS_ULCORNER;
    public static final int ACS_LLCORNER;
    public static final int ACS_URCORNER;
    public static final int ACS_LRCORNER;
    public static final int ACS_LTEE;
    public static final int ACS_RTEE;
    public static final int ACS_BTEE;
    public static final int ACS_TTEE;
    public static final int ACS_HLINE;
    public static final int ACS_VLINE;
    public static final int ACS_PLUS;
    public static final int ACS_S1;
    public static final int ACS_S9;
    public static final int ACS_DIAMOND;
    public static final int ACS_CKBOARD;
    public static final int ACS_DEGREE;
    public static final int ACS_PLMINUS;
    public static final int ACS_BULLET;
    public static final int BLACK;
    public static final int RED;
    public static final int GREEN;
    public static final int YELLOW;
    public static final int BLUE;
    public static final int MAGENTA;
    public static final int CYAN;
    public static final int WHITE;
    public static Color _defaultForeground;
    public static Color _defaultBackground;
    public static final int KEY_MOUSE = 409;
    public static final int BUTTON1_RELEASED = 1;
    public static final int BUTTON1_PRESSED = 2;
    public static final int BUTTON1_CLICKED = 4;
    public static final int BUTTON2_RELEASED = 64;
    public static final int BUTTON2_PRESSED = 128;
    public static final int BUTTON2_CLICKED = 256;
    public static final int BUTTON3_RELEASED = 4096;
    public static final int BUTTON3_PRESSED = 8192;
    public static final int BUTTON3_CLICKED = 16384;
    static /* synthetic */ Class class$charva$awt$Toolkit;

    private Toolkit() {
        this._evtQueue = EventQueue.getInstance();
        if (this.hasColors() && isColorEnabled) {
            this.startColors();
            this._colorPairs.add(new ColorPair(_defaultForeground, _defaultBackground));
        }
    }

    public static Toolkit getDefaultToolkit() {
        if (_instance == null) {
            _instance = new Toolkit();
        }
        return _instance;
    }

    public EventQueue getSystemEventQueue() {
        return this._evtQueue;
    }

    public Window getTopWindow() {
        return (Window)this._windowList.lastElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWindowDisplayed(Window window) {
        boolean bl = false;
        Vector vector = this._windowList;
        synchronized (vector) {
            for (int i = 0; i < this._windowList.size(); ++i) {
                Window window2 = (Window)this._windowList.elementAt(i);
                if (window2 != window) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireKeystroke(int n) {
        Component component;
        Vector vector = this._windowList;
        synchronized (vector) {
            Window window = this.getTopWindow();
            component = window.getCurrentFocus();
            while (component instanceof Container) {
                component = ((Container)component).getCurrentFocus();
            }
        }
        this.fireKeystroke(n, component);
    }

    public void fireKeystroke(int n, Component component) {
        int n2 = Toolkit.isActionKey(n) ? 2 : 1;
        this._evtQueue.postEvent(new KeyEvent(n, n2, component));
    }

    public FocusEvent getLastFocusEvent() {
        return _lastFocusEvent;
    }

    protected void setLastFocusEvent(FocusEvent focusEvent) {
        _lastFocusEvent = focusEvent;
    }

    public void fireMouseEvent(MouseEventInfo mouseEventInfo) {
        Component component;
        Window window = this.getTopWindow();
        Point point = window.getLocation();
        int n = mouseEventInfo.x;
        int n2 = mouseEventInfo.y;
        int n3 = 0;
        int n4 = 0;
        switch (mouseEventInfo.button) {
            case 2: {
                n3 = 1;
                n4 = 100;
                break;
            }
            case 1: {
                n3 = 1;
                n4 = 101;
                break;
            }
            case 128: {
                n3 = 2;
                n4 = 100;
                break;
            }
            case 64: {
                n3 = 2;
                n4 = 101;
                break;
            }
            case 8192: {
                n3 = 3;
                n4 = 100;
                break;
            }
            case 4096: {
                n3 = 3;
                n4 = 101;
            }
        }
        if (!window.contains(n, n2)) {
            if (n4 == 100) {
                this.beep();
            }
            return;
        }
        if (n4 == 100) {
            this._lastMousePressTime = System.currentTimeMillis();
        }
        if ((component = window.getComponentAt(n - point.x, n2 - point.y)) != null) {
            this._evtQueue.postEvent(new MouseEvent(component, n4, n, n2, 0, n3));
            long l = System.currentTimeMillis();
            if (n4 == 101 && l - this._lastMousePressTime < 400L) {
                this._evtQueue.postEvent(new MouseEvent(component, 102, n, n2, 1, n3));
                if (l - this._lastMouseClickTime < 500L) {
                    this._evtQueue.postEvent(new MouseEvent(component, 102, n, n2, 2, n3));
                }
                this._lastMouseClickTime = l;
            }
        }
    }

    public void checkForKeystroke() {
        int n = this.readKey();
        MouseEventInfo mouseEventInfo = null;
        if (n == -1) {
            return;
        }
        if (n == 10 || n == 13) {
            n = 343;
        } else if (n == 8) {
            n = 263;
        }
        if (n == 409) {
            mouseEventInfo = this.getMouseEventInfo();
            this.fireMouseEvent(mouseEventInfo);
        } else {
            this.fireKeystroke(n);
        }
        if (_scriptPrintStream != null) {
            this.scriptbuffer.setLength(0);
            long l = System.currentTimeMillis();
            long l2 = 1000L;
            if (this._prevTimeMillis != 0L) {
                l2 = l - this._prevTimeMillis;
            }
            this._prevTimeMillis = l;
            this.scriptbuffer.append(l2).append(" ");
            if (n == 409) {
                this.scriptbuffer.append("MOUSE ").append(" ").append(mouseEventInfo.getButton()).append(" ").append(mouseEventInfo.getX()).append(" ").append(mouseEventInfo.getY());
            } else {
                this.scriptbuffer.append("KEY ");
                this.scriptbuffer.append(Integer.toHexString(n));
                this.scriptbuffer.append(" ");
                this.scriptbuffer.append(Toolkit.key2ASCII(n));
            }
            _scriptPrintStream.println(this.scriptbuffer.toString());
        }
    }

    public static String key2ASCII(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n < 32) {
            stringBuffer.append("^");
            stringBuffer.append((char)(n + 64));
        } else if (n == 32) {
            stringBuffer.append("SPACE");
        } else if (n < 127) {
            stringBuffer.append((char)n);
        } else {
            switch (n) {
                case 258: {
                    stringBuffer.append("VK_DOWN");
                    break;
                }
                case 259: {
                    stringBuffer.append("VK_UP");
                    break;
                }
                case 260: {
                    stringBuffer.append("VK_LEFT");
                    break;
                }
                case 261: {
                    stringBuffer.append("VK_RIGHT");
                    break;
                }
                case 262: {
                    stringBuffer.append("VK_HOME");
                    break;
                }
                case 263: {
                    stringBuffer.append("VK_BACK_SPACE");
                    break;
                }
                case 265: 
                case 266: 
                case 267: 
                case 268: 
                case 269: 
                case 270: 
                case 271: 
                case 272: 
                case 273: 
                case 274: 
                case 275: 
                case 276: 
                case 277: 
                case 278: 
                case 279: 
                case 280: 
                case 281: 
                case 282: 
                case 283: 
                case 284: 
                case 285: 
                case 286: 
                case 287: 
                case 288: 
                case 289: 
                case 290: 
                case 291: 
                case 292: 
                case 293: 
                case 294: 
                case 295: 
                case 296: 
                case 297: 
                case 298: 
                case 299: 
                case 300: 
                case 301: 
                case 302: 
                case 303: 
                case 304: 
                case 305: 
                case 306: 
                case 307: 
                case 308: 
                case 309: 
                case 310: 
                case 311: 
                case 312: {
                    stringBuffer.append("VK_F");
                    int n2 = 1 + n - 265;
                    stringBuffer.append(n2);
                    break;
                }
                case 330: {
                    stringBuffer.append("VK_DELETE");
                    break;
                }
                case 331: {
                    stringBuffer.append("VK_INSERT");
                    break;
                }
                case 338: {
                    stringBuffer.append("VK_PAGE_DOWN");
                    break;
                }
                case 339: {
                    stringBuffer.append("VK_PAGE_UP");
                    break;
                }
                case 343: {
                    stringBuffer.append("VK_ENTER");
                    break;
                }
                case 353: {
                    stringBuffer.append("VK_BACK_TAB");
                    break;
                }
                case 360: {
                    stringBuffer.append("VK_END");
                    break;
                }
                default: {
                    stringBuffer.append("UNKNOWN");
                }
            }
        }
        return stringBuffer.toString();
    }

    public native void close();

    public native void clear();

    public void setCursor(Point point) {
        this.setCursor(point.x, point.y);
    }

    public native void setCursor(int var1, int var2);

    public Point getCursor() {
        int n = this.getx();
        int n2 = this.gety();
        return new Point(n, n2);
    }

    public Point getCursor(Point point) {
        point.x = this.getx();
        point.y = this.gety();
        return point;
    }

    public native void addChar(int var1, int var2, int var3);

    public native void addHorizontalLine(int var1, int var2, int var3);

    public native void addVerticalLine(int var1, int var2, int var3);

    public native void addString(String var1, int var2, int var3);

    public void drawBox(Point point, Dimension dimension) {
        this.drawBoxNative(point.x, point.y, point.x + dimension.width - 1, point.y + dimension.height - 1, 0);
    }

    public void drawBox(Point point, Dimension dimension, int n) {
        this.drawBoxNative(point.x, point.y, point.x + dimension.width - 1, point.y + dimension.height - 1, n);
    }

    public native void drawBoxNative(int var1, int var2, int var3, int var4, int var5);

    public void blankBox(Point point, Dimension dimension) {
        this.blankBoxNative(point.x, point.y, point.x + dimension.width - 1, point.y + dimension.height - 1, 0);
    }

    public void blankBox(Point point, Dimension dimension, int n) {
        this.blankBoxNative(point.x, point.y, point.x + dimension.width - 1, point.y + dimension.height - 1, n);
    }

    public native void blankBoxNative(int var1, int var2, int var3, int var4, int var5);

    public void setClipRect(Rectangle rectangle) {
        this.setClipRectNative(rectangle.getLeft(), rectangle.getTop(), rectangle.getRight(), rectangle.getBottom());
    }

    public native void setClipRectNative(int var1, int var2, int var3, int var4);

    public native void resetClipRect();

    public native void beep();

    public native int getScreenRows();

    public native int getScreenColumns();

    public Dimension getScreenSize() {
        return new Dimension(this.getScreenColumns(), this.getScreenRows());
    }

    public native boolean hasColors();

    public native int getMaxColorPairs();

    public native void startColors();

    public int getColorPairIndex(ColorPair colorPair) throws TerminfoCapabilityException {
        int n = this._colorPairs.indexOf(colorPair);
        if (n != -1) {
            return n;
        }
        if (this._colorPairs.size() == this.getMaxColorPairs()) {
            throw new TerminfoCapabilityException("max number of color pairs (" + this.getMaxColorPairs() + ") exceeded");
        }
        n = this._colorPairs.size();
        this._colorPairs.add(colorPair);
        this.initColorPair(n, colorPair.getForeground(), colorPair.getBackground());
        return n;
    }

    public native void sync();

    public native void redrawWin();

    public native String getStringCapability(String var1) throws TerminfoCapabilityException;

    public native int getNumericCapability(String var1) throws TerminfoCapabilityException;

    public native boolean getBooleanCapability(String var1) throws TerminfoCapabilityException;

    public native void putp(String var1);

    public native void print(String var1) throws TerminfoCapabilityException;

    public native void initColorPair(int var1, int var2, int var3) throws TerminfoCapabilityException;

    public static int COLOR_PAIR_ATTRIBUTE(int n) {
        return n << 8;
    }

    public native String getTtyName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWindow(Window window) {
        Vector vector = this._windowList;
        synchronized (vector) {
            this._windowList.add(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeWindow(Window window) {
        Vector vector = this._windowList;
        synchronized (vector) {
            if (!this._windowList.remove(window)) {
                throw new RuntimeException("trying to remove window not in windowlist");
            }
        }
    }

    Vector getWindowList() {
        return this._windowList;
    }

    static native int getColor(int var0);

    public static void setDefaultForeground(Color color) {
        _defaultForeground = color;
    }

    public static Color getDefaultForeground() {
        return _defaultForeground;
    }

    public static void setDefaultBackground(Color color) {
        _defaultBackground = color;
    }

    public static Color getDefaultBackground() {
        return _defaultBackground;
    }

    public void triggerGarbageCollection(Component component) {
        this._evtQueue.postEvent(new GarbageCollectionEvent(component));
    }

    public native MouseEventInfo getMouseEventInfo();

    private native int readKey();

    private static native void init();

    private native int getx();

    private native int gety();

    private static native int getAttribute(int var0);

    private static native int getACSchar(int var0);

    public static boolean isActionKey(int n) {
        boolean bl = false;
        if (n == 27) {
            bl = true;
        }
        if (n == 258) {
            bl = true;
        }
        if (n == 259) {
            bl = true;
        }
        if (n == 260) {
            bl = true;
        }
        if (n == 261) {
            bl = true;
        }
        if (n == 262) {
            bl = true;
        }
        if (n == 263) {
            bl = true;
        }
        if (n == 265) {
            bl = true;
        }
        if (n == 266) {
            bl = true;
        }
        if (n == 267) {
            bl = true;
        }
        if (n == 268) {
            bl = true;
        }
        if (n == 269) {
            bl = true;
        }
        if (n == 270) {
            bl = true;
        }
        if (n == 271) {
            bl = true;
        }
        if (n == 272) {
            bl = true;
        }
        if (n == 273) {
            bl = true;
        }
        if (n == 274) {
            bl = true;
        }
        if (n == 275) {
            bl = true;
        }
        if (n == 276) {
            bl = true;
        }
        if (n == 277) {
            bl = true;
        }
        if (n == 278) {
            bl = true;
        }
        if (n == 279) {
            bl = true;
        }
        if (n == 280) {
            bl = true;
        }
        if (n == 281) {
            bl = true;
        }
        if (n == 282) {
            bl = true;
        }
        if (n == 283) {
            bl = true;
        }
        if (n == 284) {
            bl = true;
        }
        if (n == 285) {
            bl = true;
        }
        if (n == 286) {
            bl = true;
        }
        if (n == 287) {
            bl = true;
        }
        if (n == 288) {
            bl = true;
        }
        if (n == 289) {
            bl = true;
        }
        if (n == 290) {
            bl = true;
        }
        if (n == 291) {
            bl = true;
        }
        if (n == 292) {
            bl = true;
        }
        if (n == 293) {
            bl = true;
        }
        if (n == 294) {
            bl = true;
        }
        if (n == 295) {
            bl = true;
        }
        if (n == 296) {
            bl = true;
        }
        if (n == 297) {
            bl = true;
        }
        if (n == 298) {
            bl = true;
        }
        if (n == 299) {
            bl = true;
        }
        if (n == 300) {
            bl = true;
        }
        if (n == 301) {
            bl = true;
        }
        if (n == 302) {
            bl = true;
        }
        if (n == 303) {
            bl = true;
        }
        if (n == 304) {
            bl = true;
        }
        if (n == 305) {
            bl = true;
        }
        if (n == 306) {
            bl = true;
        }
        if (n == 307) {
            bl = true;
        }
        if (n == 308) {
            bl = true;
        }
        if (n == 309) {
            bl = true;
        }
        if (n == 310) {
            bl = true;
        }
        if (n == 311) {
            bl = true;
        }
        if (n == 312) {
            bl = true;
        }
        if (n == 330) {
            bl = true;
        }
        if (n == 331) {
            bl = true;
        }
        if (n == 338) {
            bl = true;
        }
        if (n == 339) {
            bl = true;
        }
        if (n == 343) {
            bl = true;
        }
        if (n == 353) {
            bl = true;
        }
        if (n == 360) {
            bl = true;
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string = System.getProperty("charva.script.record");
        if (string != null) {
            try {
                _scriptPrintStream = new PrintStream(new FileOutputStream(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                LOG.warn((Object)("Cannot open script file \"" + string + "\" for writing"));
                System.exit(1);
            }
        }
        System.loadLibrary("Terminal");
        Toolkit.init();
        isColorEnabled = System.getProperty("charva.color") != null;
        A_NORMAL = Toolkit.getAttribute(0);
        A_STANDOUT = Toolkit.getAttribute(1);
        A_UNDERLINE = Toolkit.getAttribute(2);
        A_REVERSE = Toolkit.getAttribute(3);
        A_BLINK = Toolkit.getAttribute(4);
        A_DIM = Toolkit.getAttribute(5);
        A_BOLD = Toolkit.getAttribute(6);
        A_ALTCHARSET = Toolkit.getAttribute(7);
        A_INVIS = Toolkit.getAttribute(8);
        ACS_ULCORNER = Toolkit.getACSchar(0);
        ACS_LLCORNER = Toolkit.getACSchar(1);
        ACS_URCORNER = Toolkit.getACSchar(2);
        ACS_LRCORNER = Toolkit.getACSchar(3);
        ACS_LTEE = Toolkit.getACSchar(4);
        ACS_RTEE = Toolkit.getACSchar(5);
        ACS_BTEE = Toolkit.getACSchar(6);
        ACS_TTEE = Toolkit.getACSchar(7);
        ACS_HLINE = Toolkit.getACSchar(8);
        ACS_VLINE = Toolkit.getACSchar(9);
        ACS_PLUS = Toolkit.getACSchar(10);
        ACS_S1 = Toolkit.getACSchar(11);
        ACS_S9 = Toolkit.getACSchar(12);
        ACS_DIAMOND = Toolkit.getACSchar(13);
        ACS_CKBOARD = Toolkit.getACSchar(14);
        ACS_DEGREE = Toolkit.getACSchar(15);
        ACS_PLMINUS = Toolkit.getACSchar(16);
        ACS_BULLET = Toolkit.getACSchar(17);
        BLACK = Toolkit.getColor(0);
        RED = Toolkit.getColor(1);
        GREEN = Toolkit.getColor(2);
        YELLOW = Toolkit.getColor(3);
        BLUE = Toolkit.getColor(4);
        MAGENTA = Toolkit.getColor(5);
        CYAN = Toolkit.getColor(6);
        WHITE = Toolkit.getColor(7);
        _defaultForeground = Color.white;
        _defaultBackground = Color.black;
    }
}

