/*
 * Decompiled with CFR 0.152.
 */
package charva.awt;

import charva.awt.Adjustable;
import charva.awt.BorderLayout;
import charva.awt.Component;
import charva.awt.Container;
import charva.awt.EventQueue;
import charva.awt.Frame;
import charva.awt.PlaybackThread;
import charva.awt.Point;
import charva.awt.Scrollable;
import charva.awt.SyncQueue;
import charva.awt.Toolkit;
import charva.awt.event.AWTEvent;
import charva.awt.event.AdjustmentEvent;
import charva.awt.event.GarbageCollectionEvent;
import charva.awt.event.InvocationEvent;
import charva.awt.event.PaintEvent;
import charva.awt.event.ScrollEvent;
import charva.awt.event.SyncEvent;
import charva.awt.event.WindowEvent;
import charva.awt.event.WindowListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Window
extends Container
implements Runnable {
    private static final Log LOG = LogFactory.getLog((Class)(class$charva$awt$Window == null ? (class$charva$awt$Window = Window.class$("charva.awt.Window")) : class$charva$awt$Window));
    private Window _owner;
    protected Toolkit _term;
    private boolean _windowClosed = false;
    private Vector _windowListeners = null;
    private static boolean _dispatchThreadRunning = false;
    static /* synthetic */ Class class$charva$awt$Window;

    public Window(Window window) {
        this._owner = window;
        this.init();
    }

    public Window(Frame frame) {
        this._owner = frame;
        this.init();
    }

    private void init() {
        this._term = Toolkit.getDefaultToolkit();
        this._layoutMgr = new BorderLayout();
        this._visible = false;
        if (this._owner != null) {
            super.setForeground(this._owner.getForeground());
            super.setBackground(this._owner.getBackground());
        } else {
            super.setForeground(Toolkit.getDefaultForeground());
            super.setBackground(Toolkit.getDefaultBackground());
        }
    }

    public Window getOwner() {
        return this._owner;
    }

    public void addWindowListener(WindowListener windowListener) {
        if (this._windowListeners == null) {
            this._windowListeners = new Vector();
        }
        this._windowListeners.add(windowListener);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (this._windowListeners == null) {
            return;
        }
        Enumeration enumeration = this._windowListeners.elements();
        while (enumeration.hasMoreElements()) {
            WindowListener windowListener = (WindowListener)enumeration.nextElement();
            switch (windowEvent.getID()) {
                case 3: {
                    windowListener.windowClosing(windowEvent);
                    break;
                }
                case 4: {
                    windowListener.windowOpened(windowEvent);
                }
            }
        }
    }

    public boolean isDisplayed() {
        return this._term.isWindowDisplayed(this);
    }

    public void pack() {
        this.setSize(this.minimumSize());
        super.doLayout();
    }

    public void show() {
        if (this._visible) {
            return;
        }
        this._visible = true;
        this._term.addWindow(this);
        super.doLayout();
        this.adjustLocation();
        this.draw();
        SyncQueue.getInstance().postEvent(new SyncEvent(this));
        if (_dispatchThreadRunning) {
            this.run();
        } else {
            _dispatchThreadRunning = true;
            Thread thread = new Thread(this);
            thread.setName("event dispatcher");
            thread.start();
            this.startPlayback();
        }
    }

    public void run() {
        EventQueue eventQueue = this._term.getSystemEventQueue();
        try {
            this._windowClosed = false;
            while (!this._windowClosed) {
                this._term.checkForKeystroke();
                while (!eventQueue.queuesAreEmpty()) {
                    AWTEvent aWTEvent = eventQueue.getNextEvent();
                    this.processEvent(aWTEvent);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEvent(AWTEvent aWTEvent) {
        Object object = aWTEvent.getSource();
        if (aWTEvent instanceof AdjustmentEvent) {
            ((Adjustable)object).processAdjustmentEvent((AdjustmentEvent)aWTEvent);
        } else if (aWTEvent instanceof ScrollEvent) {
            ((Scrollable)object).processScrollEvent((ScrollEvent)aWTEvent);
            this.requestFocus();
            super.requestSync();
        } else if (aWTEvent instanceof PaintEvent) {
            if (!((Component)object).isTotallyObscured()) {
                Vector vector;
                Vector vector2 = vector = this._term.getWindowList();
                synchronized (vector2) {
                    int n;
                    Window window = ((Component)object).getAncestorWindow();
                    window.draw();
                    Window window2 = null;
                    for (n = 0; n < vector.size() && (window2 = (Window)vector.elementAt(n)) != window; ++n) {
                    }
                    while (n < vector.size()) {
                        window2 = (Window)vector.elementAt(n);
                        window2.draw();
                        ++n;
                    }
                }
                super.requestSync();
            }
        } else if (aWTEvent instanceof SyncEvent) {
            this._term.sync();
        } else if (aWTEvent instanceof WindowEvent) {
            WindowEvent windowEvent = (WindowEvent)aWTEvent;
            windowEvent.getWindow().processWindowEvent(windowEvent);
            if (windowEvent.getID() == 3) {
                windowEvent.getWindow()._windowClosed = true;
                this._term.removeWindow(windowEvent.getWindow());
                this._term.blankBox(this._origin, this._size);
                Vector vector = this._term.getWindowList();
                Container container = null;
                Vector vector3 = vector;
                synchronized (vector3) {
                    for (int i = 0; i < vector.size(); ++i) {
                        container = (Window)vector.elementAt(i);
                        ((Window)container).draw();
                    }
                    if (container != null) {
                        container.requestFocus();
                    }
                }
                if (container != null) {
                    SyncQueue.getInstance().postEvent(new SyncEvent(container));
                }
            }
        } else if (aWTEvent instanceof GarbageCollectionEvent) {
            SyncQueue.getInstance().postEvent(aWTEvent);
        } else if (aWTEvent instanceof InvocationEvent) {
            ((InvocationEvent)aWTEvent).dispatch();
        } else {
            ((Component)object).processEvent(aWTEvent);
        }
    }

    public void hide() {
        if (!this._visible) {
            LOG.warn((Object)("Trying to hide window " + this + " that is already hidden!"));
            return;
        }
        this._visible = false;
        WindowEvent windowEvent = new WindowEvent(this, 3);
        this._term.getSystemEventQueue().postEvent(windowEvent);
    }

    public void draw() {
        super.draw();
        this.requestFocus();
    }

    public Point getLocationOnScreen() {
        return new Point(this._origin);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void adjustLocation() {
        int n;
        int n2 = this._origin.y + this.getHeight();
        if (n2 > this._term.getScreenRows()) {
            this._origin.y -= n2 - this._term.getScreenRows();
        }
        if (this._origin.y < 0) {
            this._origin.y = 0;
        }
        if ((n = this._origin.x + this.getWidth()) > this._term.getScreenColumns()) {
            this._origin.x -= n - this._term.getScreenColumns();
        }
        if (this._origin.x < 0) {
            this._origin.x = 0;
        }
    }

    public void debug(int n) {
        LOG.debug((Object)("Window origin=" + this._origin + " size=" + this._size));
        super.debug(1);
    }

    private void startPlayback() {
        String string = System.getProperty("charva.script.playbackFile");
        if (string == null) {
            return;
        }
        File file = new File(string);
        if (!file.canRead()) {
            LOG.warn((Object)("Cannot read script tile \"" + string + "\""));
            return;
        }
        PlaybackThread playbackThread = new PlaybackThread(file);
        playbackThread.setDaemon(true);
        playbackThread.setName("playback thread");
        playbackThread.start();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

