/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.EventQueue;
import charva.awt.ItemSelectable;
import charva.awt.Toolkit;
import charva.awt.Window;
import charva.awt.event.AWTEvent;
import charva.awt.event.ActionEvent;
import charva.awt.event.ActionListener;
import charva.awt.event.ItemEvent;
import charva.awt.event.ItemListener;
import charva.awt.event.KeyEvent;
import charva.awt.event.KeyListener;
import charva.awt.event.MouseEvent;
import charvax.swing.JComponent;
import java.util.Enumeration;
import java.util.Vector;

public abstract class AbstractButton
extends JComponent
implements ItemSelectable,
KeyListener {
    private String _label;
    private String _actionCommand;
    private int _mnemonic = 0;
    boolean _selected = false;
    protected Vector _actionListeners = null;
    protected Vector _itemListeners = null;

    public void setLabel(String string) {
        this.setText(string);
    }

    public void setText(String string) {
        this._label = string;
    }

    public void setMnemonic(int n) {
        this._mnemonic = n;
        Window window = super.getAncestorWindow();
        if (window != null) {
            window.addKeyListener(this);
        }
    }

    public String getLabel() {
        return this.getText();
    }

    public String getText() {
        return this._label;
    }

    public int getMnemonic() {
        return this._mnemonic;
    }

    public void setActionCommand(String string) {
        this._actionCommand = string;
    }

    public String getActionCommand() {
        return this._actionCommand;
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.getButton() == 1 && mouseEvent.getModifiers() == 102 && this.isFocusTraversable()) {
            this.doClick();
        }
    }

    public void doClick() {
        this.getParent().setFocus(this);
        Toolkit.getDefaultToolkit().fireKeystroke(343, this);
    }

    public void setSelected(boolean bl) {
        if (this._selected != bl) {
            int n = bl ? 100 : 101;
            ItemEvent itemEvent = new ItemEvent(this, this, n);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(itemEvent);
        }
        this._selected = bl;
        if (this.isDisplayed()) {
            super.repaint();
        }
    }

    public boolean isSelected() {
        return this._selected;
    }

    protected void processEvent(AWTEvent aWTEvent) {
        super.processEvent(aWTEvent);
        if (aWTEvent instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)aWTEvent;
            if (!keyEvent.isConsumed() && keyEvent.getKeyCode() == 343 && super.isEnabled()) {
                EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                eventQueue.postEvent(new ActionEvent(this, this.getActionCommand()));
                keyEvent.consume();
            }
        } else if (aWTEvent instanceof ActionEvent) {
            this.fireActionPerformed((ActionEvent)aWTEvent);
        } else if (aWTEvent instanceof ItemEvent) {
            this.fireItemStateChanged((ItemEvent)aWTEvent);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        if (this._actionListeners == null) {
            this._actionListeners = new Vector();
        }
        this._actionListeners.add(actionListener);
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        if (this._actionListeners != null) {
            Enumeration enumeration = this._actionListeners.elements();
            while (enumeration.hasMoreElements()) {
                ActionListener actionListener = (ActionListener)enumeration.nextElement();
                actionListener.actionPerformed(actionEvent);
            }
        }
    }

    public void addItemListener(ItemListener itemListener) {
        if (this._itemListeners == null) {
            this._itemListeners = new Vector();
        }
        this._itemListeners.add(itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        if (this._itemListeners == null) {
            return;
        }
        this._itemListeners.remove(itemListener);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == this.getMnemonic()) {
            this.doClick();
            keyEvent.consume();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c;
        char c2 = Character.toLowerCase(keyEvent.getKeyChar());
        if (c2 == (c = Character.toLowerCase((char)this.getMnemonic()))) {
            this.doClick();
            keyEvent.consume();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        if (this._itemListeners != null) {
            Enumeration enumeration = this._itemListeners.elements();
            while (enumeration.hasMoreElements()) {
                ItemListener itemListener = (ItemListener)enumeration.nextElement();
                itemListener.itemStateChanged(itemEvent);
            }
        }
    }

    protected String getLabelString() {
        String string = this.getText();
        if (this._mnemonic == 0) {
            return string;
        }
        if (this._mnemonic >= 32 && this._mnemonic < 255 && string.indexOf((char)this._mnemonic) != -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (this._mnemonic < 32) {
            char c = (char)(this._mnemonic + 64);
            return stringBuffer.append(" (^").append(c).append(")").toString();
        }
        if (this._mnemonic >= 265 && this._mnemonic <= 284) {
            int n = this._mnemonic - 265 + 1;
            return stringBuffer.append(" (F").append(n).append(")").toString();
        }
        return string;
    }
}

