/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Component;
import charva.awt.Container;
import charva.awt.Dimension;
import charva.awt.Insets;
import charva.awt.LayoutManager;

public class BoxLayout
implements LayoutManager {
    private Container _target;
    private int _axis;
    public static final int X_AXIS = 100;
    public static final int Y_AXIS = 101;

    public BoxLayout(Container container, int n) {
        this._target = container;
        if (n != 100 && n != 101) {
            throw new IllegalArgumentException("illegal axis");
        }
        this._axis = n;
    }

    public Dimension minimumSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            Dimension dimension2 = component.minimumSize();
            if (this._axis == 100) {
                dimension.width += dimension2.width;
                if (dimension2.height <= dimension.height) continue;
                dimension.height = dimension2.height;
                continue;
            }
            dimension.height += dimension2.height;
            if (dimension2.width <= dimension.width) continue;
            dimension.width = dimension2.width;
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public void doLayout(Container container) {
        Dimension dimension = container.getSize();
        Dimension dimension2 = this.minimumSize(container);
        if (dimension.width < dimension2.width) {
            dimension.width = dimension2.width;
        }
        if (dimension.height < dimension2.height) {
            dimension.height = dimension2.height;
        }
        container.setSize(dimension);
        Component[] componentArray = container.getComponents();
        int n = container.getInsets().left;
        int n2 = container.getInsets().top;
        for (int i = 0; i < componentArray.length; ++i) {
            float f;
            Object object;
            Component component = componentArray[i];
            if (component instanceof Container) {
                object = (Container)component;
                ((Container)object).setSize(((Container)object).minimumSize());
                ((Container)object).doLayout();
            }
            object = component.getSize();
            if (this._axis == 100) {
                f = component.getAlignmentY();
                if (f == 0.0f) {
                    n2 = container.getInsets().top;
                } else if (f == 0.5f) {
                    n2 = (dimension.height - ((Dimension)object).height) / 2;
                } else if (f == 1.0f) {
                    n2 = dimension.height - container.getInsets().bottom - ((Dimension)object).height;
                }
                component.setLocation(n, n2);
                n += ((Dimension)object).width;
                continue;
            }
            f = component.getAlignmentX();
            if (f == 0.0f) {
                n = container.getInsets().left;
            } else if (f == 0.5f) {
                n = (dimension.width - ((Dimension)object).width) / 2;
            } else if (f == 1.0f) {
                n = dimension.width - container.getInsets().right - ((Dimension)object).width;
            }
            component.setLocation(n, n2);
            n2 += ((Dimension)object).height;
        }
    }
}

