/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charvax.swing.ListSelectionModel;
import charvax.swing.event.ListSelectionEvent;
import charvax.swing.event.ListSelectionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeSet;

public class DefaultListSelectionModel
implements ListSelectionModel {
    protected ArrayList _listeners = new ArrayList();
    protected TreeSet _selection = new TreeSet();
    private int _selectionMode = 201;

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this._listeners.add(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this._listeners.remove(listSelectionListener);
    }

    public void setSelectionMode(int n) {
        this._selectionMode = n;
    }

    public int getSelectionMode() {
        return this._selectionMode;
    }

    public boolean isSelectedIndex(int n) {
        return this._selection.contains(new Integer(n));
    }

    public int getMinSelectionIndex() {
        try {
            Integer n = (Integer)this._selection.first();
            return n;
        }
        catch (NoSuchElementException noSuchElementException) {
            return -1;
        }
    }

    public int getMaxSelectionIndex() {
        try {
            Integer n = (Integer)this._selection.last();
            return n;
        }
        catch (NoSuchElementException noSuchElementException) {
            return -1;
        }
    }

    public boolean isSelectionEmpty() {
        return this._selection.isEmpty();
    }

    public void clearSelection() {
        if (!this.isSelectionEmpty()) {
            int n = this.getMinSelectionIndex();
            int n2 = this.getMaxSelectionIndex();
            this.fireValueChanged(n, n2);
            this._selection.clear();
        }
    }

    public void addSelectionInterval(int n, int n2) {
        TreeSet treeSet = this.getRange(n, n2);
        TreeSet treeSet2 = (TreeSet)this._selection.clone();
        treeSet2.addAll(treeSet);
        this.handleSelectionChange(treeSet2);
    }

    public void removeSelectionInterval(int n, int n2) {
        TreeSet treeSet = this.getRange(n, n2);
        TreeSet treeSet2 = (TreeSet)this._selection.clone();
        treeSet2.removeAll(treeSet);
        this.handleSelectionChange(treeSet2);
    }

    public void setSelectionInterval(int n, int n2) {
        TreeSet treeSet = this.getRange(n, n2);
        this.handleSelectionChange(treeSet);
    }

    public void insertIndexInterval(int n, int n2, boolean bl) {
        if (bl) {
            for (int i = n - n2; i >= n; ++i) {
                this._selection.add(new Integer(i));
            }
        } else {
            for (int i = n; i <= n + n2; ++i) {
                this._selection.add(new Integer(i));
            }
        }
    }

    public void removeIndexInterval(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            this._selection.remove(new Integer(i));
        }
    }

    protected void fireValueChanged(int n, int n2) {
        ListSelectionEvent listSelectionEvent = new ListSelectionEvent(this, n, n2, false);
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            ListSelectionListener listSelectionListener = (ListSelectionListener)iterator.next();
            listSelectionListener.valueChanged(listSelectionEvent);
        }
    }

    private TreeSet getRange(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        if (n <= n2) {
            n3 = n;
            n4 = n2;
        } else {
            n3 = n2;
            n4 = n;
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (int i = n3; i <= n4; ++i) {
            treeSet.add(new Integer(i));
        }
        return treeSet;
    }

    private void handleSelectionChange(TreeSet treeSet) {
        TreeSet treeSet2 = (TreeSet)this._selection.clone();
        TreeSet treeSet3 = (TreeSet)treeSet.clone();
        treeSet3.removeAll(this._selection);
        treeSet2.removeAll(treeSet);
        treeSet3.addAll(treeSet2);
        this._selection = treeSet;
        if (!treeSet3.isEmpty()) {
            Integer n = (Integer)treeSet3.first();
            Integer n2 = (Integer)treeSet3.last();
            this.fireValueChanged(n, n2);
        }
    }
}

