/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Dimension;
import charva.awt.EventQueue;
import charva.awt.Insets;
import charva.awt.Point;
import charva.awt.Toolkit;
import charva.awt.event.ItemEvent;
import charva.awt.event.KeyEvent;
import charvax.swing.AbstractButton;

public class JButton
extends AbstractButton {
    public JButton() {
        this("");
    }

    public JButton(String string) {
        super.setText(string);
        super.setActionCommand(string);
    }

    public void setLabel(String string) {
        this.setText(string);
    }

    public void setText(String string) {
        super.setText(string);
        this.repaint();
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public int getWidth() {
        Insets insets = super.getInsets();
        return super.getLabelString().length() + 2 + insets.left + insets.right;
    }

    public int getHeight() {
        Insets insets = super.getInsets();
        return 1 + insets.top + insets.bottom;
    }

    public Dimension minimumSize() {
        return this.getSize();
    }

    public void draw() {
        super.draw();
        Point point = this.getLocationOnScreen();
        Insets insets = super.getInsets();
        point.translate(insets.left, insets.top);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.setCursor(point);
        int n = this.getCursesColor();
        if (super.isEnabled()) {
            int n2;
            toolkit.addString(" ", Toolkit.A_REVERSE, n);
            toolkit.addString(super.getLabelString(), Toolkit.A_REVERSE, n);
            toolkit.addString(" ", Toolkit.A_REVERSE, n);
            if (super.getMnemonic() > 0 && (n2 = super.getLabelString().indexOf((char)super.getMnemonic())) != -1) {
                toolkit.setCursor(point.addOffset(1 + n2, 0));
                toolkit.addChar(super.getMnemonic(), Toolkit.A_UNDERLINE | Toolkit.A_REVERSE, n);
            }
        } else {
            toolkit.addString("<", 0, n);
            toolkit.addString(this.getText(), 0, n);
            toolkit.addString(">", 0, n);
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        int n = keyEvent.getKeyCode();
        if (n == 9) {
            this.getParent().nextFocus();
            return;
        }
        if (n == 353) {
            this.getParent().previousFocus();
            return;
        }
        if (super.isEnabled() && n == 343) {
            EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            eventQueue.postEvent(new ItemEvent(this, this, 100));
        }
    }

    public void requestFocus() {
        super.requestFocus();
        Point point = this.getLocationOnScreen();
        Insets insets = super.getInsets();
        Toolkit.getDefaultToolkit().setCursor(point.addOffset(1 + insets.left, 0 + insets.top));
    }

    public String toString() {
        return "JButton location=" + this.getLocation() + " label=\"" + this.getLabel() + "\" actionCommand=\"" + this.getActionCommand() + "\"";
    }

    public void debug(int n) {
        for (int i = 0; i < n; ++i) {
            System.err.print("    ");
        }
        System.err.println("JButton origin=" + this._origin + " size=" + this.getSize() + " label=" + super.getText());
    }
}

