/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Dimension;
import charva.awt.EventQueue;
import charva.awt.Insets;
import charva.awt.Point;
import charva.awt.Toolkit;
import charva.awt.event.ItemEvent;
import charva.awt.event.KeyEvent;
import charvax.swing.AbstractButton;

public class JCheckBox
extends AbstractButton {
    public JCheckBox() {
        this("", false);
    }

    public JCheckBox(String string) {
        this(string, false);
    }

    public JCheckBox(String string, boolean bl) {
        super.setText(string);
        super.setSelected(bl);
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public int getWidth() {
        Insets insets = super.getInsets();
        return super.getText().length() + 4 + insets.left + insets.right;
    }

    public int getHeight() {
        Insets insets = super.getInsets();
        return 1 + insets.top + insets.bottom;
    }

    public Dimension minimumSize() {
        return this.getSize();
    }

    public void draw() {
        super.draw();
        Point point = this.getLocationOnScreen();
        Insets insets = super.getInsets();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.setCursor(point.addOffset(insets.left, insets.top));
        String string = super.isSelected() ? "[*] " : "[ ] ";
        int n = this.getCursesColor();
        int n2 = this._enabled ? Toolkit.A_BOLD : 0;
        toolkit.addString(string + super.getLabelString(), n2, n);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 9: {
                this.getParent().nextFocus();
                return;
            }
            case 353: {
                this.getParent().previousFocus();
                return;
            }
            case 343: {
                if (!super.isEnabled()) {
                    toolkit.beep();
                    return;
                }
                super.setSelected(!super.isSelected());
                EventQueue eventQueue = toolkit.getSystemEventQueue();
                int n2 = super.isSelected() ? 100 : 101;
                eventQueue.postEvent(new ItemEvent(this, this, n2));
            }
        }
        this.draw();
        this.requestFocus();
        super.requestSync();
    }

    public void requestFocus() {
        super.requestFocus();
        Point point = this.getLocationOnScreen();
        Insets insets = super.getInsets();
        Toolkit.getDefaultToolkit().setCursor(point.addOffset(1 + insets.left, 0 + insets.top));
    }

    public String toString() {
        return "JCheckBox location=" + this.getLocation() + " label=\"" + this.getLabel() + "\" actionCommand=\"" + this.getActionCommand() + "\" selected=" + this.isSelected();
    }

    public void debug(int n) {
        for (int i = 0; i < n; ++i) {
            System.err.print("    ");
        }
        System.err.println("JCheckBox origin=" + this._origin + " size=" + this.getSize() + " label=" + super.getText());
    }
}

