/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Dimension;
import charva.awt.EventQueue;
import charva.awt.Frame;
import charva.awt.Insets;
import charva.awt.ItemSelectable;
import charva.awt.Point;
import charva.awt.Toolkit;
import charva.awt.event.AWTEvent;
import charva.awt.event.ActionEvent;
import charva.awt.event.ActionListener;
import charva.awt.event.ItemEvent;
import charva.awt.event.ItemListener;
import charva.awt.event.KeyEvent;
import charva.awt.event.MouseEvent;
import charvax.swing.ComboBoxModel;
import charvax.swing.DefaultComboBoxModel;
import charvax.swing.JComponent;
import charvax.swing.JList;
import charvax.swing.JScrollPane;
import charvax.swing.MutableComboBoxModel;
import charvax.swing.border.LineBorder;
import charvax.swing.event.ListSelectionEvent;
import charvax.swing.event.ListSelectionListener;
import java.util.Enumeration;
import java.util.Vector;

public class JComboBox
extends JComponent
implements ListSelectionListener,
ItemSelectable {
    private ComboBoxModel _model;
    private int _columns = 3;
    private int _maxRows = 3;
    protected Vector _actionListeners = null;
    protected Vector _itemListeners = null;
    private Popup _popup;

    public JComboBox() {
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        this.setModel(defaultComboBoxModel);
    }

    public JComboBox(ComboBoxModel comboBoxModel) {
        this.setModel(comboBoxModel);
    }

    public JComboBox(Object[] objectArray) {
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(objectArray);
        this.setModel(defaultComboBoxModel);
    }

    public JComboBox(Vector vector) {
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(vector);
        this.setModel(defaultComboBoxModel);
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        this._model = comboBoxModel;
        for (int i = 0; i < this._model.getSize(); ++i) {
            String string = this._model.getElementAt(i).toString();
            if (string.length() <= this._columns) continue;
            this._columns = string.length();
        }
        if (super.isDisplayed()) {
            super.repaint();
        }
    }

    public void addItem(Object object) {
        ((MutableComboBoxModel)this._model).addElement(object);
        if (object.toString().length() > this._columns) {
            this._columns = object.toString().length();
        }
    }

    public void insertItemAt(Object object, int n) {
        ((MutableComboBoxModel)this._model).insertElementAt(object, n);
        if (object.toString().length() > this._columns) {
            this._columns = object.toString().length();
        }
    }

    public void removeItemAt(int n) {
        ((MutableComboBoxModel)this._model).removeElementAt(n);
    }

    public void removeItem(Object object) {
        ((MutableComboBoxModel)this._model).removeElement(object);
    }

    public void removeAllItems() {
        while (this._model.getSize() > 0) {
            this.removeItemAt(0);
        }
    }

    public Object getSelectedItem() {
        return this._model.getSelectedItem();
    }

    public void setSelectedItem(Object object) {
        this._model.setSelectedItem(object);
    }

    public void setSelectedIndex(int n) {
        Object object = this._model.getElementAt(n);
        this._model.setSelectedItem(object);
    }

    public void setMaximumRowCount(int n) {
        this._maxRows = n;
    }

    public int getWidth() {
        Insets insets = super.getInsets();
        return this._columns + insets.left + insets.right + 2;
    }

    public int getHeight() {
        Insets insets = super.getInsets();
        return 1 + insets.top + insets.bottom;
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public Dimension minimumSize() {
        return this.getSize();
    }

    public void draw() {
        int n;
        super.draw();
        Point point = this.getLocationOnScreen();
        Insets insets = super.getInsets();
        point.translate(insets.left, insets.right);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int n2 = this.getCursesColor();
        toolkit.setCursor(point);
        String string = (String)this._model.getSelectedItem();
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this._columns + 1; ++n) {
            stringBuffer.append(' ');
        }
        if (string != null) {
            stringBuffer.replace(1, string.length() + 1, string);
        }
        n = super.isEnabled() ? Toolkit.A_REVERSE : Toolkit.A_NORMAL;
        toolkit.addString(stringBuffer.toString(), n, n2);
        toolkit.setCursor(point.addOffset(this._columns + 1, 0));
        toolkit.addChar(Toolkit.ACS_DIAMOND, n, n2);
    }

    public void addItemListener(ItemListener itemListener) {
        if (this._itemListeners == null) {
            this._itemListeners = new Vector();
        }
        this._itemListeners.add(itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        if (this._itemListeners == null) {
            return;
        }
        this._itemListeners.remove(itemListener);
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        if (this._itemListeners != null) {
            Enumeration enumeration = this._itemListeners.elements();
            while (enumeration.hasMoreElements()) {
                ItemListener itemListener = (ItemListener)enumeration.nextElement();
                itemListener.itemStateChanged(itemEvent);
            }
        }
    }

    public void processEvent(AWTEvent aWTEvent) {
        super.processEvent(aWTEvent);
        if (aWTEvent instanceof ActionEvent) {
            this.fireActionEvent((ActionEvent)aWTEvent);
            ItemEvent itemEvent = new ItemEvent(this, this, 100);
            this.fireItemStateChanged(itemEvent);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        if (this._actionListeners == null) {
            this._actionListeners = new Vector();
        }
        this._actionListeners.add(actionListener);
    }

    protected void fireActionEvent(ActionEvent actionEvent) {
        if (this._actionListeners != null) {
            Enumeration enumeration = this._actionListeners.elements();
            while (enumeration.hasMoreElements()) {
                ActionListener actionListener = (ActionListener)enumeration.nextElement();
                actionListener.actionPerformed(actionEvent);
            }
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 9) {
            this.getParent().nextFocus();
            return;
        }
        if (n == 353) {
            this.getParent().previousFocus();
            return;
        }
        if (n == 343) {
            this._activate();
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.getButton() == 1 && mouseEvent.getModifiers() == 102 && this.isFocusTraversable()) {
            this._activate();
        }
    }

    public void setEditable(boolean bl) {
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this._popup.hide();
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        Object object = this._popup.getSelectedItem();
        if (object != null) {
            this._model.setSelectedItem(object);
        }
        eventQueue.postEvent(new ActionEvent(this, this._model.getSelectedItem().toString()));
    }

    public void requestFocus() {
        super.requestFocus();
        Point point = this.getLocationOnScreen();
        Insets insets = super.getInsets();
        Toolkit.getDefaultToolkit().setCursor(point.addOffset(insets.left, insets.top));
    }

    public String toString() {
        return "JComboBox location=" + this.getLocation() + " selectedItem=\"" + this.getSelectedItem() + "\"";
    }

    public void debug(int n) {
        for (int i = 0; i < n; ++i) {
            System.err.print("    ");
        }
        System.err.println(this.toString());
    }

    private void _activate() {
        this._popup = new Popup(this, this._model);
        this._popup.setMaximumRowCount(this._maxRows);
        Point point = this.getLocationOnScreen();
        this._popup.setLocation(point);
        this._popup.show();
    }

    private class Popup
    extends Frame {
        private JList _list = new JList();
        private JScrollPane _scrollpane;

        Popup(JComboBox jComboBox2, ComboBoxModel comboBoxModel) {
            this.setBackground(jComboBox2.getBackground());
            this.setForeground(jComboBox2.getForeground());
            this._scrollpane = new JScrollPane(this._list);
            this._scrollpane.setViewportBorder(new LineBorder(this.getForeground()));
            this._list.setModel(comboBoxModel);
            this._list.setColumns(JComboBox.this._columns);
            Object object = comboBoxModel.getSelectedItem();
            int n = 0;
            for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                Object object2 = comboBoxModel.getElementAt(i);
                if (object == object2) {
                    n = i;
                }
                String string = object2.toString();
            }
            this._list.setSelectedIndex(n);
            super.add(this._scrollpane);
            this._list.addListSelectionListener(jComboBox2);
            this._list.ensureIndexIsVisible(n);
        }

        Object getSelectedItem() {
            return this._list.getSelectedValue();
        }

        void setMaximumRowCount(int n) {
            this._list.setVisibleRowCount(n);
            this.pack();
        }
    }
}

