/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.BorderLayout;
import charva.awt.Component;
import charva.awt.Dialog;
import charva.awt.Dimension;
import charva.awt.FlowLayout;
import charva.awt.Insets;
import charva.awt.Point;
import charva.awt.Toolkit;
import charva.awt.event.ActionEvent;
import charva.awt.event.ActionListener;
import charva.awt.event.EventListener;
import charva.awt.event.KeyEvent;
import charva.awt.event.KeyListener;
import charvax.swing.DefaultListModel;
import charvax.swing.JButton;
import charvax.swing.JComponent;
import charvax.swing.JDialog;
import charvax.swing.JLabel;
import charvax.swing.JList;
import charvax.swing.JOptionPane;
import charvax.swing.JPanel;
import charvax.swing.JScrollPane;
import charvax.swing.JTextField;
import charvax.swing.ListModel;
import charvax.swing.border.EmptyBorder;
import charvax.swing.border.TitledBorder;
import charvax.swing.event.ListSelectionEvent;
import charvax.swing.event.ListSelectionListener;
import charvax.swing.filechooser.FileFilter;
import java.io.File;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JFileChooser
extends JComponent {
    private static final Log LOG = LogFactory.getLog((Class)(class$charvax$swing$JFileChooser == null ? (class$charvax$swing$JFileChooser = JFileChooser.class$("charvax.swing.JFileChooser")) : class$charvax$swing$JFileChooser));
    protected String _title;
    protected String _approveButtonText = "Open File";
    protected File _currentDirectory = null;
    protected DirList _dirList = new DirList();
    protected String _location = "";
    protected boolean _cancelWasPressed = true;
    protected int _fileSelectionMode = 200;
    protected FileFilter _fileFilter = null;
    protected Vector _filelisteners = new Vector();
    protected static final int _COLS = 50;
    protected static final int _ROWS = 20;
    public static final int FILES_ONLY = 200;
    public static final int DIRECTORIES_ONLY = 201;
    public static final int FILES_AND_DIRECTORIES = 202;
    public static final int CANCEL_OPTION = 300;
    public static final int APPROVE_OPTION = 301;
    public static final int ERROR_OPTION = 302;
    public static String CANCEL_LABEL = "Cancel";
    public static String APPROVE_LABEL = "Approve";
    public static String PARENT_DIRECTORY_LABEL = "Parent Directory";
    public static String NEW_DIRECTORY_LABEL = "New Directory";
    public static int CANCEL_ACCELERATOR = -1;
    public static int APPROVE_ACCELERATOR = -1;
    public static int PARENT_DIRECTORY_ACCELERATOR = -1;
    public static int NEW_DIRECTORY_ACCELERATOR = -1;
    static /* synthetic */ Class class$charvax$swing$JFileChooser;

    public JFileChooser() {
        this((File)null);
    }

    public JFileChooser(File file) {
        this.setCurrentDirectory(file);
    }

    public JFileChooser(String string) {
        if (string == null) {
            this.setCurrentDirectory(null);
        } else {
            this.setCurrentDirectory(new File(string));
        }
    }

    public void setCurrentDirectory(File file) {
        if (file == null) {
            String string = System.getProperty("user.home");
            file = new File(string);
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("not a directory");
        }
        this._currentDirectory = file;
        this._location = file.getAbsolutePath();
    }

    public File getCurrentDirectory() {
        return this._currentDirectory;
    }

    public File getSelectedFile() {
        if (this._cancelWasPressed) {
            return null;
        }
        return new File(this._location);
    }

    public void setSelectedFile(File file) {
        if (!file.isAbsolute()) {
            file = new File(this._currentDirectory, file.getPath());
        }
        File file2 = file.getParentFile();
        if (!file.isDirectory() && file2 != null) {
            this._currentDirectory = file2;
            this._location = file.getAbsolutePath();
        } else if (file.isDirectory()) {
            this._currentDirectory = file;
            this._location = file.getAbsolutePath();
        }
        this.fireFileChooserEvent();
    }

    public int showDialog(Component component, String string) {
        this._approveButtonText = string;
        ChooserDialog chooserDialog = new ChooserDialog(component);
        chooserDialog.setLocationRelativeTo(component);
        chooserDialog.show();
        if (this._cancelWasPressed) {
            return 300;
        }
        return 301;
    }

    public int showSaveDialog(Component component) {
        return this.showDialog(component, "Save");
    }

    public int showOpenDialog(Component component) {
        return this.showDialog(component, "Open");
    }

    public void setFileSelectionMode(int n) {
        if (n < 200 || n > 202) {
            throw new IllegalArgumentException("invalid file selection mode");
        }
        this._fileSelectionMode = n;
    }

    public int getFileSelectionMode() {
        return this._fileSelectionMode;
    }

    public void setDialogTitle(String string) {
        this._title = string;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this._fileFilter = fileFilter;
    }

    public FileFilter getFileFilter() {
        return this._fileFilter;
    }

    public void debug(int n) {
        LOG.debug((Object)("JFileChooser origin=" + this._origin + " title=" + this._title));
    }

    public Dimension minimumSize() {
        return null;
    }

    public Dimension getSize() {
        return null;
    }

    public int getHeight() {
        return 0;
    }

    public int getWidth() {
        return 0;
    }

    protected void addFileChooserListener(FileChooserListener fileChooserListener) {
        this._filelisteners.addElement(fileChooserListener);
    }

    protected void fireFileChooserEvent() {
        Enumeration enumeration = this._filelisteners.elements();
        while (enumeration.hasMoreElements()) {
            FileChooserListener fileChooserListener = (FileChooserListener)enumeration.nextElement();
            fileChooserListener.fileChanged(new FileChooserEvent(this));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class FileChooserEvent
    extends EventObject {
        public FileChooserEvent(Object object) {
            super(object);
        }
    }

    private static interface FileChooserListener
    extends EventListener {
        public void fileChanged(FileChooserEvent var1);
    }

    private class NewDirDialog
    extends JDialog
    implements ActionListener {
        private File _parent;
        private JButton _okButton;
        private JButton _cancelButton;
        private JTextField _dirnameField;
        private File _directory = null;

        NewDirDialog(Dialog dialog, File file) {
            super(dialog);
            this.setTitle("Enter the new directory name");
            this._parent = file;
            this.setSize(60, 10);
            JPanel jPanel = new JPanel();
            jPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
            jPanel.add(new JLabel("Directory name:"));
            this._dirnameField = new JTextField(35);
            this._dirnameField.setActionCommand("dirname");
            this._dirnameField.addActionListener(this);
            jPanel.add(this._dirnameField);
            this.add(jPanel, "Center");
            this._okButton = new JButton("OK");
            this._okButton.addActionListener(this);
            this._cancelButton = new JButton("Cancel");
            this._cancelButton.addActionListener(this);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(3, 1, 1));
            jPanel2.add(this._okButton);
            jPanel2.add(this._cancelButton);
            this.add(jPanel2, "South");
            this.pack();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("OK") || string.equals("dirname")) {
                if (!this._parent.canWrite()) {
                    String[] stringArray = new String[]{"Permission denied"};
                    JOptionPane.showMessageDialog(this, stringArray, "Error", 100);
                    return;
                }
                File file = new File(this._parent, this._dirnameField.getText());
                boolean bl = file.mkdir();
                if (!bl) {
                    String[] stringArray = new String[]{"Invalid directory"};
                    JOptionPane.showMessageDialog(this, stringArray, "Error", 100);
                } else {
                    this._directory = file;
                    this.hide();
                }
            } else if (string.equals("Cancel")) {
                this._directory = null;
                this.hide();
            }
        }

        File getDirectory() {
            return this._directory;
        }
    }

    private class DirList
    extends JList {
        private StringBuffer _matchbuf = new StringBuffer();

        DirList() {
            this.setVisibleRowCount(10);
            this.setSelectionMode(201);
        }

        void clear() {
            int n = this.getSelectionModel().getMinSelectionIndex();
            if (n != -1) {
                int n2 = this.getSelectionModel().getMaxSelectionIndex();
                this.getSelectionModel().removeIndexInterval(n, n2);
            }
            ((DefaultListModel)this.getModel()).clear();
            this._currentRow = 0;
            this._matchbuf.setLength(0);
        }

        public void processKeyEvent(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            ListModel listModel = super.getModel();
            if (listModel.getSize() > 0 && (n == 263 || n > 32 && n < 255)) {
                String string;
                int n2;
                if (n == 263) {
                    if (this._matchbuf.length() > 0) {
                        this._matchbuf.setLength(this._matchbuf.length() - 1);
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                } else {
                    this._matchbuf.append((char)n);
                }
                String string2 = this._matchbuf.toString();
                for (n2 = 0; n2 < listModel.getSize() && string2.compareTo((String)listModel.getElementAt(n2)) > 0; ++n2) {
                }
                if (n2 == listModel.getSize()) {
                    --n2;
                }
                if (!(string = (String)listModel.getElementAt(n2)).startsWith(string2)) {
                    Toolkit.getDefaultToolkit().beep();
                }
                this._currentRow = n2;
                super.ensureIndexIsVisible(n2);
            }
            super.processKeyEvent(keyEvent);
        }
    }

    private class ChooserDialog
    extends JDialog
    implements ActionListener,
    ListSelectionListener,
    KeyListener,
    FileChooserListener {
        private JScrollPane _scrollPane;
        protected JButton _cancelButton = new JButton("Cancel");
        protected JButton _approveButton = new JButton("Open");
        protected JButton _parentButton = new JButton("Parent Directory");
        protected JButton _newButton = new JButton("New Directory");
        private JTextField _locationField = new JTextField(35);

        ChooserDialog(Component component) {
            this.setTitle(JFileChooser.this._title);
            this.setSize(50, 20);
            if (JFileChooser.this.getForeground() == null) {
                this.setForeground(component.getForeground());
            } else {
                this.setForeground(JFileChooser.this.getForeground());
            }
            if (JFileChooser.this.getBackground() == null) {
                this.setBackground(component.getBackground());
            } else {
                this.setBackground(JFileChooser.this.getBackground());
            }
            JFileChooser.this._dirList.setVisibleRowCount(12);
            JFileChooser.this._dirList.setColumns(45);
            JFileChooser.this._dirList.addListSelectionListener(this);
            this.displayCurrentDirectory();
            this._scrollPane = new JScrollPane(JFileChooser.this._dirList);
            this._scrollPane.setViewportBorder(new TitledBorder("Files"));
            this.add(this._scrollPane, "West");
            JPanel jPanel = new JPanel();
            jPanel.setBorder(new EmptyBorder(0, 1, 0, 1));
            jPanel.setLayout(new FlowLayout(3, 1, 0));
            jPanel.add(this._parentButton);
            this._parentButton.setText(PARENT_DIRECTORY_LABEL);
            this._parentButton.addActionListener(this);
            jPanel.add(this._newButton);
            this._newButton.setText(NEW_DIRECTORY_LABEL);
            this._newButton.addActionListener(this);
            this.add(jPanel, "North");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            JPanel jPanel3 = new JPanel();
            jPanel3.add(new JLabel("Pathname:"));
            jPanel3.add(this._locationField);
            this._locationField.setText(JFileChooser.this._location);
            this._locationField.setActionCommand("locationField");
            this._locationField.addActionListener(this);
            jPanel2.add(jPanel3, "North");
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new FlowLayout(3, 1, 0));
            jPanel4.setBorder(new EmptyBorder(1, 1, 0, 1));
            jPanel4.add(this._approveButton);
            jPanel4.add(this._cancelButton);
            this._approveButton.setText(JFileChooser.this._approveButtonText);
            this._cancelButton.setText(CANCEL_LABEL);
            this._approveButton.addActionListener(this);
            this._cancelButton.addActionListener(this);
            jPanel2.add(jPanel4, "South");
            this.add(jPanel2, "South");
            this.pack();
            Insets insets = this.getInsets();
            JFileChooser.this._dirList.setColumns(this.getWidth() - insets.left - insets.right - 2);
            this.addKeyListener(this);
            JFileChooser.this.addFileChooserListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this._parentButton) {
                this._doParentDirectoryAction();
            } else if (object == this._newButton) {
                this._doNewDirectoryAction();
            } else if (object == this._approveButton) {
                this._doApproveAction();
            } else if (object == this._cancelButton) {
                this._doCancelAction();
            } else if (object == this._locationField) {
                this._doApproveAction();
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == PARENT_DIRECTORY_ACCELERATOR) {
                this._doParentDirectoryAction();
            } else if (n == NEW_DIRECTORY_ACCELERATOR) {
                this._doNewDirectoryAction();
            } else if (n == APPROVE_ACCELERATOR) {
                this._doApproveAction();
            } else if (n == CANCEL_ACCELERATOR) {
                this._doCancelAction();
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            File file;
            String string = (String)JFileChooser.this._dirList.getSelectedValue();
            if (string == null) {
                this._locationField.setText(JFileChooser.this._currentDirectory.getAbsolutePath());
                return;
            }
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            if (!(file = new File(JFileChooser.this._currentDirectory, string)).canRead()) {
                String[] stringArray = new String[]{"File or directory not readable:", file.getAbsolutePath()};
                JOptionPane.showMessageDialog(this, stringArray, "Error", 100);
                return;
            }
            if (!file.isDirectory()) {
                if (JFileChooser.this._fileSelectionMode == 201) {
                    String[] stringArray = new String[]{"Not a directory:", file.getAbsolutePath()};
                    JOptionPane.showMessageDialog(this, stringArray, "Error", 100);
                } else {
                    this._locationField.setText(file.getAbsolutePath());
                }
                return;
            }
            JFileChooser.this.setCurrentDirectory(file);
            this.displayCurrentDirectory();
            this.repaint();
            this._scrollPane.getViewport().setViewPosition(new Point(0, 0));
            this._scrollPane.repaint();
            if (!this._isRoot(JFileChooser.this._currentDirectory)) {
                this._parentButton.setEnabled(true);
            }
        }

        public void fileChanged(FileChooserEvent fileChooserEvent) {
            this.displayCurrentDirectory();
            this.repaint();
        }

        private void _doNewDirectoryAction() {
            NewDirDialog newDirDialog = new NewDirDialog(this, JFileChooser.this._currentDirectory);
            newDirDialog.setLocation(this.getLocation().addOffset(2, 2));
            newDirDialog.show();
            File file = newDirDialog.getDirectory();
            if (file != null) {
                JFileChooser.this.setCurrentDirectory(file);
            }
            this.displayCurrentDirectory();
            this.repaint();
        }

        private void _doParentDirectoryAction() {
            if (this._isRoot(JFileChooser.this._currentDirectory)) {
                File[] fileArray = File.listRoots();
                for (int i = 0; i < fileArray.length; ++i) {
                    DefaultListModel defaultListModel = (DefaultListModel)JFileChooser.this._dirList.getModel();
                    defaultListModel.addElement(fileArray[i].getAbsolutePath());
                }
                JFileChooser.this._location = "";
            } else {
                File file = JFileChooser.this._currentDirectory.getParentFile();
                if (this._isRoot(file)) {
                    this._parentButton.setEnabled(false);
                    JFileChooser.this._dirList.requestFocus();
                }
                JFileChooser.this.setCurrentDirectory(file);
                this.displayCurrentDirectory();
                this.repaint();
            }
        }

        private void _doApproveAction() {
            File file = new File(this._locationField.getText());
            String string = null;
            if (JFileChooser.this._fileSelectionMode == 201 && !file.isDirectory()) {
                string = "Entry is not a directory: ";
            } else if (JFileChooser.this._fileSelectionMode == 200 && file.isDirectory()) {
                JFileChooser.this.setCurrentDirectory(file);
                this.displayCurrentDirectory();
                this.repaint();
                return;
            }
            if (string != null) {
                String[] stringArray = new String[]{string, this._locationField.getText()};
                JOptionPane.showMessageDialog(this, stringArray, "Error", 100);
                return;
            }
            JFileChooser.this._cancelWasPressed = false;
            JFileChooser.this._location = this._locationField.getText();
            this.hide();
        }

        private void _doCancelAction() {
            JFileChooser.this._cancelWasPressed = true;
            this.hide();
        }

        private boolean _isRoot(File file) {
            String string = file.getAbsolutePath();
            File[] fileArray = File.listRoots();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].getAbsolutePath().equals(string)) continue;
                return true;
            }
            return false;
        }

        private void displayCurrentDirectory() {
            JFileChooser.this._dirList.clear();
            DefaultListModel defaultListModel = (DefaultListModel)JFileChooser.this._dirList.getModel();
            File[] fileArray = JFileChooser.this._currentDirectory.listFiles();
            Comparator comparator = new Comparator(this){
                private final /* synthetic */ ChooserDialog this$1;
                {
                    this.this$1 = chooserDialog;
                }

                public int compare(Object object, Object object2) {
                    String string = (String)object;
                    String string2 = (String)object2;
                    return string.compareTo(string2);
                }
            };
            TreeSet<String> treeSet = new TreeSet<String>(comparator);
            int n = 0;
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    treeSet.add(fileArray[i].getName() + "/");
                } else if (JFileChooser.this._fileSelectionMode != 201 && (JFileChooser.this._fileFilter == null || JFileChooser.this._fileFilter.accept(fileArray[i]))) {
                    treeSet.add(fileArray[i].getName());
                }
                ++n;
            }
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                defaultListModel.addElement(iterator.next());
            }
            this._locationField.setText(JFileChooser.this._location);
        }
    }
}

