/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Dimension;
import charva.awt.Insets;
import charva.awt.Point;
import charva.awt.Toolkit;
import charva.awt.event.KeyEvent;
import charvax.swing.JComponent;

public class JLabel
extends JComponent {
    private String _labeltext;
    private int _width;

    public JLabel() {
        this("", 303);
    }

    public JLabel(String string) {
        this(string, 303);
    }

    public JLabel(String string, int n) {
        this._labeltext = string;
        this._width = string.length();
        switch (n) {
            case 303: {
                this._alignmentX = 0.0f;
                break;
            }
            case 301: {
                this._alignmentX = 0.5f;
                break;
            }
            case 304: {
                this._alignmentX = 1.0f;
            }
        }
    }

    public void setLength(int n) {
        this._width = n;
    }

    public Dimension minimumSize() {
        return this.getSize();
    }

    public void draw() {
        int n;
        super.draw();
        Point point = this.getLocationOnScreen();
        Insets insets = super.getInsets();
        point.translate(insets.left, insets.top);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.setCursor(point);
        StringBuffer stringBuffer = new StringBuffer(this._labeltext);
        int n2 = this._labeltext.length();
        if (this._width > n2) {
            for (n = n2; n < this._width; ++n) {
                stringBuffer.append(' ');
            }
        } else if (this._width < n2) {
            stringBuffer.setLength(this._width);
        }
        n = this.getCursesColor();
        toolkit.addString(stringBuffer.toString(), 0, n);
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public int getWidth() {
        Insets insets = super.getInsets();
        return this._width + insets.left + insets.right;
    }

    public int getHeight() {
        Insets insets = super.getInsets();
        return 1 + insets.top + insets.bottom;
    }

    public synchronized void setText(String string) {
        this._labeltext = string;
        if (string.length() > this._width) {
            this._width = string.length();
        }
        this.repaint();
    }

    public String getText() {
        return this._labeltext;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
    }

    public void requestFocus() {
    }

    public void debug(int n) {
        for (int i = 0; i < n; ++i) {
            System.err.print("    ");
        }
        System.err.println("JLabel origin=" + this._origin + " size=" + this.getSize() + " label=" + this._labeltext);
    }

    public String toString() {
        return "JLabel: [" + this.getText() + "]";
    }
}

