/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Container;
import charva.awt.Dimension;
import charva.awt.EventQueue;
import charva.awt.Insets;
import charva.awt.Point;
import charva.awt.Scrollable;
import charva.awt.Toolkit;
import charva.awt.event.KeyEvent;
import charva.awt.event.MouseEvent;
import charva.awt.event.ScrollEvent;
import charva.awt.event.ScrollListener;
import charvax.swing.DefaultListModel;
import charvax.swing.DefaultListSelectionModel;
import charvax.swing.JComponent;
import charvax.swing.JViewport;
import charvax.swing.ListModel;
import charvax.swing.ListSelectionModel;
import charvax.swing.event.ListSelectionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;

public class JList
extends JComponent
implements Scrollable {
    private int _visibleRows = 5;
    private int _columns = 10;
    protected int _currentRow = 0;
    protected ListSelectionModel _selectionModel = new DefaultListSelectionModel();
    protected ListModel _listModel;
    private Vector _scrollListeners = null;

    public JList() {
        this.setModel(new DefaultListModel());
    }

    public JList(ListModel listModel) {
        this.setModel(listModel);
    }

    public JList(Object[] objectArray) {
        this.setListData(objectArray);
    }

    public JList(Vector vector) {
        this.setListData(vector);
    }

    public void setListData(Object[] objectArray) {
        DefaultListModel defaultListModel = new DefaultListModel();
        for (int i = 0; i < objectArray.length; ++i) {
            defaultListModel.addElement(objectArray[i]);
        }
        this.setModel(defaultListModel);
    }

    public void setListData(Vector vector) {
        Enumeration enumeration = vector.elements();
        DefaultListModel defaultListModel = new DefaultListModel();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            defaultListModel.addElement(e);
        }
        this.setModel(defaultListModel);
    }

    public void setModel(ListModel listModel) {
        this._listModel = listModel;
        this._selectionModel.clearSelection();
    }

    public ListModel getModel() {
        return this._listModel;
    }

    public void setVisibleRowCount(int n) {
        this._visibleRows = n;
    }

    public int getVisibleRowCount() {
        return this._visibleRows;
    }

    public void setColumns(int n) {
        this._columns = n;
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public int getWidth() {
        Insets insets = super.getInsets();
        return this._columns + insets.left + insets.right;
    }

    public int getHeight() {
        Insets insets = super.getInsets();
        return this._listModel.getSize() + insets.top + insets.bottom;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(this.getWidth(), this.getVisibleRowCount());
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        this._selectionModel = listSelectionModel;
    }

    public ListSelectionModel getSelectionModel() {
        return this._selectionModel;
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this._selectionModel.addListSelectionListener(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this._selectionModel.removeListSelectionListener(listSelectionListener);
    }

    public int getSelectedIndex() {
        return this._selectionModel.getMinSelectionIndex();
    }

    public int[] getSelectedIndices() {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (!this._selectionModel.isSelectionEmpty()) {
            int n2 = this._selectionModel.getMinSelectionIndex();
            n = this._selectionModel.getMaxSelectionIndex();
            for (int i = n2; i <= n; ++i) {
                if (!this._selectionModel.isSelectedIndex(i)) continue;
                arrayList.add(new Integer(i));
            }
        }
        int[] nArray = new int[arrayList.size()];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = (Integer)arrayList.get(n);
        }
        return nArray;
    }

    public Object getSelectedValue() {
        int n = this._selectionModel.getMinSelectionIndex();
        if (n == -1) {
            return null;
        }
        return this._listModel.getElementAt(n);
    }

    public Object[] getSelectedValues() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (!this._selectionModel.isSelectionEmpty()) {
            int n = this._selectionModel.getMinSelectionIndex();
            int n2 = this._selectionModel.getMaxSelectionIndex();
            for (int i = n; i <= n2; ++i) {
                if (!this._selectionModel.isSelectedIndex(i)) continue;
                arrayList.add(this._listModel.getElementAt(i));
            }
        }
        return arrayList.toArray();
    }

    public synchronized void ensureIndexIsVisible(int n) {
        if (!(this.getParent() instanceof JViewport)) {
            return;
        }
        if (n < 0) {
            n = 0;
        } else if (n > this._listModel.getSize() - 1) {
            n = this._listModel.getSize() - 1;
        }
        this._currentRow = n;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        EventQueue eventQueue = toolkit.getSystemEventQueue();
        eventQueue.postEvent(new ScrollEvent(this, 103, new Point(0, 0)));
        eventQueue.postEvent(new ScrollEvent(this, 102, new Point(0, n)));
    }

    public void setSelectedIndex(int n) {
        this._selectionModel.setSelectionInterval(n, n);
    }

    public void addSelectionInterval(int n, int n2) {
        this._selectionModel.addSelectionInterval(n, n2);
    }

    public void removeSelectionInterval(int n, int n2) {
        this._selectionModel.removeSelectionInterval(n, n2);
    }

    public void clearSelection() {
        this._selectionModel.clearSelection();
    }

    public int getMinSelectionIndex() {
        return this._selectionModel.getMinSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this._selectionModel.getMaxSelectionIndex();
    }

    public void setSelectionMode(int n) {
        this._selectionModel.setSelectionMode(n);
    }

    public int getSelectionMode() {
        return this._selectionModel.getSelectionMode();
    }

    public boolean isIndexSelected(int n) {
        return this._selectionModel.isSelectedIndex(n);
    }

    public Dimension minimumSize() {
        this._columns = 1;
        for (int i = 0; i < this._listModel.getSize(); ++i) {
            String string = this._listModel.getElementAt(i).toString();
            if (string.length() <= this._columns) continue;
            this._columns = string.length();
        }
        Insets insets = super.getInsets();
        return new Dimension(this._columns + insets.left + insets.right, this._visibleRows + insets.top + insets.bottom);
    }

    public void requestFocus() {
        super.requestFocus();
        Point point = this.getLocationOnScreen();
        Insets insets = super.getInsets();
        point.translate(insets.left, insets.top);
        Toolkit.getDefaultToolkit().setCursor(point.addOffset(0, this._currentRow));
    }

    public void draw() {
        int n;
        if (this._currentRow >= this._listModel.getSize()) {
            this._currentRow = this._listModel.getSize() == 0 ? 0 : this._listModel.getSize() - 1;
        }
        super.draw();
        Point point = this.getLocationOnScreen();
        Insets insets = super.getInsets();
        point.translate(insets.left, insets.top);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int n2 = this.getCursesColor();
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this._columns; ++n) {
            stringBuffer.append(' ');
        }
        for (n = 0; n < this._listModel.getSize(); ++n) {
            toolkit.setCursor(point.x, point.y + n);
            int n3 = this.isIndexSelected(n) ? Toolkit.A_REVERSE : 0;
            if (n == this._currentRow) {
                n3 += Toolkit.A_BOLD;
            }
            String string = this._listModel.getElementAt(n).toString();
            StringBuffer stringBuffer2 = new StringBuffer(string);
            for (int i = string.length(); i < this._columns; ++i) {
                stringBuffer2.append(' ');
            }
            toolkit.addString(stringBuffer2.toString(), n3, n2);
        }
        for (n = this._listModel.getSize(); n < this._visibleRows; ++n) {
            toolkit.setCursor(point.x, point.y + n);
            toolkit.addString(stringBuffer.toString(), 0, n2);
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        EventQueue eventQueue = toolkit.getSystemEventQueue();
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 9: {
                this.getParent().nextFocus();
                return;
            }
            case 353: {
                this.getParent().previousFocus();
                return;
            }
            case 258: {
                if (this._currentRow >= this._listModel.getSize() - 1) {
                    return;
                }
                eventQueue.postEvent(new ScrollEvent(this, 102, new Point(0, ++this._currentRow)));
                break;
            }
            case 338: {
                this._currentRow += this._visibleRows;
                if (this._currentRow >= this._listModel.getSize()) {
                    this._currentRow = this._listModel.getSize() - 1;
                }
                eventQueue.postEvent(new ScrollEvent(this, 102, new Point(0, this._currentRow)));
                break;
            }
            case 360: {
                this._currentRow = this._listModel.getSize() - 1;
                eventQueue.postEvent(new ScrollEvent(this, 102, new Point(0, this._currentRow)));
                break;
            }
            case 259: {
                if (this._currentRow < 1) {
                    return;
                }
                eventQueue.postEvent(new ScrollEvent(this, 103, new Point(0, --this._currentRow)));
                break;
            }
            case 339: {
                this._currentRow -= this._visibleRows;
                if (this._currentRow < 0) {
                    this._currentRow = 0;
                }
                eventQueue.postEvent(new ScrollEvent(this, 103, new Point(0, this._currentRow)));
                break;
            }
            case 343: {
                this._doSelect();
                break;
            }
            case 262: {
                this._currentRow = 0;
            }
        }
        if (!(this.getParent() instanceof JViewport)) {
            this.draw();
            this.requestFocus();
            super.requestSync();
        }
    }

    private void _doSelect() {
        if (this._listModel.getSize() == 0) {
            return;
        }
        if (this.isIndexSelected(this._currentRow)) {
            this.removeSelectionInterval(this._currentRow, this._currentRow);
        } else {
            int n = this.getSelectionMode();
            if (n == 201) {
                this.setSelectedIndex(this._currentRow);
            } else {
                this.addSelectionInterval(this._currentRow, this._currentRow);
            }
        }
        this.repaint();
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.getButton() == 1 && mouseEvent.getModifiers() == 102 && this.isFocusTraversable()) {
            if (mouseEvent.getClickCount() == 1) {
                int n = mouseEvent.getY();
                Point point = this.getLocationOnScreen();
                Container container = this.getParent();
                if (container instanceof JViewport) {
                    this._currentRow = n - point.y;
                    this.repaint();
                }
            } else {
                this._doSelect();
            }
        }
    }

    public void addScrollListener(ScrollListener scrollListener) {
        if (this._scrollListeners == null) {
            this._scrollListeners = new Vector();
        }
        this._scrollListeners.add(scrollListener);
    }

    public void removeScrollListener(ScrollListener scrollListener) {
        if (this._scrollListeners == null) {
            return;
        }
        this._scrollListeners.remove(scrollListener);
    }

    public void processScrollEvent(ScrollEvent scrollEvent) {
        if (this._scrollListeners != null) {
            Enumeration enumeration = this._scrollListeners.elements();
            while (enumeration.hasMoreElements()) {
                ScrollListener scrollListener = (ScrollListener)enumeration.nextElement();
                scrollListener.scroll(scrollEvent);
            }
        }
    }

    public void debug(int n) {
        for (int i = 0; i < n; ++i) {
            System.err.print("    ");
        }
        System.err.println("JList origin=" + this._origin + " size=" + this.minimumSize());
    }
}

