/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Color;
import charva.awt.Component;
import charva.awt.Dimension;
import charva.awt.Point;
import charva.awt.Toolkit;
import charva.awt.event.ActionEvent;
import charvax.swing.JMenuBar;
import charvax.swing.JMenuItem;
import charvax.swing.JPopupMenu;
import charvax.swing.JSeparator;
import charvax.swing.SwingUtilities;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.Vector;

public class JMenu
extends JMenuItem {
    private Vector _menuItems = new Vector();
    private WeakReference _parentMenu;
    private boolean _popupMenuVisible = false;
    private JPopupMenu _popup;

    public JMenu() {
    }

    public JMenu(String string) {
        this(string, -1);
    }

    public JMenu(String string, int n) {
        super(string, n);
    }

    public JMenuItem add(JMenuItem jMenuItem) {
        this._menuItems.add(jMenuItem);
        if (jMenuItem instanceof JMenu) {
            ((JMenu)jMenuItem).setParentMenu(this);
        }
        return jMenuItem;
    }

    public void addSeparator() {
        this._menuItems.add(new JSeparator());
    }

    public JMenuItem add(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        this.add(jMenuItem);
        return jMenuItem;
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        Enumeration enumeration = this._menuItems.elements();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            if (component.getForeground() != null) continue;
            component.setForeground(color);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        Enumeration enumeration = this._menuItems.elements();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            if (component.getBackground() != null) continue;
            component.setBackground(color);
        }
    }

    public void draw() {
        Point point = this.getLocationOnScreen();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int n = this.getCursesColor();
        toolkit.setCursor(point);
        if (!(this.getParent() instanceof JMenuBar)) {
            super.draw();
        } else {
            int n2;
            int n3 = super.hasFocus() ? Toolkit.A_BOLD : Toolkit.A_REVERSE;
            toolkit.addString(" ", n3, n);
            toolkit.addString(super.getText(), n3, n);
            toolkit.addString(" ", n3, n);
            if (super.getMnemonic() > 0 && (n2 = super.getText().indexOf((char)super.getMnemonic())) != -1) {
                toolkit.setCursor(point.addOffset(n2 + 1, 0));
                toolkit.addChar(super.getMnemonic(), n3 | Toolkit.A_UNDERLINE, n);
            }
        }
    }

    public JMenuItem getMenuItem(int n) {
        Object e = this._menuItems.elementAt(n);
        if (e instanceof JMenuItem) {
            return (JMenuItem)e;
        }
        return null;
    }

    public void fireActionPerformed(ActionEvent actionEvent) {
        super.fireActionPerformed(actionEvent);
        this.setPopupMenuVisible(true);
        if (this._popup.leftWasPressed()) {
            Toolkit.getDefaultToolkit().fireKeystroke(260);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Toolkit.getDefaultToolkit().fireKeystroke(343);
                }
            });
        } else if (this._popup.rightWasPressed()) {
            Toolkit.getDefaultToolkit().fireKeystroke(261);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Toolkit.getDefaultToolkit().fireKeystroke(343);
                }
            });
        } else if (!this.isTopLevelMenu()) {
            this.getAncestorWindow().hide();
        }
    }

    public Dimension minimumSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public Dimension getSize() {
        return this.minimumSize();
    }

    public int getWidth() {
        return this.getText().length() + 2;
    }

    public int getHeight() {
        return 1;
    }

    public boolean isPopupMenuVisible() {
        return this._popupMenuVisible;
    }

    public void setPopupMenuVisible(boolean bl) {
        this._popupMenuVisible = bl;
        if (!bl) {
            this._popup.hide();
            return;
        }
        if (this._popup == null) {
            this._popup = new JPopupMenu(this._menuItems);
        }
        if (!this.isTopLevelMenu()) {
            JMenu jMenu = (JMenu)this.getParentMenu();
            JPopupMenu jPopupMenu = jMenu.getPopupMenu();
            Point point = jPopupMenu.getLocation();
            int n = jPopupMenu.getComponentIndex(this);
            this._popup.setInvoker(jPopupMenu);
            int n2 = jPopupMenu.getSize().width;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (point.x + n2 + this._popup.getWidth() < toolkit.getScreenColumns()) {
                this._popup.setLocation(point.addOffset(n2 - 1, n));
            } else {
                this._popup.setLocation(point.addOffset(-this._popup.getWidth() + 1, n));
            }
        } else {
            JMenuBar jMenuBar = (JMenuBar)this.getParent();
            Point point = jMenuBar.getPopupMenuLocation(this);
            this._popup.setInvoker(jMenuBar);
            this._popup.setLocation(point);
        }
        this._popup.setFocus(this._popup.getFirstMenuItem());
        this._popup.show();
    }

    public boolean isTopLevelMenu() {
        return this.getParent() instanceof JMenuBar;
    }

    public JPopupMenu getPopupMenu() {
        return this._popup;
    }

    public void debug(int n) {
        for (int i = 0; i < n; ++i) {
            System.err.print("    ");
        }
        System.err.println("JMenu origin=" + this._origin + " text=" + this.getText());
    }

    public String toString() {
        return "JMenu: text=" + this.getText();
    }

    void setParentMenu(Component component) {
        this._parentMenu = new WeakReference<Component>(component);
        if (super.getForeground() == null) {
            super.setForeground(component.getForeground());
        }
        if (super.getBackground() == null) {
            super.setBackground(component.getBackground());
        }
    }

    Component getParentMenu() {
        return (Component)this._parentMenu.get();
    }
}

