/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Component;
import charva.awt.Container;
import charva.awt.Dimension;
import charva.awt.IllegalComponentStateException;
import charva.awt.Point;
import charva.awt.Toolkit;
import charva.awt.event.KeyEvent;
import charvax.swing.JMenu;

public class JMenuBar
extends Container {
    public JMenuBar() {
        this._origin = new Point(1, 1);
    }

    public JMenu add(JMenu jMenu) {
        JMenu jMenu2 = jMenu;
        super.add(jMenu2);
        return jMenu2;
    }

    public int getMenuCount() {
        return super.getComponentCount();
    }

    public JMenu getMenu(int n) {
        return (JMenu)super.getComponent(n);
    }

    public JMenu getMenu(String string) {
        for (int i = 0; i < this.getMenuCount(); ++i) {
            JMenu jMenu = this.getMenu(i);
            if (!jMenu.getText().equals(string)) continue;
            return jMenu;
        }
        throw new IllegalArgumentException("menubar does not contain menu \"" + string + "\"");
    }

    public void draw() {
        Point point = this.getLocationOnScreen();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int n = this.getCursesColor();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.getSize().width; ++i) {
            stringBuffer.append(' ');
        }
        toolkit.setCursor(point);
        toolkit.addString(stringBuffer.toString(), Toolkit.A_REVERSE, n);
        Component[] componentArray = super.getComponents();
        int n2 = 0;
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setLocation(n2, 0);
            componentArray[i].draw();
            n2 += componentArray[i].getWidth();
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 9) {
            this.getParent().nextFocus();
            keyEvent.consume();
            return;
        }
        if (n == 353) {
            this.getParent().previousFocus();
            keyEvent.consume();
            return;
        }
        if (n == 261) {
            Component component = super.getCurrentFocus();
            int n2 = this.getMenuCount();
            int n3 = 0;
            for (n3 = 0; n3 < n2 && component != super.getComponent(n3); ++n3) {
            }
            n3 = n3 == n2 - 1 ? 0 : ++n3;
            this.getMenu(n3).requestFocus();
            keyEvent.consume();
        } else if (n == 260) {
            Component component = super.getCurrentFocus();
            int n4 = this.getMenuCount();
            int n5 = 0;
            for (n5 = 0; n5 < n4 && component != super.getComponent(n5); ++n5) {
            }
            n5 = n5 == 0 ? n4 - 1 : --n5;
            this.getMenu(n5).requestFocus();
            keyEvent.consume();
        } else {
            char c = Character.toLowerCase((char)n);
            for (int i = 0; i < this._components.size(); ++i) {
                char c2;
                JMenu jMenu = this.getMenu(i);
                if (jMenu == null || jMenu.getMnemonic() == -1 || c != (c2 = Character.toLowerCase((char)jMenu.getMnemonic()))) continue;
                jMenu.doClick();
                keyEvent.consume();
                return;
            }
            super.processKeyEvent(keyEvent);
        }
    }

    public Dimension minimumSize() {
        int n = 0;
        for (int i = 0; i < this.getMenuCount(); ++i) {
            n += this.getMenu(i).getText().length() + 1;
        }
        return new Dimension(n, 1);
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public int getWidth() {
        int n;
        Container container = this.getParent();
        if (container == null) {
            throw new IllegalComponentStateException("can't get menubar size before it has been added to a frame");
        }
        int n2 = container.getWidth() - 2;
        int n3 = n2 > (n = this.minimumSize().width) ? n2 : n;
        return n3;
    }

    public int getHeight() {
        return 1;
    }

    public void debug(int n) {
        for (int i = 0; i < n; ++i) {
            System.err.print("    ");
        }
        System.err.println(this.toString());
    }

    public String toString() {
        return "JMenuBar";
    }

    private int getMenuAt(int n, int n2) {
        Point point = this.getLocationOnScreen();
        int n3 = point.x;
        for (int i = 0; i < this.getMenuCount(); ++i) {
            String string = this.getMenu(i).getText();
            if (n >= (n3 += string.length() + 1)) continue;
            return i;
        }
        return -1;
    }

    Point getPopupMenuLocation(JMenu jMenu) {
        Point point = this.getLocationOnScreen();
        int n = 0;
        for (int i = 0; i < this.getMenuCount(); ++i) {
            JMenu jMenu2 = this.getMenu(i);
            if (jMenu2 == jMenu) {
                return point.addOffset(n, 1);
            }
            String string = jMenu2.getText();
            n += string.length() + 1;
        }
        throw new IllegalArgumentException("specified menu not in menubar");
    }
}

