/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Dimension;
import charva.awt.Point;
import charva.awt.Toolkit;
import charvax.swing.AbstractButton;

public class JMenuItem
extends AbstractButton {
    protected Dimension _size = new Dimension(0, 0);

    public JMenuItem() {
    }

    public JMenuItem(String string) {
        this(string, -1);
    }

    public JMenuItem(String string, int n) {
        super.setText(string);
        super.setActionCommand(string);
        super.setMnemonic(n);
    }

    public void draw() {
        int n;
        int n2;
        Point point = this.getLocationOnScreen();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.setCursor(point);
        int n3 = this.getCursesColor();
        if (!super.isEnabled()) {
            n2 = Toolkit.A_NORMAL;
            toolkit.addString("<", n2, n3);
            toolkit.addString(super.getText(), n2, n3);
            toolkit.addString(">", n2, n3);
        } else {
            n2 = super.hasFocus() ? Toolkit.A_BOLD : Toolkit.A_NORMAL;
            toolkit.addString(" ", n2, n3);
            toolkit.addString(super.getText(), n2, n3);
            toolkit.addString(" ", n2, n3);
        }
        if (super.getMnemonic() > 0 && (n = super.getText().indexOf((char)super.getMnemonic())) != -1) {
            toolkit.setCursor(point.addOffset(1 + n, 0));
            toolkit.addChar(super.getMnemonic(), n2 | Toolkit.A_UNDERLINE, n3);
        }
    }

    public Dimension minimumSize() {
        return new Dimension(this.getWidth(), 1);
    }

    public Dimension getSize() {
        return this.minimumSize();
    }

    public int getWidth() {
        return this.getText().length() + 2;
    }

    public int getHeight() {
        return 1;
    }

    public void requestFocus() {
        super.requestFocus();
        Point point = this.getLocationOnScreen();
        Toolkit.getDefaultToolkit().setCursor(point);
    }

    public void debug(int n) {
        for (int i = 0; i < n; ++i) {
            System.err.print("    ");
        }
        System.err.println("JMenuItem origin=" + this._origin + " size=" + this._size);
    }

    public String toString() {
        return "JMenuItem: text=" + this.getText();
    }
}

