/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Container;
import charva.awt.Insets;
import charva.awt.Point;
import charva.awt.Toolkit;
import charvax.swing.JTextField;

public class JPasswordField
extends JTextField {
    private char _echoChar = (char)42;

    public JPasswordField() {
        super("");
    }

    public JPasswordField(String string) {
        super(string);
    }

    public JPasswordField(int n) {
        super("", n);
    }

    public JPasswordField(String string, int n) {
        super(string, n);
    }

    public void setEchoChar(char c) {
        this._echoChar = c;
    }

    public char getEchoChar() {
        return this._echoChar;
    }

    public boolean echoCharIsSet() {
        return this._echoChar != '\u0000';
    }

    public String getText() {
        return super.getText();
    }

    public char[] getPassword() {
        return super.getText().toCharArray();
    }

    public void draw() {
        Point point = this.getLocationOnScreen();
        int n = this.getCursesColor();
        Container container = this.getParent();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (container != null && n != container.getCursesColor()) {
            toolkit.blankBox(point, this.getSize(), n);
        }
        if (this._border != null) {
            this._border.paintBorder(this, n, point.x, point.y, this.getWidth(), this.getHeight());
        }
        Insets insets = super.getInsets();
        point.translate(insets.left, insets.top);
        int n2 = 0;
        if (this._enabled) {
            n2 |= Toolkit.A_UNDERLINE;
        }
        toolkit.setCursor(point);
        toolkit.addString(this._padding, n2, n);
        toolkit.setCursor(point);
        int n3 = this._document.length() > this._offset + this._columns ? this._offset + this._columns : this._document.length();
        StringBuffer stringBuffer = new StringBuffer();
        if (this._echoChar != '\u0000') {
            for (int i = 0; i < this._document.length(); ++i) {
                stringBuffer.append(this._echoChar);
            }
        } else {
            for (int i = 0; i < this._document.length(); ++i) {
                stringBuffer.append(' ');
            }
        }
        toolkit.addString(stringBuffer.substring(this._offset, n3).toString(), n2, n);
        toolkit.setCursor(point.addOffset(this._caretPosition - this._offset, 0));
    }

    public String toString() {
        return "JPasswordField location=" + this.getLocation() + " text=\"" + this._document + "\"" + " actionCommand=\"" + this.getActionCommand() + "\"";
    }

    public void debug(int n) {
        for (int i = 0; i < n; ++i) {
            System.err.print("    ");
        }
        System.err.println("JPasswordField origin=" + this._origin + " size=" + this.getSize() + " text=" + this._document);
    }
}

