/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Component;
import charva.awt.Toolkit;
import charva.awt.event.ActionEvent;
import charva.awt.event.KeyEvent;
import charvax.swing.BoxLayout;
import charvax.swing.JFrame;
import charvax.swing.JMenu;
import charvax.swing.JMenuItem;
import java.util.Vector;

public class JPopupMenu
extends JFrame {
    protected boolean _wasCancelled;
    protected boolean _leftWasPressed;
    protected boolean _rightWasPressed;
    private Component _invoker;

    public JPopupMenu(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            this.add((Component)e);
        }
        this.setLayout(new BoxLayout(this, 101));
        this.pack();
    }

    public void setInvoker(Component component) {
        this._invoker = component;
        this.setForeground(component.getForeground());
        this.setBackground(component.getBackground());
    }

    public Component getInvoker() {
        return this._invoker;
    }

    public JMenuItem getMenuItem(int n) {
        Object e = this._components.elementAt(n);
        if (e instanceof JMenuItem) {
            return (JMenuItem)e;
        }
        return null;
    }

    public JMenuItem getFirstMenuItem() {
        for (int i = 0; i < this._components.size(); ++i) {
            if (!(this._components.elementAt(i) instanceof JMenuItem)) continue;
            return (JMenuItem)this._components.elementAt(i);
        }
        throw new RuntimeException("A JPopupMenu should contain at least one JMenuItem");
    }

    public int getComponentIndex(Component component) {
        return this._components.indexOf(component);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        this._wasCancelled = false;
        this._leftWasPressed = false;
        this._rightWasPressed = false;
        if (!this._visible) {
            return;
        }
        int n = keyEvent.getKeyCode();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (n == 259) {
            super.previousFocus();
        } else if (n == 258) {
            super.nextFocus();
        } else if (n == 260) {
            this._leftWasPressed = true;
            this.hide();
        } else if (n == 261) {
            this._rightWasPressed = true;
            this.hide();
        } else if (n == 343) {
            JMenuItem jMenuItem = (JMenuItem)super.getCurrentFocus();
            this._activate(jMenuItem);
            keyEvent.consume();
        } else if (n == 263 || n == 27) {
            this._wasCancelled = true;
            this.hide();
        } else {
            char c = Character.toLowerCase((char)n);
            for (int i = 0; i < this._components.size(); ++i) {
                char c2;
                JMenuItem jMenuItem = this.getMenuItem(i);
                if (jMenuItem == null || jMenuItem.getMnemonic() == -1 || c != (c2 = Character.toLowerCase((char)jMenuItem.getMnemonic()))) continue;
                this._activate(jMenuItem);
                return;
            }
            toolkit.beep();
        }
    }

    public boolean wasCancelled() {
        return this._wasCancelled;
    }

    boolean leftWasPressed() {
        return this._leftWasPressed;
    }

    boolean rightWasPressed() {
        return this._rightWasPressed;
    }

    private void _activate(JMenuItem jMenuItem) {
        if (jMenuItem instanceof JMenu) {
            JMenu jMenu = (JMenu)jMenuItem;
            jMenu.setPopupMenuVisible(true);
            if (jMenu.getPopupMenu().leftWasPressed()) {
                Toolkit.getDefaultToolkit().fireKeystroke(260);
            } else if (jMenu.getPopupMenu().rightWasPressed()) {
                Toolkit.getDefaultToolkit().fireKeystroke(261);
            } else if (!jMenu.getPopupMenu().wasCancelled()) {
                this.hide();
            }
        } else {
            ActionEvent actionEvent = new ActionEvent(jMenuItem, jMenuItem.getActionCommand());
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.getSystemEventQueue().postEvent(actionEvent);
            this.hide();
        }
    }

    public String toString() {
        String string = "JPopupMenu: [";
        for (int i = 0; i < this.getComponentCount(); ++i) {
            string = string + this.getMenuItem(i);
            string = string + " ";
        }
        return string + "]";
    }
}

