/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Dimension;
import charva.awt.Insets;
import charva.awt.Point;
import charva.awt.Toolkit;
import charva.awt.event.KeyEvent;
import charvax.swing.JComponent;
import charvax.swing.SwingUtilities;

public class JProgressBar
extends JComponent {
    protected int _minimum = 0;
    protected int _value = 0;
    protected int _maximum = 100;
    protected boolean _stringPainted = false;
    protected String _string = "";
    protected int _width = 50;
    protected boolean _indeterminate;
    protected Thread _indeterminateThread;

    public JProgressBar() {
    }

    public JProgressBar(int n, int n2) {
        this._minimum = n;
        this._maximum = n2;
    }

    public void setMinimum(int n) {
        this._minimum = n;
        if (this._maximum <= this._minimum) {
            this._maximum = this._minimum + 1;
        }
        if (this._value < this._minimum) {
            this._value = this._minimum;
        }
    }

    public void setValue(int n) {
        this._value = n < this._minimum ? this._minimum : n;
        this.repaint();
    }

    public void setMaximum(int n) {
        this._maximum = n;
        if (this._minimum > this._maximum) {
            this._minimum = this._maximum - 1;
        }
        if (this._value > this._maximum) {
            this._value = this._maximum;
        }
    }

    public void setSize(Dimension dimension) {
        this._width = dimension.width;
        if (this._width < 3) {
            throw new IllegalArgumentException("length of progress bar must be at least 3");
        }
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public int getWidth() {
        Insets insets = super.getInsets();
        return this._width + insets.left + insets.right;
    }

    public int getHeight() {
        Insets insets = super.getInsets();
        return 1 + insets.top + insets.bottom;
    }

    public void draw() {
        super.draw();
        Point point = this.getLocationOnScreen();
        Insets insets = super.getInsets();
        point.translate(insets.left, insets.top);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int n = this.getCursesColor();
        int n2 = (this._value - this._minimum) * this._width / this._maximum;
        if (!this.isIndeterminate()) {
            int n3;
            for (n3 = 0; n3 < n2; ++n3) {
                toolkit.setCursor(point.addOffset(n3, 0));
                toolkit.addChar(32, Toolkit.A_REVERSE, n);
            }
            for (n3 = n2; n3 < this._width; ++n3) {
                toolkit.setCursor(point.addOffset(n3, 0));
                toolkit.addChar(Toolkit.ACS_CKBOARD, 0, n);
            }
        } else {
            for (int i = 0; i < this._width; ++i) {
                toolkit.setCursor(point.addOffset(i, 0));
                toolkit.addChar(32, 0, n);
            }
            toolkit.setCursor(point.addOffset(n2, 0));
            toolkit.addChar(32, Toolkit.A_REVERSE, n);
        }
        if (this.isStringPainted()) {
            n2 = (this.getSize().width - this._string.length()) / 2;
            toolkit.setCursor(point.addOffset(n2, 0));
            toolkit.addString(this._string, 0, n);
        }
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
    }

    public void requestFocus() {
    }

    public void debug(int n) {
        for (int i = 0; i < n; ++i) {
            System.err.print("    ");
        }
        System.err.println("JProgressBar origin=" + this._origin + " size=" + this.getSize() + " value=" + this._value + " minimum=" + this._minimum + " maximum=" + this._maximum);
    }

    public Dimension minimumSize() {
        return this.getSize();
    }

    public int getMinimum() {
        return this._minimum;
    }

    public int getValue() {
        return this._value;
    }

    public int getMaximum() {
        return this._maximum;
    }

    public boolean isStringPainted() {
        return this._stringPainted;
    }

    public void setStringPainted(boolean bl) {
        this._stringPainted = bl;
    }

    public void setString(String string) {
        this._string = string;
        this.repaint();
    }

    public void setIndeterminate(boolean bl) {
        if (bl == this._indeterminate) {
            return;
        }
        this._indeterminate = bl;
        if (bl) {
            this.setMinimum(0);
            this.setMaximum(100);
            this._indeterminateThread = new IndeterminateThread();
            this._indeterminateThread.start();
        } else if (this._indeterminateThread != null && this._indeterminateThread.isAlive()) {
            this._indeterminateThread.interrupt();
        }
    }

    public boolean isIndeterminate() {
        return this._indeterminate;
    }

    public String getString() {
        return this._string;
    }

    public void finalize() {
        if (this._indeterminateThread != null && this._indeterminateThread.isAlive()) {
            this._indeterminateThread.interrupt();
        }
    }

    private class IndeterminateThread
    extends Thread {
        boolean _right = true;
        int _percent = 0;

        private IndeterminateThread() {
        }

        public void run() {
            try {
                while (true) {
                    this.adjust();
                    Thread.sleep(500L);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JProgressBar.this.setValue(_percent);
                        }
                    });
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        private void adjust() {
            if (this._right) {
                if (this._percent < 96) {
                    this._percent += 4;
                } else {
                    this._right = false;
                }
            } else if (this._percent > 0) {
                this._percent -= 4;
            } else {
                this._right = true;
            }
        }
    }
}

