/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Adjustable;
import charva.awt.Dimension;
import charva.awt.Point;
import charva.awt.Toolkit;
import charva.awt.event.AdjustmentEvent;
import charva.awt.event.AdjustmentListener;
import charva.awt.event.KeyEvent;
import charvax.swing.JComponent;
import java.util.Enumeration;
import java.util.Vector;

public class JScrollBar
extends JComponent
implements Adjustable {
    private int _orientation = 200;
    private int _minimum = 0;
    private int _value = 0;
    private int _extent = 10;
    private int _maximum = 100;
    private int _blockIncrement = 10;
    private int _length = 12;
    protected Vector _adjustmentListeners = null;

    public JScrollBar() {
    }

    public JScrollBar(int n) {
        this.setOrientation(n);
    }

    public JScrollBar(int n, int n2, int n3, int n4, int n5) {
        this.setOrientation(n);
        if (n4 > n2 || n3 < 0 || n2 + n3 > n5) {
            throw new IllegalArgumentException("invalid values for scrollbar");
        }
        this._minimum = n4;
        this._value = n2;
        this._blockIncrement = this._extent = n3;
        this._maximum = n5;
    }

    public int getOrientation() {
        return this._orientation;
    }

    public void setMinimum(int n) {
        this._minimum = n;
        if (this._maximum <= this._minimum) {
            this._maximum = this._minimum + 1;
        }
        if (this._value < this._minimum) {
            this._value = this._minimum;
        }
        if (this._value + this._extent > this._maximum) {
            this._extent = this._maximum - this._value;
        }
    }

    public void setValue(int n) {
        this._value = n < this._minimum ? this._minimum : (n > this._maximum - this._extent ? this._maximum - this._extent : n);
        this.repaint();
    }

    public void setVisibleAmount(int n) {
        this._extent = this._value + this._extent > this._maximum ? this._maximum - this._value : n;
    }

    public void setMaximum(int n) {
        this._maximum = n;
        if (this._minimum > this._maximum) {
            this._minimum = this._maximum - 1;
        }
        if (this._value > this._maximum) {
            this._value = this._maximum;
        }
        if (this._value + this._extent > this._maximum) {
            this._extent = this._maximum - this._value;
        }
    }

    public void setBlockIncrement(int n) {
        this._blockIncrement = n;
    }

    public void setSize(Dimension dimension) {
        this._length = this._orientation == 200 ? dimension.height : dimension.width;
        if (this._length < 3) {
            throw new IllegalArgumentException("length of scrollbar must be at least 3");
        }
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public int getWidth() {
        return this._orientation == 200 ? 1 : this._length;
    }

    public int getHeight() {
        return this._orientation == 200 ? this._length : 1;
    }

    public void draw() {
        block6: {
            Point point = this.getLocationOnScreen();
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            int n = this.getCursesColor();
            if (!this._enabled) break block6;
            int n2 = this._value * (this._length - 2) / this._maximum;
            int n3 = this._extent * (this._length - 2) / this._maximum;
            int n4 = n3 = n3 == 0 ? 1 : n3;
            if (this._orientation == 200) {
                int n5;
                toolkit.setCursor(point);
                toolkit.addChar(94, Toolkit.A_REVERSE, n);
                for (n5 = 1; n5 < this._length - 1; ++n5) {
                    toolkit.setCursor(point.addOffset(0, n5));
                    toolkit.addChar(Toolkit.ACS_CKBOARD, 0, n);
                }
                toolkit.setCursor(point.addOffset(0, this._length - 1));
                toolkit.addChar(118, Toolkit.A_REVERSE, n);
                for (n5 = 0; n5 < n3; ++n5) {
                    toolkit.setCursor(point.addOffset(0, 1 + n2 + n5));
                    toolkit.addChar(32, Toolkit.A_REVERSE, n);
                }
            } else {
                int n6;
                toolkit.setCursor(point);
                toolkit.addChar(60, Toolkit.A_REVERSE, n);
                for (n6 = 1; n6 < this._length - 1; ++n6) {
                    toolkit.setCursor(point.addOffset(n6, 0));
                    toolkit.addChar(Toolkit.ACS_CKBOARD, 0, n);
                }
                toolkit.setCursor(point.addOffset(this._length - 1, 0));
                toolkit.addChar(62, Toolkit.A_REVERSE, n);
                for (n6 = 0; n6 < n3; ++n6) {
                    toolkit.setCursor(point.addOffset(1 + n2 + n6, 0));
                    toolkit.addChar(32, Toolkit.A_REVERSE, n);
                }
            }
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        int n = keyEvent.getKeyCode();
        if (n == 9) {
            this.getParent().nextFocus();
            return;
        }
        if (n == 353) {
            this.getParent().previousFocus();
            return;
        }
        if (n == 260 && this._orientation == 201 || n == 259 && this._orientation == 200) {
            int n2 = this._value - this._blockIncrement;
            this.setValue(n2);
            AdjustmentEvent adjustmentEvent = new AdjustmentEvent(this, this._value);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(adjustmentEvent);
        } else if (n == 261 && this._orientation == 201 || n == 258 && this._orientation == 200) {
            int n3 = this._value + this._blockIncrement;
            this.setValue(n3);
            AdjustmentEvent adjustmentEvent = new AdjustmentEvent(this, this._value);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(adjustmentEvent);
        }
    }

    public void requestFocus() {
        super.requestFocus();
        Point point = this.getLocationOnScreen();
        int n = this._value * (this._length - 2) / this._maximum;
        Toolkit.getDefaultToolkit().setCursor(point.addOffset(1 + n, 0));
    }

    public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (this._adjustmentListeners == null) {
            this._adjustmentListeners = new Vector();
        }
        this._adjustmentListeners.add(adjustmentListener);
    }

    public void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (this._adjustmentListeners == null) {
            return;
        }
        this._adjustmentListeners.remove(adjustmentListener);
    }

    public void processAdjustmentEvent(AdjustmentEvent adjustmentEvent) {
        if (this._adjustmentListeners != null) {
            Enumeration enumeration = this._adjustmentListeners.elements();
            while (enumeration.hasMoreElements()) {
                AdjustmentListener adjustmentListener = (AdjustmentListener)enumeration.nextElement();
                adjustmentListener.adjustmentValueChanged(adjustmentEvent);
            }
        }
    }

    public void debug(int n) {
        for (int i = 0; i < n; ++i) {
            System.err.print("    ");
        }
        System.err.println("JScrollBar origin=" + this._origin + " size=" + this.getSize() + " value=" + this._value + " extent=" + this._extent + " minimum=" + this._minimum + " maximum=" + this._maximum);
    }

    public Dimension minimumSize() {
        return this.getSize();
    }

    public int getMinimum() {
        return this._minimum;
    }

    public int getValue() {
        return this._value;
    }

    public int getVisibleAmount() {
        return this._extent;
    }

    public int getMaximum() {
        return this._maximum;
    }

    public int getBlockIncrement() {
        return this._blockIncrement;
    }

    private void setOrientation(int n) {
        if (n != 200 && n != 201) {
            throw new IllegalArgumentException("Orientation must be VERTICAL or HORIZONTAL");
        }
        this._orientation = n;
    }
}

