/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Component;
import charva.awt.Container;
import charva.awt.Dimension;
import charva.awt.Insets;
import charva.awt.Point;
import charva.awt.Rectangle;
import charva.awt.Scrollable;
import charva.awt.Toolkit;
import charva.awt.event.ScrollEvent;
import charva.awt.event.ScrollListener;
import charvax.swing.JTable;
import charvax.swing.JViewport;
import charvax.swing.border.Border;
import charvax.swing.table.TableHeader;

public class JScrollPane
extends Container
implements ScrollListener {
    private Component _child;
    private JViewport _headerViewport = null;
    private JViewport _childViewport = new JViewport();
    private Border _border;

    public JScrollPane() {
    }

    public JScrollPane(Component component) {
        this.setViewportView(component);
    }

    public void setViewportView(Component component) {
        this._child = component;
        this._childViewport.setView(component);
        this.add(this._childViewport);
        this._childViewport.setParent(this);
        Scrollable scrollable = (Scrollable)((Object)component);
        scrollable.addScrollListener(this);
        if (component instanceof JTable) {
            JTable jTable = (JTable)component;
            TableHeader tableHeader = new TableHeader(jTable.getModel());
            this._headerViewport = new JViewport();
            this._headerViewport.setView(tableHeader);
            this.add(this._headerViewport);
            this._headerViewport.setParent(this);
            this._childViewport.setLocation(new Point(0, 1));
            this._childViewport.setViewPosition(new Point(0, -1));
        }
    }

    public JViewport getViewport() {
        return this._childViewport;
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        Dimension dimension = new Dimension(n, n2);
        if (this._border != null) {
            Insets insets = this._border.getBorderInsets(this);
            dimension.height -= insets.top + insets.bottom;
            dimension.width -= insets.left + insets.right;
        }
        this.setViewportExtents(dimension);
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public Dimension minimumSize() {
        Object object;
        Dimension dimension = new Dimension();
        Component component = this.getViewport().getView();
        if (component instanceof Scrollable) {
            object = (Scrollable)((Object)component);
            dimension.setSize(object.getPreferredScrollableViewportSize());
        } else {
            dimension.setSize(component.getSize());
        }
        this.setViewportExtents(dimension);
        if (this._border != null) {
            object = this._border.getBorderInsets(this);
            dimension.height += ((Insets)object).top + ((Insets)object).bottom;
            dimension.width += ((Insets)object).left + ((Insets)object).right;
        }
        return dimension;
    }

    public void scroll(ScrollEvent scrollEvent) {
        Scrollable scrollable = scrollEvent.getScrollable();
        int n = scrollEvent.getDirection();
        Point point = scrollEvent.getLimit();
        Point point2 = this.getViewport().getLocation();
        point.translate(point2.x, point2.y);
        point.translate(scrollable.getLocation());
        Rectangle rectangle = this._childViewport.getBounds();
        Point point3 = this._childViewport.getViewPosition();
        Point point4 = null;
        if (this._headerViewport != null) {
            point4 = this._headerViewport.getViewPosition();
        }
        if (point.x > rectangle.getRight()) {
            if (n == 100 || n == 104 || n == 106) {
                point3.x -= point.x - rectangle.getRight();
                if (this._headerViewport != null) {
                    point4.x -= point.x - rectangle.getRight();
                }
            } else if (n == 101 || n == 105 || n == 107) {
                point3.x += rectangle.getLeft() - point.x;
                if (this._headerViewport != null) {
                    point4.x += rectangle.getLeft() - point.x;
                }
            }
        } else if (point.x < rectangle.getLeft()) {
            if (n == 101 || n == 105 || n == 107) {
                point3.x += rectangle.getLeft() - point.x;
                if (this._headerViewport != null) {
                    point4.x += rectangle.getLeft() - point.x;
                }
            } else if (n == 100 || n == 104 || n == 106) {
                point3.x -= point.x - rectangle.getRight();
                if (this._headerViewport != null) {
                    point4.x -= point.x - rectangle.getRight();
                }
            }
        }
        if (point.y < rectangle.getTop() && (n == 103 || n == 106 || n == 107)) {
            point3.y += rectangle.getTop() - point.y;
        } else if (point.y > rectangle.getBottom() && (n == 102 || n == 104 || n == 105)) {
            point3.y -= point.y - rectangle.getBottom();
        }
        this._childViewport.setViewPosition(point3);
        if (this._headerViewport != null) {
            this._headerViewport.setViewPosition(point4);
        }
        this.draw();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Point point5 = toolkit.getCursor();
        Point point6 = this._childViewport.getLocationOnScreen();
        if (point5.x < point6.x || point5.y < point6.y) {
            if (point5.x < point6.x) {
                point5.x = point6.x;
            }
            if (point5.y < point6.y) {
                point5.y = point6.y;
            }
            toolkit.setCursor(point5);
        }
    }

    public void draw() {
        int n;
        int n2;
        int n3;
        Point point = this.getLocationOnScreen();
        Insets insets = this.getViewportBorder() != null ? this.getViewportBorder().getBorderInsets(this) : new Insets(0, 0, 0, 0);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int n4 = this.getCursesColor();
        Dimension dimension = this.minimumSize();
        if (this._border != null) {
            this._border.paintBorder(this, 0, point.x, point.y, dimension.width, dimension.height);
        }
        if (this._child instanceof TableHeader) {
            return;
        }
        Dimension dimension2 = this.getViewport().getViewSize();
        Dimension dimension3 = this.getViewport().getExtentSize();
        Point point2 = this.getViewport().getViewPosition();
        if (dimension2.height > dimension3.height) {
            n3 = dimension3.height * dimension3.height / dimension2.height;
            if (dimension3.height * dimension3.height % dimension2.height != 0) {
                ++n3;
            }
            n2 = -1 * point2.y * dimension3.height / dimension2.height;
            for (n = 0; n < dimension3.height; ++n) {
                toolkit.setCursor(point.addOffset(insets.left + dimension3.width, insets.top + n));
                if (n < n2 || n >= n2 + n3) continue;
                toolkit.addChar(Toolkit.ACS_CKBOARD, 0, n4);
            }
        }
        if (dimension2.width > dimension3.width) {
            n3 = dimension3.width * dimension3.width / dimension2.width;
            if (dimension3.width * dimension3.width % dimension2.width != 0) {
                ++n3;
            }
            n2 = -1 * point2.x * dimension3.width / dimension2.width;
            for (n = 0; n < dimension3.width; ++n) {
                toolkit.setCursor(point.addOffset(insets.left + n, insets.top + dimension3.height));
                if (n < n2 || n >= n2 + n3) continue;
                toolkit.addChar(Toolkit.ACS_CKBOARD, 0, n4);
            }
        }
        super.draw();
    }

    public void setViewportBorder(Border border) {
        this._border = border;
        Insets insets = this._border.getBorderInsets(this);
        if (this._headerViewport != null) {
            this._headerViewport.setLocation(new Point(insets.left, insets.top));
            this._childViewport.setLocation(new Point(insets.left, insets.top + 1));
        } else {
            this._childViewport.setLocation(new Point(insets.left, insets.top));
        }
    }

    public Border getViewportBorder() {
        return this._border;
    }

    public void debug(int n) {
        for (int i = 0; i < n; ++i) {
            System.err.print("    ");
        }
        System.err.println("JScrollPane origin=" + this._origin + " size=" + this.getSize());
        super.debug(n + 1);
    }

    public String toString() {
        return "JScrollPane origin=" + this._origin + " size=" + this.getSize();
    }

    private void setViewportExtents(Dimension dimension) {
        if (this._headerViewport != null) {
            this._headerViewport.setExtentSize(dimension.width, 1);
            this._childViewport.setExtentSize(dimension.width, dimension.height - 1);
        } else {
            this._childViewport.setExtentSize(dimension.width, dimension.height);
        }
    }
}

