/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.BorderLayout;
import charva.awt.Component;
import charva.awt.Container;
import charva.awt.Dimension;
import charva.awt.Insets;
import charva.awt.Point;
import charva.awt.Toolkit;
import charva.awt.event.ActionEvent;
import charva.awt.event.ActionListener;
import charvax.swing.ButtonGroup;
import charvax.swing.JButton;
import java.util.Enumeration;
import java.util.Vector;

public class JTabbedPane
extends Container {
    private Vector _tabComponents = new Vector();
    private Vector _tabs = new Vector();
    private int _selectedIndex = -1;
    private ButtonGroup _buttongroup = new ButtonGroup();

    public JTabbedPane() {
        this._insets = new Insets(2, 1, 1, 1);
        this._layoutMgr = new BorderLayout();
    }

    public void add(Component component, Object object) {
        String string = object instanceof String ? (String)object : component.getName();
        int n = this._tabComponents.size() + 1;
        String string2 = "F" + n;
        this.addTab(string, null, component, string2);
    }

    public void addTab(String string, Object object, Component component, String string2) {
        TabButton tabButton = new TabButton(string, component, string2);
        this._tabComponents.add(component);
        this._components.add(this._tabs.size(), tabButton);
        tabButton.setParent(this);
        this._tabs.add(tabButton);
        this._buttongroup.add(tabButton);
        if (this._selectedIndex == -1) {
            this.setSelectedIndex(0);
            tabButton.setSelected(true);
        } else if (this.isDisplayed()) {
            this.repaint();
        }
    }

    public void setSelectedIndex(int n) {
        if (n >= this._tabComponents.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (n == this._selectedIndex) {
            return;
        }
        if (this._selectedIndex != -1) {
            super.remove((Component)this._tabComponents.elementAt(this._selectedIndex));
        }
        TabButton tabButton = (TabButton)this._tabs.elementAt(n);
        tabButton.setSelected(true);
        Component component = (Component)this._tabComponents.elementAt(n);
        super.add(component);
        super.validate();
        this._selectedIndex = n;
        this.repaint();
    }

    public int getSelectedIndex() {
        return this._selectedIndex;
    }

    public void setSelectedComponent(Component component) {
        int n = this._tabComponents.indexOf(component);
        this.setSelectedIndex(n);
    }

    public Dimension getSize() {
        return this.minimumSize();
    }

    public Dimension minimumSize() {
        if (super.isValid()) {
            return this._minimumSize;
        }
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = this._tabComponents.elements();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            Dimension dimension = component.minimumSize();
            if (dimension.width > n) {
                n = dimension.width;
            }
            if (dimension.height <= n2) continue;
            n2 = dimension.height;
        }
        int n3 = 0;
        enumeration = this._tabs.elements();
        while (enumeration.hasMoreElements()) {
            n3 += ((TabButton)enumeration.nextElement()).getWidth();
        }
        if ((n3 += 2) > n) {
            n = n3;
        }
        this._minimumSize = new Dimension(n + this._insets.left + this._insets.right, n2 + this._insets.top + this._insets.bottom);
        this._isValid = true;
        return this._minimumSize;
    }

    public void draw() {
        Point point = this.getLocationOnScreen();
        Point point2 = new Point(0, 0);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int n = this.getCursesColor();
        Dimension dimension = this.getSize();
        toolkit.blankBox(point, dimension, n);
        toolkit.drawBox(point.addOffset(0, 1), new Dimension(dimension.width, dimension.height - 1), n);
        int n2 = 1;
        Enumeration enumeration = this._tabs.elements();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            TabButton tabButton = (TabButton)enumeration.nextElement();
            tabButton.setLocation(point2.addOffset(n2, 0));
            tabButton.draw();
            n2 += tabButton.getWidth();
            ++n3;
        }
        if (this._selectedIndex != -1) {
            Component component = (Component)this._tabComponents.elementAt(this._selectedIndex);
            component.draw();
        }
    }

    public void remove(int n) {
        Component component = (Component)this._tabComponents.elementAt(0);
        this._tabComponents.remove(n);
        super.remove((Component)this._tabs.elementAt(n));
        this._tabs.remove(n);
        if (this.getSelectedIndex() == n) {
            if (n - 1 < 0) {
                if (this.getTabCount() > 0) {
                    this.setSelectedIndex(0);
                } else {
                    this._selectedIndex = -1;
                    super.remove(component);
                    super.validate();
                }
            } else {
                this.setSelectedIndex(n - 1);
            }
        }
        if (this.isDisplayed()) {
            this.repaint();
        }
    }

    public int indexOfTab(String string) {
        for (int i = 0; i < this._tabs.size(); ++i) {
            if (!string.equals(((TabButton)this._tabs.elementAt(i)).getText())) continue;
            return i;
        }
        return -1;
    }

    public String getTitleAt(int n) {
        return ((TabButton)this._tabs.elementAt(n)).getText();
    }

    public void setTitleAt(int n, String string) {
        ((TabButton)this._tabs.elementAt(n)).setText(string);
    }

    public void setEnabledAt(int n, boolean bl) {
        ((TabButton)this._tabs.elementAt(n)).setEnabled(bl);
    }

    public boolean isEnabledAt(int n) {
        return ((TabButton)this._tabs.elementAt(n)).isEnabled();
    }

    public int getTabCount() {
        return this._tabs.size();
    }

    public void debug(int n) {
        for (int i = 0; i < n; ++i) {
            System.err.print("    ");
        }
        System.err.print("JTabbedPane origin=" + this._origin + " size=" + this._size + " _selectedIndex=" + this._selectedIndex + " tabtitles =");
        Enumeration enumeration = this._tabs.elements();
        while (enumeration.hasMoreElements()) {
            String string = ((TabButton)enumeration.nextElement()).getText();
            System.err.print(" " + string + " ");
        }
        System.err.println("");
        super.debug(n + 1);
    }

    private class TabButton
    extends JButton
    implements ActionListener {
        private String _keylabel;
        private Component _c;

        public TabButton(String string, Component component, String string2) {
            super(string);
            this._keylabel = string2;
            this._c = component;
            this.addActionListener(this);
        }

        public String toString() {
            return "JTabbedPane.TabButton locaton=" + this.getLocation() + " label=\"" + this.getLabel() + "\" actionCommand=\"" + this.getActionCommand() + "\"";
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane.this.setSelectedComponent(this._c);
        }

        public String getKeyLabel() {
            return this._keylabel;
        }

        public void setKeyLabel(String string) {
            this._keylabel = string;
        }

        public void requestFocus() {
            super.requestFocus();
            Point point = this.getLocationOnScreen();
            Insets insets = super.getInsets();
            Toolkit.getDefaultToolkit().setCursor(point.addOffset(2 + insets.left, 0 + insets.top));
        }

        public void draw() {
            int n;
            Point point = this.getLocationOnScreen();
            Insets insets = super.getInsets();
            point.translate(insets.left, insets.top);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.setCursor(point);
            int n2 = this.getCursesColor();
            toolkit.addChar(Toolkit.ACS_ULCORNER, 0, n2);
            toolkit.addChar(32, 0, n2);
            toolkit.addString(this.getLabelString(), this.isEnabled() ? Toolkit.A_BOLD : 0, n2);
            toolkit.addChar(32, 0, n2);
            toolkit.addChar(Toolkit.ACS_URCORNER, 0, n2);
            if (this.isEnabled() && this.getMnemonic() > 0 && (n = this.getText().indexOf((char)this.getMnemonic())) != -1) {
                toolkit.setCursor(point.addOffset(2 + n, 0));
                toolkit.addChar(this.getMnemonic(), Toolkit.A_UNDERLINE | Toolkit.A_REVERSE, n2);
            }
            toolkit.setCursor(point.addOffset(0, 1));
            if (this.isSelected()) {
                toolkit.addChar(Toolkit.ACS_LRCORNER, 0, n2);
                for (n = 0; n < this.getText().length() + 2; ++n) {
                    toolkit.addChar(32, 0, n2);
                }
                toolkit.addChar(Toolkit.ACS_LLCORNER, 0, n2);
            } else {
                toolkit.addChar(Toolkit.ACS_BTEE, 0, n2);
                toolkit.setCursor(point.addOffset(this.getText().length() + 3, 1));
                toolkit.addChar(Toolkit.ACS_BTEE, 0, n2);
                if (this.isEnabled()) {
                    toolkit.setCursor(point.addOffset(1, 1));
                    toolkit.addString(this._keylabel, Toolkit.A_BOLD, n2);
                }
            }
        }

        public int getWidth() {
            Insets insets = super.getInsets();
            return super.getText().length() + insets.left + insets.right + 4;
        }
    }
}

