/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Dimension;
import charva.awt.EventQueue;
import charva.awt.Point;
import charva.awt.Scrollable;
import charva.awt.Toolkit;
import charva.awt.event.KeyEvent;
import charva.awt.event.ScrollEvent;
import charva.awt.event.ScrollListener;
import charvax.swing.DefaultListSelectionModel;
import charvax.swing.JComponent;
import charvax.swing.JViewport;
import charvax.swing.ListSelectionModel;
import charvax.swing.event.ListSelectionEvent;
import charvax.swing.event.ListSelectionListener;
import charvax.swing.event.TableModelEvent;
import charvax.swing.event.TableModelListener;
import charvax.swing.table.DefaultTableModel;
import charvax.swing.table.TableModel;
import java.util.Enumeration;
import java.util.Vector;

public class JTable
extends JComponent
implements TableModelListener,
Scrollable,
ListSelectionListener {
    private TableModel _model = null;
    private Dimension _viewportSize;
    private boolean _viewportSizeSet = false;
    private int _currentRow = 0;
    private int _currentColumn = 0;
    private boolean _columnSelectionAllowed = true;
    private boolean _rowSelectionAllowed = true;
    private Vector _scrollListeners = null;
    protected ListSelectionModel _rowSelectionModel = new DefaultListSelectionModel();
    protected ListSelectionModel _columnSelectionModel = new DefaultListSelectionModel();

    public JTable() {
        this(new DefaultTableModel(0, 0));
    }

    public JTable(int n, int n2) {
        this(new DefaultTableModel(n, n2));
    }

    public JTable(Object[][] objectArray, Object[] objectArray2) {
        this(new DefaultTableModel(objectArray, objectArray2));
    }

    public JTable(TableModel tableModel) {
        this.setModel(tableModel);
        this._rowSelectionModel.addListSelectionListener(this);
    }

    public void setModel(TableModel tableModel) {
        this._model = tableModel;
        this._model.addTableModelListener(this);
    }

    public TableModel getModel() {
        return this._model;
    }

    public void setValueAt(Object object, int n, int n2) {
        this._model.setValueAt(object, n, n2);
    }

    public Object getValueAt(int n, int n2) {
        return this._model.getValueAt(n, n2);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.repaint();
    }

    public void requestFocus() {
        super.requestFocus();
        Point point = this.getLocationOnScreen();
        int n = 1;
        for (int i = 0; i < this._currentColumn; ++i) {
            n += this.getColumnWidth(i) + 1;
        }
        Point point2 = point.addOffset(n, this._currentRow + 1);
        if (point2.x < 0) {
            point2.x = 0;
        }
        if (point2.y < 0) {
            point2.y = 0;
        }
        Toolkit.getDefaultToolkit().setCursor(point2);
    }

    public void draw() {
        int n;
        Point point = this.getLocationOnScreen();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int n2 = this._model.getRowCount();
        int n3 = this._model.getColumnCount();
        int n4 = this.getCursesColor();
        toolkit.blankBox(point, this.getSize(), n4);
        toolkit.drawBox(point, this.getSize(), n4);
        int n5 = 1;
        int n6 = Toolkit.A_BOLD;
        for (n = 0; n < n3; ++n) {
            toolkit.setCursor(point.addOffset(n5, 0));
            toolkit.addChar(32, n6, n4);
            toolkit.addString(this._model.getColumnName(n), n6, n4);
            toolkit.addChar(32, n6, n4);
            n5 += this.getColumnWidth(n) + 1;
        }
        if (this._model.getColumnCount() != 0) {
            n5 = this.getColumnWidth(0) + 1;
            for (n = 0; n < n3 - 1; ++n) {
                toolkit.setCursor(point.addOffset(n5, 0));
                toolkit.addChar(Toolkit.ACS_TTEE, 0, n4);
                toolkit.setCursor(point.addOffset(n5, 1));
                toolkit.addVerticalLine(n2, 0, n4);
                toolkit.setCursor(point.addOffset(n5, n2 + 1));
                toolkit.addChar(Toolkit.ACS_BTEE, 0, n4);
                n5 += this.getColumnWidth(n + 1) + 1;
            }
        }
        n5 = 1;
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < n2; ++i) {
                int n7;
                toolkit.setCursor(point.addOffset(n5, i + 1));
                Object object = this._model.getValueAt(i, n);
                int n8 = n7 = this.isRowSelected(i) || this.isColumnSelected(n) ? Toolkit.A_REVERSE : Toolkit.A_NORMAL;
                if (this._currentRow == i || this._currentColumn == n) {
                    n7 += Toolkit.A_BOLD;
                }
                if (object == null) {
                    toolkit.addString("", n7, n4);
                    continue;
                }
                toolkit.addString(object.toString(), n7, n4);
            }
            n5 += this.getColumnWidth(n) + 1;
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        EventQueue eventQueue = toolkit.getSystemEventQueue();
        int n = keyEvent.getKeyCode();
        if (n == 9) {
            this.getParent().nextFocus();
            return;
        }
        if (n == 353) {
            this.getParent().previousFocus();
            return;
        }
        if (n == 259) {
            if (this._currentRow == 0) {
                toolkit.beep();
            } else {
                --this._currentRow;
                int n2 = 0;
                for (int i = 0; i < this._currentColumn; ++i) {
                    n2 += this.getColumnWidth(i) + 1;
                }
                eventQueue.postEvent(new ScrollEvent(this, 103, new Point(n2, this._currentRow + 1)));
            }
        } else if (n == 258) {
            if (this._currentRow == this._model.getRowCount() - 1) {
                toolkit.beep();
            } else {
                ++this._currentRow;
                int n3 = 0;
                for (int i = 0; i < this._currentColumn; ++i) {
                    n3 += this.getColumnWidth(i) + 1;
                }
                eventQueue.postEvent(new ScrollEvent(this, 102, new Point(n3, this._currentRow + 2)));
            }
        } else if (n == 260) {
            if (this._currentColumn == 0) {
                toolkit.beep();
            } else {
                --this._currentColumn;
                int n4 = 0;
                for (int i = 0; i < this._currentColumn; ++i) {
                    n4 += this.getColumnWidth(i) + 1;
                }
                eventQueue.postEvent(new ScrollEvent(this, 101, new Point(n4, this._currentRow)));
            }
        } else if (n == 261) {
            if (this._currentColumn == this._model.getColumnCount() - 1) {
                toolkit.beep();
            } else {
                ++this._currentColumn;
                int n5 = 0;
                for (int i = 0; i <= this._currentColumn; ++i) {
                    n5 += this.getColumnWidth(i) + 1;
                }
                eventQueue.postEvent(new ScrollEvent(this, 100, new Point(n5, this._currentRow)));
            }
        } else if (n == 262) {
            int n6 = 0;
            for (int i = 0; i < this._currentColumn; ++i) {
                n6 += this.getColumnWidth(i) + 1;
            }
            eventQueue.postEvent(new ScrollEvent(this, 101, new Point(n6, this._currentRow)));
        } else if (n == 360) {
            int n7 = 0;
            for (int i = 0; i <= this._currentColumn; ++i) {
                n7 += this.getColumnWidth(i) + 1;
            }
            eventQueue.postEvent(new ScrollEvent(this, 100, new Point(n7, this._currentRow)));
        } else if (n == 343) {
            if (this.getColumnSelectionAllowed()) {
                this.selectCurrentColumn();
            }
            if (this.getRowSelectionAllowed()) {
                this.selectCurrentRow();
            }
            this.repaint();
        }
        if (!(this.getParent() instanceof JViewport)) {
            this.draw();
            this.requestFocus();
            super.requestSync();
        }
    }

    public void addScrollListener(ScrollListener scrollListener) {
        if (this._scrollListeners == null) {
            this._scrollListeners = new Vector();
        }
        this._scrollListeners.add(scrollListener);
    }

    public void removeScrollListener(ScrollListener scrollListener) {
        if (this._scrollListeners == null) {
            return;
        }
        this._scrollListeners.remove(scrollListener);
    }

    public void processScrollEvent(ScrollEvent scrollEvent) {
        if (this._scrollListeners != null) {
            Enumeration enumeration = this._scrollListeners.elements();
            while (enumeration.hasMoreElements()) {
                ScrollListener scrollListener = (ScrollListener)enumeration.nextElement();
                scrollListener.scroll(scrollEvent);
            }
        }
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public Dimension minimumSize() {
        return this.getSize();
    }

    public int getWidth() {
        int n = this._model.getColumnCount();
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 += this.getColumnWidth(i) + 1;
        }
        return n2;
    }

    public int getHeight() {
        int n = this._model.getRowCount();
        return n + 2;
    }

    public void setPreferredScrollableViewportSize(Dimension dimension) {
        this._viewportSize = dimension;
        this._viewportSizeSet = true;
    }

    public Dimension getPreferredScrollableViewportSize() {
        if (this._viewportSizeSet) {
            return new Dimension(this._viewportSize);
        }
        return this.minimumSize();
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        this._rowSelectionModel = listSelectionModel;
        this._rowSelectionModel.addListSelectionListener(this);
    }

    public ListSelectionModel getSelectionModel() {
        return this._rowSelectionModel;
    }

    public void setSelectionMode(int n) {
        this._rowSelectionModel.setSelectionMode(n);
        this._columnSelectionModel.setSelectionMode(n);
    }

    public int getSelectionMode() {
        return this._rowSelectionModel.getSelectionMode();
    }

    public void setColumnSelectionAllowed(boolean bl) {
        this._columnSelectionAllowed = bl;
    }

    public boolean getColumnSelectionAllowed() {
        return this._columnSelectionAllowed;
    }

    public void setRowSelectionAllowed(boolean bl) {
        this._rowSelectionAllowed = bl;
    }

    public boolean getRowSelectionAllowed() {
        return this._rowSelectionAllowed;
    }

    public void addColumnSelectionInterval(int n, int n2) {
        this._columnSelectionModel.addSelectionInterval(n, n2);
    }

    public void addRowSelectionInterval(int n, int n2) {
        this._rowSelectionModel.addSelectionInterval(n, n2);
    }

    public void setColumnSelectionInterval(int n, int n2) {
        this._columnSelectionModel.setSelectionInterval(n, n2);
    }

    public void setRowSelectionInterval(int n, int n2) {
        this._rowSelectionModel.setSelectionInterval(n, n2);
    }

    public int getSelectedRow() {
        return this._rowSelectionModel.getMinSelectionIndex();
    }

    public int getSelectedRowCount() {
        int n = this._rowSelectionModel.getMinSelectionIndex();
        if (n == -1) {
            return 0;
        }
        int n2 = this._rowSelectionModel.getMaxSelectionIndex();
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            if (!this._rowSelectionModel.isSelectedIndex(i)) continue;
            ++n3;
        }
        return n3;
    }

    public int[] getSelectedRows() {
        int n = this.getSelectedRowCount();
        if (n == 0) {
            return new int[0];
        }
        int[] nArray = new int[n];
        int n2 = this._rowSelectionModel.getMinSelectionIndex();
        int n3 = this._rowSelectionModel.getMaxSelectionIndex();
        int n4 = 0;
        for (int i = n2; i <= n3; ++i) {
            if (!this._rowSelectionModel.isSelectedIndex(i)) continue;
            nArray[n4++] = i;
        }
        return nArray;
    }

    public int getSelectedColumn() {
        return this._columnSelectionModel.getMinSelectionIndex();
    }

    public int getSelectedColumnCount() {
        int n = this._columnSelectionModel.getMinSelectionIndex();
        if (n == -1) {
            return 0;
        }
        int n2 = this._columnSelectionModel.getMaxSelectionIndex();
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            if (!this._columnSelectionModel.isSelectedIndex(i)) continue;
            ++n3;
        }
        return n3;
    }

    public int[] getSelectedColumns() {
        int n = this.getSelectedColumnCount();
        if (n == 0) {
            return new int[0];
        }
        int[] nArray = new int[n];
        int n2 = this._columnSelectionModel.getMinSelectionIndex();
        int n3 = this._columnSelectionModel.getMaxSelectionIndex();
        int n4 = 0;
        for (int i = n2; i <= n3; ++i) {
            if (!this._columnSelectionModel.isSelectedIndex(i)) continue;
            nArray[n4++] = i;
        }
        return nArray;
    }

    public boolean isRowSelected(int n) {
        return this._rowSelectionModel.isSelectedIndex(n);
    }

    public boolean isColumnSelected(int n) {
        return this._columnSelectionModel.isSelectedIndex(n);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.repaint();
    }

    public void debug(int n) {
        for (int i = 0; i < n; ++i) {
            System.err.print("    ");
        }
        System.err.println("JTable origin=" + this._origin + " size=" + this.getSize());
    }

    private int getColumnWidth(int n) {
        int n2 = this._model.getColumnName(n).length() + 2;
        for (int i = 0; i < this._model.getRowCount(); ++i) {
            int n3;
            Object object = this.getValueAt(i, n);
            if (object == null || (n3 = object.toString().length()) <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    private void selectCurrentColumn() {
        if (this._columnSelectionModel.isSelectedIndex(this._currentColumn)) {
            this._columnSelectionModel.removeSelectionInterval(this._currentColumn, this._currentColumn);
        } else {
            int n = this._rowSelectionModel.getSelectionMode();
            if (n == 201) {
                this._columnSelectionModel.setSelectionInterval(this._currentColumn, this._currentColumn);
            } else {
                this._columnSelectionModel.addSelectionInterval(this._currentColumn, this._currentColumn);
            }
        }
    }

    private void selectCurrentRow() {
        if (this._rowSelectionModel.isSelectedIndex(this._currentRow)) {
            this._rowSelectionModel.removeSelectionInterval(this._currentRow, this._currentRow);
        } else {
            int n = this._rowSelectionModel.getSelectionMode();
            if (n == 201) {
                this._rowSelectionModel.setSelectionInterval(this._currentRow, this._currentRow);
            } else {
                this._rowSelectionModel.addSelectionInterval(this._currentRow, this._currentRow);
            }
        }
    }
}

