/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Component;
import charva.awt.Dimension;
import charva.awt.Insets;
import charva.awt.Point;
import charva.awt.Rectangle;
import charva.awt.Scrollable;
import charva.awt.Toolkit;
import charva.awt.event.KeyEvent;
import charva.awt.event.MouseEvent;
import charva.awt.event.ScrollEvent;
import charva.awt.event.ScrollListener;
import charvax.swing.JViewport;
import charvax.swing.text.JTextComponent;
import java.util.Enumeration;
import java.util.Vector;

public class JTextArea
extends JTextComponent
implements Scrollable {
    private int _rows;
    private int _columns;
    private int _preferredRows;
    private int _preferredColumns;
    private Point _caret = new Point(0, 0);
    private boolean _lineWrap;
    private boolean _wrapStyleWord = false;
    private Vector _scrollListeners = null;
    private static final int LINE_COUNT = 1;
    private static final int LINE_START_OFFSET = 2;
    private static final int LINE_END_OFFSET = 3;
    private static final int LINE_OF_OFFSET = 4;

    public JTextArea() {
        this("");
    }

    public JTextArea(String string) {
        this(string, 10, 10);
    }

    public JTextArea(String string, int n, int n2) {
        this.setDocument(string);
        this._rows = n;
        this._preferredRows = n;
        this._columns = n2;
        this._preferredColumns = n2;
        this.setCaretPosition(0);
    }

    public void setBounds(Rectangle rectangle) {
        super.setBounds(rectangle);
        this.setColumns(rectangle.getRight() - rectangle.getLeft() + 1);
        this.setRows(rectangle.getBottom() - rectangle.getTop() + 1);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.setColumns(n4 - n2 + 1);
        this.setRows(n3 - n + 1);
    }

    public void setBounds(Point point, Dimension dimension) {
        super.setBounds(point, dimension);
        this.setColumns(dimension.width);
        this.setRows(dimension.height);
    }

    public void setColumns(int n) {
        this._columns = n;
        this._preferredColumns = n;
    }

    public int getColumns() {
        return this._preferredColumns;
    }

    public void setRows(int n) {
        this._rows = n;
        this._preferredRows = n;
    }

    public int getRows() {
        return this._preferredRows;
    }

    public Dimension getSize() {
        return new Dimension(this._columns, this._rows);
    }

    public int getWidth() {
        return this._columns;
    }

    public int getHeight() {
        return this._rows;
    }

    public synchronized void append(String string) {
        this._document.append(string);
        this._caretPosition = this._document.length();
        this.refresh();
    }

    public synchronized void insert(String string, int n) {
        this._document.insert(n, string);
        this._caretPosition = n + string.length();
        this.refresh();
    }

    public synchronized void replaceRange(String string, int n, int n2) {
        this._document.replace(n, n2, string);
        this._caretPosition = n + string.length();
        this.refresh();
    }

    public void setCaretPosition(int n) {
        super.setCaretPosition(n);
        this.refresh();
    }

    public int getLineCount() {
        return this.offsetCalc(1, 0);
    }

    public int getLineStartOffset(int n) {
        return this.offsetCalc(2, n);
    }

    public int getLineEndOffset(int n) {
        return this.offsetCalc(3, n);
    }

    public int getLineOfOffset(int n) {
        return this.offsetCalc(4, n);
    }

    public void setLineWrap(boolean bl) {
        this._lineWrap = bl;
        this._rows = this._preferredRows;
        this._columns = this._preferredColumns;
    }

    public boolean getLineWrap() {
        return this._lineWrap;
    }

    public void setWrapStyleWord(boolean bl) {
        this._wrapStyleWord = bl;
    }

    public boolean getWrapStyleWord() {
        return this._wrapStyleWord;
    }

    public Dimension minimumSize() {
        return this.getSize();
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        int n = this.getCaretPosition();
        int n2 = this.getLineOfOffset(n);
        int n3 = keyEvent.getKeyCode();
        if (n3 == 9) {
            this.getParent().nextFocus();
            return;
        }
        if (n3 == 353) {
            this.getParent().previousFocus();
            return;
        }
        if (n3 == 260 && n > 0) {
            this.setCaretPosition(n - 1);
        } else if (n3 == 261 && n < this.getDocument().length()) {
            this.setCaretPosition(n + 1);
        } else if (n3 == 262) {
            int n4 = this.getLineStartOffset(n2);
            this.setCaretPosition(n4);
        } else if (n3 == 360) {
            int n5 = this.getLineEndOffset(n2);
            this.setCaretPosition(n5);
        } else if ((n3 == 339 || n3 == 338) && this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            int n6 = -1 * jViewport.getViewPosition().y;
            int n7 = jViewport.getSize().height;
            if (n3 == 339) {
                n2 = n2 > n6 ? n6 : n6 - n7;
                n2 = n2 < 0 ? 0 : n2;
            } else {
                n2 = n2 < n6 + n7 - 1 ? n6 + n7 - 1 : n6 + 2 * n7 - 1;
                n2 = n2 > this.getLineCount() - 1 ? this.getLineCount() - 1 : n2;
            }
            this.setCaretPosition(this.getLineStartOffset(n2));
        } else if (n3 == 259 && n2 > 0) {
            int n8 = n - this.getLineStartOffset(n2);
            int n9 = this.getLineStartOffset(n2 - 1);
            int n10 = this.getLineEndOffset(n2 - 1);
            if (n8 > n10 - n9) {
                n8 = n10 - n9;
            }
            this.setCaretPosition(n9 + n8);
        } else if (n3 == 258 && n2 < this.getLineCount() - 1) {
            int n11 = n - this.getLineStartOffset(n2);
            int n12 = this.getLineStartOffset(n2 + 1);
            int n13 = this.getLineEndOffset(n2 + 1);
            if (n11 > n13 - n12) {
                n11 = n13 - n12;
            }
            this.setCaretPosition(n12 + n11);
        } else if (!super.isEditable()) {
            Toolkit.getDefaultToolkit().beep();
        } else if (n3 >= 32 && n3 <= 127) {
            char[] cArray = new char[]{(char)n3};
            this.insert(new String(cArray), n);
        } else if (n3 == 343) {
            char[] cArray = new char[]{'\n'};
            this.insert(new String(cArray), n);
        } else if (n3 == 263 && n > 0) {
            this.replaceRange("", n - 1, n);
        } else if (n3 == 330 && n < this.getDocument().length() - 1) {
            this.replaceRange("", n, n + 1);
        }
        if (!(this.getParent() instanceof JViewport)) {
            this.draw();
            this.requestFocus();
            super.requestSync();
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.getButton() == 1 && mouseEvent.getModifiers() == 102 && this.isFocusTraversable()) {
            Point point = this.getLocationOnScreen();
            Insets insets = super.getInsets();
            point.translate(insets.left, insets.top);
            int n = mouseEvent.getY() - point.y;
            if (n > this.getLineCount() - 1) {
                return;
            }
            int n2 = mouseEvent.getX() - point.x;
            int n3 = this.getLineStartOffset(n);
            int n4 = this.getLineEndOffset(n);
            if (n2 > n4 - n3) {
                n2 = n4 - n3;
            }
            this.setCaretPosition(n3 + n2);
            this.repaint();
        }
    }

    public void draw() {
        Point point = null;
        Point point2 = this._caret;
        Point point3 = this.getLocationOnScreen();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int n = this.getCursesColor();
        toolkit.blankBox(point3, this.getSize(), n);
        toolkit.setCursor(point3);
        ScrollEvent scrollEvent = null;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this._document.length(); ++i) {
            int n4;
            if (this._caretPosition == i && !(point = new Point(n3, n2)).equals(point2)) {
                scrollEvent = this.generateScrollEvent(point, new Point(n3, n2));
                point2 = point;
            }
            char c = this._document.charAt(i);
            if (n3 < this._columns) {
                if (c == '\n') {
                    n3 = 0;
                    if (++n2 >= this._rows) {
                        ++this._rows;
                    }
                    toolkit.setCursor(point3.addOffset(n3, n2));
                    continue;
                }
                toolkit.addChar(c, 0, n);
                ++n3;
                continue;
            }
            if (!this._lineWrap) {
                if (c == '\n') {
                    n3 = 0;
                    if (++n2 >= this._rows) {
                        ++this._rows;
                    }
                    toolkit.setCursor(point3.addOffset(n3, n2));
                    continue;
                }
                toolkit.addChar(c, 0, n);
                ++n3;
                ++this._columns;
                continue;
            }
            if (!this._wrapStyleWord) {
                n3 = 0;
                if (++n2 >= this._rows) {
                    ++this._rows;
                }
                toolkit.setCursor(point3.addOffset(n3, n2));
                if (c == '\n') continue;
                toolkit.addChar(c, 0, n);
                continue;
            }
            for (n4 = 0; n4 < this._columns; ++n4) {
                char c2 = this._document.charAt(i - n4);
                if (c2 != ' ' && c2 != '\t') continue;
                this.deleteEOL(toolkit, n3 - n4, n2, n);
                n3 = 0;
                if (++n2 >= this._rows) {
                    ++this._rows;
                }
                i -= n4;
                toolkit.setCursor(point3.addOffset(n3, n2));
                break;
            }
            if (n4 != this._columns || c != ' ' && c != '\n' && c != '\t') continue;
            n3 = 0;
            if (++n2 >= this._rows) {
                ++this._rows;
            }
            toolkit.setCursor(point3.addOffset(n3, n2));
        }
        if (this._caretPosition == this._document.length()) {
            point = new Point(n3, n2);
            if (!point.equals(point2)) {
                scrollEvent = this.generateScrollEvent(point, new Point(n3, n2));
            }
            point2 = point;
        }
        if (!this._caret.equals(point2) && scrollEvent != null) {
            toolkit.getSystemEventQueue().postEvent(scrollEvent);
            this._caret = point2;
        }
    }

    public void requestFocus() {
        super.requestFocus();
        Point point = this.getLocationOnScreen();
        Toolkit.getDefaultToolkit().setCursor(point.addOffset(this._caret));
    }

    public void addScrollListener(ScrollListener scrollListener) {
        if (this._scrollListeners == null) {
            this._scrollListeners = new Vector();
        }
        this._scrollListeners.add(scrollListener);
    }

    public void removeScrollListener(ScrollListener scrollListener) {
        if (this._scrollListeners == null) {
            return;
        }
        this._scrollListeners.remove(scrollListener);
    }

    public void processScrollEvent(ScrollEvent scrollEvent) {
        if (this._scrollListeners != null) {
            Enumeration enumeration = this._scrollListeners.elements();
            while (enumeration.hasMoreElements()) {
                ScrollListener scrollListener = (ScrollListener)enumeration.nextElement();
                scrollListener.scroll(scrollEvent);
            }
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(this._preferredColumns, this._preferredRows);
    }

    public void debug(int n) {
        for (int i = 0; i < n; ++i) {
            System.err.print("    ");
        }
        System.err.println("JTextArea origin=" + this._origin + " size=" + this.getSize());
    }

    private void deleteEOL(Toolkit toolkit, int n, int n2, int n3) {
        Point point = this.getLocationOnScreen();
        toolkit.setCursor(point.addOffset(n, n2));
        for (int i = n; i < this._columns; ++i) {
            toolkit.addChar(32, 0, n3);
        }
    }

    private int offsetCalc(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        if (n == 2 && n2 == 0) {
            return 0;
        }
        int n5 = 0;
        for (int i = 0; i < this._document.length(); ++i) {
            if (n == 4 && n2 == i) {
                n3 = n4;
            }
            char c = this._document.charAt(i);
            if (n5 < this._columns) {
                if (c == '\n') {
                    n5 = 0;
                    ++n4;
                } else {
                    ++n5;
                }
            } else if (!this._lineWrap) {
                if (c == '\n') {
                    n5 = 0;
                    ++n4;
                }
            } else if (!this._wrapStyleWord) {
                n5 = 0;
                ++n4;
            } else {
                int n6;
                for (n6 = 0; n6 < this._columns; ++n6) {
                    char c2 = this._document.charAt(i - n6);
                    if (c2 != ' ' && c2 != '\t') continue;
                    n5 = 0;
                    ++n4;
                    i -= n6;
                    break;
                }
                if (n6 == this._columns && (c == ' ' || c == '\n' || c == '\t')) {
                    n5 = 0;
                    ++n4;
                }
            }
            if (n == 2 && n5 == 0 && n4 == n2) {
                return i + 1;
            }
            if (n != 3 || n5 != 0 || n4 != n2 + 1) continue;
            return i;
        }
        if (n == 4) {
            if (n2 == this._document.length()) {
                return n4;
            }
            return n3;
        }
        if (n == 1) {
            return n4 + 1;
        }
        if (n == 3 && n4 == n2) {
            return this._document.length();
        }
        throw new IndexOutOfBoundsException("Invalid offset or line number: mode=" + n + " value=" + n2 + " row=" + n4 + " doc=\"" + this._document + "\"");
    }

    private void refresh() {
        Component component = this.getParent() instanceof JViewport ? this.getParent() : this;
        component.repaint();
    }

    private ScrollEvent generateScrollEvent(Point point, Point point2) {
        int n = point.y > this._caret.y ? (point.x > this._caret.x ? 104 : (point.x < this._caret.x ? 105 : 102)) : (point.y < this._caret.y ? (point.x > this._caret.x ? 106 : (point.x < this._caret.x ? 107 : 103)) : (point.x > this._caret.x ? 100 : 101));
        return new ScrollEvent(this, n, point2);
    }
}

