/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Dimension;
import charva.awt.Font;
import charva.awt.Insets;
import charva.awt.Point;
import charva.awt.Rectangle;
import charva.awt.Toolkit;
import charva.awt.event.AWTEvent;
import charva.awt.event.ActionEvent;
import charva.awt.event.ActionListener;
import charva.awt.event.KeyEvent;
import charva.awt.event.MouseEvent;
import charvax.swing.text.JTextComponent;
import java.util.Enumeration;
import java.util.Vector;

public class JTextField
extends JTextComponent {
    protected boolean _bold = false;
    protected int _columns;
    protected int _offset = 0;
    protected String _padding;
    private String _actionCommand = new String("");
    protected Vector _actionListeners = null;

    public JTextField() {
        this("", 10);
    }

    public JTextField(String string) {
        this(string, string.length());
    }

    public JTextField(int n) {
        this("", n);
    }

    public JTextField(String string, int n) {
        super.setText(string);
        this.setColumns(n);
        this._caretPosition = this._document.length();
        this._offset = this._document.length() > this._columns ? this._document.length() - this._columns : 0;
    }

    public void setColumns(int n) {
        this._columns = n;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this._columns; ++i) {
            stringBuffer.append(' ');
        }
        this._padding = new String(stringBuffer);
        super.invalidate();
    }

    public void setBounds(Rectangle rectangle) {
        super.setBounds(rectangle);
        this.setColumns(rectangle.getRight() - rectangle.getLeft() + 1);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.setColumns(n4 - n2 + 1);
    }

    public void setBounds(Point point, Dimension dimension) {
        super.setBounds(point, dimension);
        this.setColumns(dimension.width);
    }

    public int getColumns() {
        return this._columns;
    }

    public void setFont(Font font) {
        this._bold = (font.getStyle() & 1) != 0;
    }

    public void setActionCommand(String string) {
        this._actionCommand = string;
    }

    public String getActionCommand() {
        return this._actionCommand;
    }

    public Dimension getSize() {
        Insets insets = super.getInsets();
        return new Dimension(this._columns + insets.left + insets.right, 1 + insets.top + insets.bottom);
    }

    public int getWidth() {
        Insets insets = super.getInsets();
        return this._columns + insets.left + insets.right;
    }

    public int getHeight() {
        Insets insets = super.getInsets();
        return 1 + insets.top + insets.bottom;
    }

    public Dimension minimumSize() {
        return this.getSize();
    }

    public void setEditable(boolean bl) {
        super.setEnabled(bl);
    }

    public boolean isEditable() {
        return this.isEnabled();
    }

    public void draw() {
        super.draw();
        int n = 0;
        if (this._enabled) {
            n |= Toolkit.A_UNDERLINE;
        }
        if (this._bold) {
            n |= Toolkit.A_BOLD;
        }
        Point point = this.getLocationOnScreen();
        Insets insets = super.getInsets();
        point.translate(insets.left, insets.top);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int n2 = this.getCursesColor();
        toolkit.setCursor(point);
        toolkit.addString(this._padding, n, n2);
        toolkit.setCursor(point);
        int n3 = super.getText().length() > this._offset + this._columns ? this._offset + this._columns : super.getText().length();
        toolkit.addString(super.getText().substring(this._offset, n3).toString(), n, n2);
        toolkit.setCursor(point.addOffset(this._caretPosition - this._offset, 0));
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        int n = keyEvent.getKeyCode();
        if (n == 9) {
            this.getParent().nextFocus();
            return;
        }
        if (n == 353) {
            this.getParent().previousFocus();
            return;
        }
        if (!keyEvent.isActionKey()) {
            if (n >= 32) {
                this._document.insert(this._caretPosition, (char)n);
                ++this._caretPosition;
                if (this._caretPosition - this._offset > this._columns) {
                    ++this._offset;
                }
            }
        } else if (n == 260 && this._caretPosition > 0) {
            --this._caretPosition;
            if (this._caretPosition < this._offset) {
                --this._offset;
            }
        } else if (n == 261 && this._caretPosition < this._document.length()) {
            ++this._caretPosition;
            if (this._caretPosition - this._offset > this._columns) {
                ++this._offset;
            }
        } else if (n == 263 && this._caretPosition > 0) {
            --this._caretPosition;
            this._document.deleteCharAt(this._caretPosition);
            if (this._caretPosition < this._offset) {
                --this._offset;
            }
        } else if (n == 330 && this._caretPosition >= 0 && this._caretPosition < this._document.length()) {
            this._document.deleteCharAt(this._caretPosition);
        } else if (n == 262) {
            this._caretPosition = 0;
            this._offset = 0;
        } else if (n == 360) {
            this._caretPosition = this._document.length();
            this._offset = this._document.length() > this._columns ? this._document.length() - this._columns : 0;
        } else if (n == 343) {
            ActionEvent actionEvent = new ActionEvent(this, this._actionCommand);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(actionEvent);
        }
        this.draw();
        super.requestSync();
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.getButton() == 1 && mouseEvent.getModifiers() == 102 && this.isFocusTraversable()) {
            int n = mouseEvent.getX();
            Point point = this.getLocationOnScreen();
            Insets insets = super.getInsets();
            point.translate(insets.left, insets.top);
            int n2 = this._offset + (n - point.x);
            this._caretPosition = n2 < this._document.length() ? n2 : this._document.length();
            this.repaint();
        }
    }

    public synchronized void setText(String string) {
        super.setText(string);
        this._caretPosition = this._document.length();
        this._offset = this._document.length() > this._columns ? this._document.length() - this._columns : 0;
        super.repaint();
    }

    protected void processEvent(AWTEvent aWTEvent) {
        super.processEvent(aWTEvent);
        if (aWTEvent instanceof ActionEvent) {
            this.postActionEvent((ActionEvent)aWTEvent);
        }
    }

    public void postActionEvent(ActionEvent actionEvent) {
        if (this._actionListeners != null) {
            Enumeration enumeration = this._actionListeners.elements();
            while (enumeration.hasMoreElements()) {
                ActionListener actionListener = (ActionListener)enumeration.nextElement();
                actionListener.actionPerformed(actionEvent);
            }
        }
    }

    public void addActionListener(ActionListener actionListener) {
        if (this._actionListeners == null) {
            this._actionListeners = new Vector();
        }
        this._actionListeners.add(actionListener);
    }

    public void requestFocus() {
        super.requestFocus();
        Point point = this.getLocationOnScreen();
        Insets insets = super.getInsets();
        point.translate(insets.left, insets.top);
        Toolkit.getDefaultToolkit().setCursor(point.addOffset(this._caretPosition - this._offset, 0));
    }

    public String toString() {
        return "JTextField location=" + this.getLocation() + " text=\"" + this._document + "\"" + " actionCommand=\"" + this._actionCommand + "\"";
    }

    public void debug(int n) {
        for (int i = 0; i < n; ++i) {
            System.err.print("    ");
        }
        System.err.println("JTextField origin=" + this._origin + " size=" + this.getSize() + " text=" + this._document);
    }
}

