/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Component;
import charva.awt.Container;
import charva.awt.Dimension;
import charva.awt.Point;
import charva.awt.Rectangle;
import charva.awt.Scrollable;
import charva.awt.Toolkit;
import charvax.swing.table.TableHeader;

public class JViewport
extends Container {
    private Component _child;
    private Dimension _extent;

    public void setView(Component component) {
        if (!(component instanceof Scrollable) && !(component instanceof TableHeader)) {
            throw new IllegalArgumentException("JViewport's view must be a Scrollable or a TableHeader");
        }
        if (this._child != null) {
            super.remove(this._child);
        }
        super.add(component);
        this._child = component;
    }

    public Component getView() {
        return this._child;
    }

    public void draw() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Point point = this.getLocationOnScreen();
        toolkit.setClipRect(new Rectangle(point, this.getExtentSize()));
        this._child.draw();
        toolkit.resetClipRect();
    }

    public Point getViewPosition() {
        return this._child.getLocation();
    }

    public void setViewPosition(Point point) {
        this._child.setLocation(point);
    }

    public Dimension getViewSize() {
        return this._child.getSize();
    }

    public Rectangle getBounds() {
        return new Rectangle(this.getLocation(), this.getExtentSize());
    }

    void setExtentSize(int n, int n2) {
        this._extent = new Dimension(n, n2);
    }

    public Dimension getExtentSize() {
        return new Dimension(this._extent);
    }

    public void debug(int n) {
        for (int i = 0; i < n; ++i) {
            System.err.print("    ");
        }
        System.err.println("Viewport origin=" + this._origin + " size=" + this.getSize());
        super.debug(n + 1);
    }
}

