/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing.border;

import charva.awt.Color;
import charva.awt.Component;
import charva.awt.Font;
import charva.awt.Insets;
import charva.awt.Point;
import charva.awt.Toolkit;
import charvax.swing.border.Border;
import charvax.swing.border.LineBorder;

public class TitledBorder
implements Border {
    protected String _title;
    protected Color _titleColor;
    protected Border _border;

    public TitledBorder(Border border_) {
        this(border_, "", 0, 0, null, null);
    }

    public TitledBorder(String title_) {
        this(new LineBorder(null), title_, 0, 0, null, null);
    }

    public TitledBorder(Border border_, String title_) {
        this(border_, title_, 0, 0, null, null);
    }

    public TitledBorder(Border border_, String title_, int titleJustification_, int titlePosition_, Font titleFont_, Color titleColor_) {
        this._border = border_;
        this._title = title_;
        this._titleColor = titleColor_;
    }

    public Insets getBorderInsets(Component component_) {
        return new Insets(1, 1, 1, 1);
    }

    public void setTitle(String title_) {
        this._title = title_;
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitleColor(Color titleColor_) {
        this._titleColor = titleColor_;
    }

    public Color getTitleColor() {
        return this._titleColor;
    }

    public void setBorder(Border border_) {
        this._border = border_;
    }

    public Border getBorder() {
        return this._border;
    }

    public void paintBorder(Component component_, int graphics_, int x_, int y_, int width_, int height_) {
        this._border.paintBorder(component_, graphics_, x_, y_, width_, height_);
        Color background = component_.getBackground();
        if (this._titleColor == null) {
            this._titleColor = component_.getForeground();
        }
        int colorpair = Color.getCursesColor(this._titleColor, background);
        Toolkit term = Toolkit.getDefaultToolkit();
        if (this._title.length() != 0) {
            Point origin = new Point(x_, y_);
            term.setCursor(origin.addOffset(1, 0));
            term.addChar(32, 0, colorpair);
            term.addString(this._title, 0, colorpair);
            term.addChar(32, 0, colorpair);
        }
    }
}

