/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing.tree;

import charvax.swing.tree.MutableTreeNode;
import charvax.swing.tree.TreeNode;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class DefaultMutableTreeNode
implements MutableTreeNode {
    protected Vector _children;
    protected DefaultMutableTreeNode _parent;
    protected boolean _allowsChildren = true;
    protected Object _userObject;

    DefaultMutableTreeNode() {
        this(null, true);
    }

    DefaultMutableTreeNode(Object userObject) {
        this(userObject, true);
    }

    DefaultMutableTreeNode(Object userObject, boolean allowsChildren) {
        this._userObject = userObject;
        this._allowsChildren = allowsChildren;
    }

    public void insert(MutableTreeNode child, int index) {
        if (!this._allowsChildren) {
            throw new IllegalStateException("TreeNode does not allow children");
        }
        if (this._children == null) {
            this._children = new Vector();
        }
        this._children.insertElementAt(child, index);
        child.setParent(this);
    }

    public void remove(int index) {
        MutableTreeNode node = (MutableTreeNode)this._children.elementAt(index);
        if (node != null) {
            this.remove(node);
        }
    }

    public void remove(MutableTreeNode node) {
        this._children.remove(node);
        node.setParent(null);
    }

    public void setUserObject(Object object) {
        this._userObject = object;
    }

    public void removeFromParent() {
        if (this._parent == null) {
            return;
        }
        this._parent.remove(this);
    }

    public void setParent(MutableTreeNode newParent) {
        this._parent = (DefaultMutableTreeNode)newParent;
    }

    public TreeNode getParent() {
        return this._parent;
    }

    public TreeNode getChildAt(int index) {
        return (TreeNode)this._children.elementAt(index);
    }

    public int getChildCount() {
        if (this._children == null) {
            return 0;
        }
        return this._children.size();
    }

    public int getIndex(TreeNode aChild) {
        if (this._children == null) {
            return -1;
        }
        return this._children.indexOf(aChild);
    }

    public Enumeration children() {
        if (this._children == null) {
            return null;
        }
        return this._children.elements();
    }

    public void setAllowsChildren(boolean allows) {
        this._allowsChildren = allows;
    }

    public boolean getAllowsChildren() {
        return this._allowsChildren;
    }

    public Object getUserObject() {
        return this._userObject;
    }

    public void removeAllChildren() {
        if (this._children == null) {
            return;
        }
        Enumeration e = this._children.elements();
        while (e.hasMoreElements()) {
            MutableTreeNode node = (MutableTreeNode)e.nextElement();
            node.setParent(null);
        }
        this._children.removeAllElements();
    }

    public void add(MutableTreeNode newChild) {
        if (newChild == null) {
            throw new IllegalArgumentException("child node is null");
        }
        if (!this._allowsChildren) {
            throw new IllegalStateException("TreeNode does not allow children");
        }
        newChild.setParent(this);
        if (this._children == null) {
            this._children = new Vector();
        }
        this._children.add(newChild);
    }

    public boolean isNodeAncestor(TreeNode anotherNode) {
        if (anotherNode == null) {
            return false;
        }
        if (anotherNode == this) {
            return true;
        }
        if (this._parent == null) {
            return false;
        }
        DefaultMutableTreeNode parent = this._parent;
        while (parent != null) {
            if (parent == anotherNode) {
                return true;
            }
            parent.getParent();
        }
        return false;
    }

    public boolean isNodeDescendant(TreeNode anotherNode) {
        if (anotherNode == null) {
            return false;
        }
        if (anotherNode == this) {
            return true;
        }
        if (this._children == null || this._children.size() == 0) {
            return false;
        }
        TreeNode parent = anotherNode.getParent();
        while (parent != null) {
            if (parent == this) {
                return true;
            }
            parent.getParent();
        }
        return false;
    }

    public int getDepth() {
        return this._depth(this, 0);
    }

    public int getLevel() {
        DefaultMutableTreeNode parent = this._parent;
        int i = 0;
        while (parent != null) {
            ++i;
        }
        return i;
    }

    public TreeNode[] getPath() {
        TreeNode[] path = new TreeNode[this.getLevel() + 1];
        TreeNode node = this;
        for (int i = path.length - 1; i >= 0; --i) {
            path[i] = node;
            node = node.getParent();
        }
        return path;
    }

    public Object[] getUserObjectPath() {
        Object[] objectPath = new Object[this.getLevel() + 1];
        MutableTreeNode node = this;
        for (int i = objectPath.length - 1; i >= 0; --i) {
            objectPath[i] = node.getUserObject();
            node = (MutableTreeNode)node.getParent();
        }
        return objectPath;
    }

    public TreeNode getRoot() {
        TreeNode parent = this.getParent();
        while (parent != null) {
            if (parent.getParent() != null) continue;
            return parent;
        }
        return null;
    }

    public boolean isRoot() {
        return this._parent == null;
    }

    public Enumeration preorderEnumeration() {
        return null;
    }

    public Enumeration postorderEnumeration() {
        return null;
    }

    public boolean isNodeChild(TreeNode aNode) {
        if (aNode == null) {
            return false;
        }
        return aNode.getParent() == this;
    }

    public TreeNode getFirstChild() {
        if (this._children == null) {
            throw new NoSuchElementException("Node has no child");
        }
        return (TreeNode)this._children.firstElement();
    }

    public TreeNode getLastChild() {
        if (this._children == null) {
            throw new NoSuchElementException("Node has no child");
        }
        return (TreeNode)this._children.lastElement();
    }

    public TreeNode getChildAfter(TreeNode aChild) {
        if (!this.isNodeChild(aChild)) {
            throw new IllegalArgumentException("not a child of this node");
        }
        int index = this._children.indexOf(aChild);
        if (index + 1 >= this._children.size()) {
            return null;
        }
        return (TreeNode)this._children.elementAt(index + 1);
    }

    public TreeNode getChildBefore(TreeNode aChild) {
        if (!this.isNodeChild(aChild)) {
            throw new IllegalArgumentException("not a child of this node");
        }
        int index = this._children.indexOf(aChild);
        if (index == 0) {
            return null;
        }
        return (TreeNode)this._children.elementAt(index - 1);
    }

    public boolean isLeaf() {
        return this._children != null && this._children.size() > 0;
    }

    public DefaultMutableTreeNode getFirstLeaf() {
        DefaultMutableTreeNode node = this;
        while (!node.isLeaf()) {
            node = (DefaultMutableTreeNode)node.getChildAt(0);
        }
        return node;
    }

    public DefaultMutableTreeNode getLastLeaf() {
        DefaultMutableTreeNode node = this;
        while (!node.isLeaf()) {
            node = (DefaultMutableTreeNode)node.getChildAt(node.getChildCount() - 1);
        }
        return node;
    }

    public DefaultMutableTreeNode getNextLeaf() {
        if (this._parent == null) {
            return null;
        }
        DefaultMutableTreeNode nextNode = (DefaultMutableTreeNode)this._parent.getChildAfter(this);
        if (nextNode == null) {
            return null;
        }
        return nextNode.getFirstLeaf();
    }

    public DefaultMutableTreeNode getPreviousLeaf() {
        if (this._parent == null) {
            return null;
        }
        DefaultMutableTreeNode nextNode = (DefaultMutableTreeNode)this._parent.getChildBefore(this);
        if (nextNode == null) {
            return null;
        }
        return nextNode.getLastLeaf();
    }

    private int _depth(TreeNode node, int start) {
        if (node.isLeaf()) {
            return start;
        }
        int depth = start;
        Enumeration e = node.children();
        while (e.hasMoreElements()) {
            TreeNode child = (TreeNode)e.nextElement();
            int child_depth = this._depth(child, start);
            depth = child_depth > depth ? child_depth : depth;
        }
        return depth + 1;
    }
}

