/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.joe;

import com.veryant.joe.Block;
import com.veryant.joe.BreakCmdException;
import com.veryant.joe.BreakLoopException;
import com.veryant.joe.CommandBase;
import com.veryant.joe.ExecException;
import com.veryant.joe.JOEException;
import com.veryant.joe.JavaObjectsExecutor;
import com.veryant.joe.WBoolean;
import com.veryant.joe.Wrapper;
import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.JOptionPane;

public class DefaultCommand
extends CommandBase {
    public String readLine() throws IOException {
        Console cons = System.console();
        if (cons != null) {
            return cons.readLine();
        }
        throw new IOException("console not available");
    }

    public Object println() {
        System.out.println("");
        return this;
    }

    public Object print(Object ... b) {
        String s = "";
        for (int i = 0; i < b.length; ++i) {
            s = b[i] == null ? s + "(null)" : s + b[i].toString();
        }
        System.out.print(s);
        return this;
    }

    public Object println(Object ... b) {
        String s = "";
        for (int i = 0; i < b.length; ++i) {
            s = b[i] == null ? s + "(null)" : s + b[i].toString();
        }
        System.out.println(s);
        return this;
    }

    public Object $if(Boolean cond, Block ifTrue) throws Exception {
        Object Return = cond;
        if (cond.booleanValue()) {
            Return = ifTrue.exec();
        }
        return Return;
    }

    public Object $if(boolean cond, Block ifTrue, Block ifFalse) throws Exception {
        Object Return = cond ? ifTrue.exec() : ifFalse.exec();
        return Return;
    }

    public Object $if(Block cond, Block ifTrue) throws Exception {
        Object cnd = cond.exec();
        if (cnd != null && cnd instanceof WBoolean) {
            return this.$if(((WBoolean)cnd).booleanValue(), ifTrue);
        }
        return null;
    }

    public Object $if(Block cond, Block ifTrue, Block ifFalse) throws Exception {
        Object cnd = cond.exec();
        if (cnd != null && cnd instanceof WBoolean) {
            return this.$if(((WBoolean)cnd).booleanValue(), ifTrue, ifFalse);
        }
        return null;
    }

    public Object $while(Block cond, Block code) throws JOEException {
        Object Return;
        while ((Return = cond.exec()) != null && Return instanceof WBoolean && ((WBoolean)Return).booleanValue()) {
            try {
                Return = code.exec();
            }
            catch (BreakLoopException _ex) {
                if (!_ex.hasReturnObject()) break;
                Return = _ex.getReturnObject();
                break;
            }
        }
        return Return;
    }

    public Object foreach(Object[] list, int n, Block code) throws JOEException {
        Object Return = null;
        for (int i = n; i < list.length; ++i) {
            try {
                Wrapper o = Wrapper.newInstance(list[i]);
                if (o != null) {
                    Return = code.exec(o);
                    continue;
                }
                Return = code.exec(list[i]);
                continue;
            }
            catch (BreakLoopException _ex) {
                if (!_ex.hasReturnObject()) break;
                Return = _ex.getReturnObject();
                break;
            }
        }
        return Return;
    }

    public Object foreach(Object[] list, Block code) throws JOEException {
        return this.foreach(list, 0, code);
    }

    public void breakLoop() throws BreakLoopException {
        throw new BreakLoopException();
    }

    public Object $switch(Object cfrt) {
        return new Switch(cfrt);
    }

    public Object switchTrue() {
        return new Switch(Boolean.TRUE);
    }

    public Object $break() throws Exception {
        throw new BreakCmdException("");
    }

    public Object $break(String blkName) throws Exception {
        throw new BreakCmdException(blkName);
    }

    public Object $try(Block blk) throws Exception {
        Object Return;
        try {
            Return = blk.exec();
        }
        catch (JOEException ex) {
            Return = ex.getCause() != null ? ex.getCause() : ex;
        }
        catch (Throwable ex) {
            Return = ex;
        }
        return Return;
    }

    public Object $try(Block blk, Block excpt) throws Exception {
        Object Return;
        try {
            Return = blk.exec();
        }
        catch (JOEException ex) {
            Return = ex.getCause() != null ? ex.getCause() : ex;
            Return = excpt.exec(Return);
        }
        catch (Throwable ex) {
            Return = excpt.exec(ex);
        }
        return Return;
    }

    public int exec(String ... cmds) throws Exception {
        String line;
        Runtime rt = Runtime.getRuntime();
        Process proc = rt.exec(cmds);
        BufferedReader bro = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        BufferedReader bre = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
        while ((line = bro.readLine()) != null || (line = bre.readLine()) != null) {
            this.println(line);
        }
        return proc.waitFor();
    }

    public String execGetOut(String ... cmds) throws Exception {
        Runtime rt = Runtime.getRuntime();
        Process proc = rt.exec(cmds);
        BufferedReader bro = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        BufferedReader bre = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
        StringBuilder Return = new StringBuilder();
        String line = bro.readLine();
        if (line != null) {
            Return.append(line);
        }
        while (true) {
            if ((line = bro.readLine()) != null) {
                Return.append(' ');
                Return.append(line);
                continue;
            }
            line = bre.readLine();
            if (line == null) break;
            this.println(line);
        }
        return Return.toString();
    }

    public int runJoe(String ... cmds) throws Exception {
        return JavaObjectsExecutor.imain(cmds);
    }

    public int execJoe(String ... cmds) throws ExecException {
        throw new ExecException(cmds);
    }

    public String systemGetenv(String name) {
        return System.getenv(name);
    }

    public void showMessageDialog(Object ... message) {
        String msg = "";
        for (int i = 0; i < message.length; ++i) {
            msg = msg + message[i].toString();
        }
        JOptionPane.showMessageDialog(null, msg);
    }

    public String showInputDialog(Object ... message) {
        String msg = "";
        for (int i = 0; i < message.length; ++i) {
            msg = message[i] == null ? msg + "(null)" : msg + message[i].toString();
        }
        String Return = JOptionPane.showInputDialog(null, (Object)msg);
        if (Return == null) {
            Return = "";
        }
        return Return;
    }

    protected static class Switch {
        private final Object cfrt1;
        private boolean alreadyDone;
        private boolean prevCondition;
        private Object Return;

        protected Switch(Object cfrt) {
            this.cfrt1 = cfrt;
        }

        public Object $case(Object cfrt2) {
            this.prevCondition |= this.cfrt1.equals(cfrt2);
            return this;
        }

        public Object $case(Object cfrt2, Block block) throws Exception {
            if (!this.alreadyDone && (this.prevCondition || this.cfrt1.equals(cfrt2))) {
                this.alreadyDone = true;
                this.Return = block.exec();
            } else {
                this.prevCondition = false;
            }
            return this;
        }

        public Object $default(Block block) throws Exception {
            if (!this.alreadyDone) {
                this.alreadyDone = true;
                this.Return = block.exec();
            }
            return this;
        }

        public Object endSwitch() {
            return this.Return;
        }
    }
}

