/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.joe;

import com.veryant.joe.Block;
import com.veryant.joe.ClassReference;
import com.veryant.joe.InternalObject;
import com.veryant.joe.JOEException;
import com.veryant.joe.Message;
import com.veryant.joe.Token;
import com.veryant.joe.Wrapper;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class ExecMessage
implements Message {
    static final HashMap<Class, Class> primitiveClasses;
    private static HashSet<String> javaKeywords;
    private Object object;
    private Message receiver;
    private final String selector;
    private Class clazz;
    private final Object[] origArgs;
    private final String fName;
    private final int row;
    private final int col;
    private final HashMap<Class, Method[]> methCache = new HashMap();

    public static String getJSelector(String s) {
        if (javaKeywords.contains(s)) {
            return "$" + s;
        }
        return s;
    }

    ExecMessage(Object obj, Token sel, Object[] args, String fn) throws JOEException {
        this.selector = sel.word;
        this.row = sel.row;
        this.col = sel.col;
        this.fName = fn;
        this.origArgs = args;
        if (obj instanceof Message) {
            this.receiver = (Message)obj;
        } else {
            this.object = obj;
        }
    }

    @Override
    public int getRow() {
        return this.row;
    }

    @Override
    public int getCol() {
        return this.col;
    }

    private Object[] argsExec(Block blk) throws JOEException {
        Object[] Return = new Object[this.origArgs.length];
        for (int i = 0; i < this.origArgs.length; ++i) {
            Return[i] = this.origArgs[i] instanceof Message ? ((Message)this.origArgs[i]).exec(blk) : this.origArgs[i];
        }
        return Return;
    }

    private MethodWArgs checkJO(Block ob, Block blk) throws JOEException {
        Block b;
        Object[] argArray = null;
        if (this.origArgs != null) {
            argArray = this.argsExec(blk);
        }
        if ((b = ob.getMethod(this.selector)) == null) {
            throw new JOEException(new NoSuchMethodException(this.selector + " in " + ob.name()), this.row, this.col, this.fName);
        }
        return new MethodWArgs(b, argArray);
    }

    private MethodWArgs check(Object actObj, Block blk) throws JOEException {
        MethodWArgs Return;
        String jSelector = ExecMessage.getJSelector(this.selector);
        Object[] argArray = null;
        this.clazz = actObj instanceof ClassReference ? ((ClassReference)actObj).get() : actObj.getClass();
        if (this.origArgs != null) {
            argArray = this.argsExec(blk);
            if (!(actObj instanceof InternalObject)) {
                for (int i = 0; i < argArray.length; ++i) {
                    if (!(argArray[i] instanceof Wrapper)) continue;
                    argArray[i] = ((Wrapper)argArray[i]).getWrapped();
                }
            }
            Class[] argClasses = new Class[argArray.length];
            for (int i = 0; i < argArray.length; ++i) {
                argClasses[i] = argArray[i] == null ? Object.class : argArray[i].getClass();
            }
            Return = this.getMethod(jSelector, argClasses, argArray);
        } else {
            try {
                Method[] m = this.methCache.get(this.clazz);
                if (m == null) {
                    m = new Method[]{this.clazz.getMethod(jSelector, new Class[0])};
                    this.methCache.put(this.clazz, m);
                }
                Return = new MethodWArgs(m[0], argArray);
            }
            catch (NoSuchMethodException ex) {
                throw new JOEException(ex, this.row, this.col, this.fName);
            }
        }
        return Return;
    }

    private int paramFits(Class methType, Class currParam, int currFit) {
        if (currParam != null) {
            currFit = methType.equals(currParam) ? (currFit += 2) : (methType.isAssignableFrom(currParam) ? ++currFit : (methType.isPrimitive() && currParam.equals(primitiveClasses.get(methType)) ? (currFit += 2) : -1));
        }
        return currFit;
    }

    private MethodWArgs getMethod(String jSelector, Class[] argClasses, Object[] argArray) throws JOEException {
        int j;
        int i;
        Method method = null;
        int bestFit = -1;
        boolean bVarargs = false;
        Class<?>[] bTypes = null;
        Method[] m = this.methCache.get(this.clazz);
        if (m == null) {
            m = this.clazz.getMethods();
            ArrayList<Method> goodMethods = new ArrayList<Method>();
            for (i = 0; i < m.length; ++i) {
                if (!m[i].getName().equals(jSelector)) continue;
                goodMethods.add(m[i]);
            }
            m = goodMethods.toArray(new Method[goodMethods.size()]);
            this.methCache.put(this.clazz, m);
        }
        for (int i2 = 0; i2 < m.length; ++i2) {
            Class<?>[] types = m[i2].getParameterTypes();
            int currFit = 0;
            boolean varargs = false;
            if (types.length <= 0 || types.length > argClasses.length) continue;
            int fixed = types.length - 1;
            for (j = 0; j < fixed && currFit >= 0; ++j) {
                currFit = this.paramFits(types[j], argClasses[j], currFit);
            }
            if (currFit < 0 || argClasses[fixed] == null) continue;
            boolean allFixed = false;
            if (types.length == argClasses.length) {
                int fits = 0;
                if ((fits = this.paramFits(types[fixed], argClasses[fixed], fits)) >= 0) {
                    currFit += fits;
                    allFixed = true;
                }
            }
            if (!allFixed && types[fixed].isArray()) {
                int k;
                allFixed = true;
                varargs = true;
                Class<?> arCls = types[fixed].getComponentType();
                int nArgLen = argClasses.length - fixed;
                for (k = 0; k < nArgLen && argClasses[fixed + k] != null && arCls.isAssignableFrom(argClasses[fixed + k]); ++k) {
                }
                currFit = k == nArgLen ? ++currFit : -1;
            }
            if (!allFixed || currFit <= bestFit) continue;
            method = m[i2];
            bTypes = types;
            bestFit = currFit;
            bVarargs = varargs;
        }
        if (method == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.clazz.getName());
            sb.append(" ");
            sb.append(jSelector);
            if (argArray != null && argArray.length > 0) {
                sb.append(" ");
                for (i = 0; i < argArray.length - 1; ++i) {
                    if (argArray[i] != null) {
                        sb.append(argArray[i].getClass().getName());
                    } else {
                        sb.append("(null)");
                    }
                    sb.append(",");
                }
                if (argArray[i] != null) {
                    sb.append(argArray[i].getClass().getName());
                } else {
                    sb.append("(null)");
                }
            }
            throw new JOEException(new NoSuchMethodException(sb.toString()), this.row, this.col, this.fName);
        }
        if (bVarargs) {
            Object lastArg;
            int i3;
            Object[] newArgs = new Object[bTypes.length];
            Class<?> arCls = bTypes[bTypes.length - 1].getComponentType();
            for (i3 = 0; i3 < bTypes.length - 1; ++i3) {
                newArgs[i3] = argArray[i3];
            }
            newArgs[i3] = lastArg = Array.newInstance(arCls, argArray.length - i3);
            j = 0;
            while (i3 < argArray.length) {
                Array.set(lastArg, j, argArray[i3]);
                ++i3;
                ++j;
            }
            argArray = newArgs;
        }
        return new MethodWArgs(method, argArray);
    }

    @Override
    public Object exec(Block blk) throws JOEException {
        Object Return;
        try {
            Object actObj = this.receiver != null ? this.receiver.exec(blk) : this.object;
            if (actObj == null) {
                throw new JOEException("null receiver", this.row, this.col, this.fName);
            }
            MethodWArgs mwa = actObj instanceof Block && ((Block)actObj).isExecAsJoe() ? this.checkJO((Block)actObj, blk) : this.check(actObj, blk);
            Return = mwa.invoke(actObj);
            Wrapper wobj = Wrapper.newInstance(Return);
            if (wobj != null) {
                Return = wobj;
            }
        }
        catch (IllegalAccessException ex) {
            throw new JOEException(ex, this.row, this.col, this.fName);
        }
        catch (InvocationTargetException ex) {
            Throwable ilex = ex.getCause();
            if (ilex instanceof JOEException) {
                throw (JOEException)ilex;
            }
            throw new JOEException(ilex, this.row, this.col, this.fName);
        }
        catch (IllegalArgumentException ex) {
            throw new JOEException(ex, this.row, this.col, this.fName);
        }
        return Return;
    }

    public String toString() {
        StringBuilder Return = new StringBuilder("<");
        Return.append(this.row);
        Return.append(",");
        Return.append(this.col);
        Return.append("> ");
        if (this.object != null) {
            Return.append(this.object.getClass().getName());
        } else if (this.receiver != null) {
            Return.append(this.receiver.toString());
        } else {
            Return.append("(null)");
        }
        Return.append(" ");
        Return.append(this.selector);
        return Return.toString();
    }

    static {
        javaKeywords = new HashSet();
        primitiveClasses = new HashMap();
        primitiveClasses.put(Boolean.TYPE, Boolean.class);
        primitiveClasses.put(Byte.TYPE, Byte.class);
        primitiveClasses.put(Character.TYPE, Character.class);
        primitiveClasses.put(Short.TYPE, Short.class);
        primitiveClasses.put(Integer.TYPE, Integer.class);
        primitiveClasses.put(Long.TYPE, Long.class);
        primitiveClasses.put(Float.TYPE, Float.class);
        primitiveClasses.put(Double.TYPE, Double.class);
        javaKeywords.add("abstract");
        javaKeywords.add("assert");
        javaKeywords.add("boolean");
        javaKeywords.add("break");
        javaKeywords.add("byte");
        javaKeywords.add("case");
        javaKeywords.add("catch");
        javaKeywords.add("char");
        javaKeywords.add("class");
        javaKeywords.add("const");
        javaKeywords.add("continue");
        javaKeywords.add("default");
        javaKeywords.add("do");
        javaKeywords.add("double");
        javaKeywords.add("else");
        javaKeywords.add("enum");
        javaKeywords.add("extends");
        javaKeywords.add("final");
        javaKeywords.add("finally");
        javaKeywords.add("float");
        javaKeywords.add("for");
        javaKeywords.add("goto");
        javaKeywords.add("if");
        javaKeywords.add("implements");
        javaKeywords.add("import");
        javaKeywords.add("instanceof");
        javaKeywords.add("int");
        javaKeywords.add("interface");
        javaKeywords.add("long");
        javaKeywords.add("native");
        javaKeywords.add("new");
        javaKeywords.add("package");
        javaKeywords.add("private");
        javaKeywords.add("protected");
        javaKeywords.add("public");
        javaKeywords.add("return");
        javaKeywords.add("short");
        javaKeywords.add("static");
        javaKeywords.add("strictfp");
        javaKeywords.add("super");
        javaKeywords.add("switch");
        javaKeywords.add("synchronized");
        javaKeywords.add("this");
        javaKeywords.add("throw");
        javaKeywords.add("throws");
        javaKeywords.add("transient");
        javaKeywords.add("try");
        javaKeywords.add("void");
        javaKeywords.add("volatile");
        javaKeywords.add("while");
    }

    private static class MethodWArgs {
        private final Method _method;
        private final Block _block;
        private final Object[] _args;

        MethodWArgs(Method m, Object[] a) {
            this._method = m;
            this._block = null;
            this._args = a;
        }

        MethodWArgs(Block b, Object[] a) {
            this._method = null;
            this._block = b;
            this._args = a;
        }

        Object invoke(Object obj) throws JOEException, IllegalAccessException, InvocationTargetException {
            if (this._block != null) {
                return this._block.exec(this._args);
            }
            this._method.setAccessible(true);
            return this._method.invoke(obj, this._args);
        }
    }
}

