/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.joe;

import com.veryant.joe.BreakCmdException;
import com.veryant.joe.BreakEndException;
import com.veryant.joe.DefaultCommand;
import com.veryant.joe.ExecException;
import com.veryant.joe.Executor;
import com.veryant.joe.JOEException;
import com.veryant.joe.ScriptManager;
import com.veryant.joe.StandardExecutor;
import com.veryant.joe.WArray;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JOEJar {
    public static void usage(URL jar, String[] sList) {
        System.err.println("usage: java -jar " + new File(jar.getFile()).getName() + " [<script> [arg ...]]");
        System.err.println("scripts available are:");
        for (int i = 0; i < sList.length; ++i) {
            System.err.println("\t" + sList[i]);
        }
    }

    private static String[] getScriptList(URL jar) {
        ArrayList<String> Return = new ArrayList<String>();
        try {
            ZipEntry e;
            ZipInputStream zip = new ZipInputStream(jar.openStream());
            while ((e = zip.getNextEntry()) != null) {
                String n = e.getName();
                if (!n.endsWith(".joe")) continue;
                Return.add(n);
            }
        }
        catch (IOException _ex) {
            _ex.printStackTrace();
        }
        return Return.toArray(new String[Return.size()]);
    }

    public static void showException(DefaultCommand cmd, Throwable ex) {
        cmd.println(ex);
        Throwable cause = ex;
        while ((cause = cause.getCause()) != null) {
            cmd.println("Caused by: " + cause.toString());
        }
    }

    public static void main(String[] argv) throws Exception {
        Object[] jarg;
        String script;
        Class<?> clazz = new JOEJar().getClass();
        CodeSource src = clazz.getProtectionDomain().getCodeSource();
        URL jar = src.getLocation();
        String[] sList = null;
        if (argv.length < 1) {
            sList = JOEJar.getScriptList(jar);
            if (sList.length == 1) {
                script = sList[0];
                jarg = new Object[]{new String[]{script}};
            } else {
                script = "";
                jarg = new Object[]{new String[]{""}};
                JOEJar.usage(jar, sList);
            }
        } else {
            script = argv[0];
            jarg = new Object[]{new WArray(argv)};
        }
        StandardExecutor exec = new StandardExecutor();
        DefaultCommand defCmd = new DefaultCommand();
        try {
            ScriptManager sm = new ScriptManager(jar, (Executor)exec, (Object)defCmd);
            sm.newInstance(script, jarg);
        }
        catch (BreakEndException ex) {
            System.exit(0);
        }
        catch (ExecException ex) {
            throw ex;
        }
        catch (BreakCmdException ex) {
            JOEJar.showException(defCmd, new BreakCmdException("Block name not found: " + ex.getMessage()));
            System.exit(3);
        }
        catch (JOEException ex) {
            JOEJar.showException(defCmd, ex);
            System.exit(3);
        }
        catch (IOException ex) {
            JOEJar.showException(defCmd, ex);
            if (sList == null) {
                sList = JOEJar.getScriptList(jar);
            }
            JOEJar.usage(jar, sList);
        }
    }
}

