/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.joe;

import com.veryant.joe.Block;
import com.veryant.joe.BreakCmdException;
import com.veryant.joe.BreakEndException;
import com.veryant.joe.DefaultCommand;
import com.veryant.joe.ExecException;
import com.veryant.joe.Executor;
import com.veryant.joe.JOEException;
import com.veryant.joe.Parser;
import com.veryant.joe.ScriptManager;
import com.veryant.joe.StandardExecutor;
import com.veryant.joe.Token;
import com.veryant.joe.Tokenizer;
import com.veryant.joe.WArray;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayDeque;

public class JavaObjectsExecutor {
    public static final String rcsid = "$Id$";
    private Block block;

    public static void showException(DefaultCommand cmd, Throwable ex) {
        cmd.println(ex.getMessage());
        Throwable cause = ex;
        while ((cause = cause.getCause()) != null) {
            cmd.println("Caused by: " + cause.toString());
        }
    }

    public static void main(String[] argv) {
        int rc = JavaObjectsExecutor.imain(argv);
        if (rc != 0) {
            System.exit(rc);
        }
    }

    public static int imain(String[] argv) {
        while (true) {
            try {
                return JavaObjectsExecutor._main(argv);
            }
            catch (ExecException newScript) {
                argv = newScript.cmds;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int _main(String[] argv) throws ExecException {
        int Return;
        StandardExecutor exec = new StandardExecutor();
        if (argv.length > 0) {
            DefaultCommand defCmd = new DefaultCommand();
            try {
                File f = new File(argv[0]).getCanonicalFile();
                ScriptManager sm = new ScriptManager(f.getParentFile(), (Executor)exec, (Object)defCmd);
                Object[] jarg = new Object[]{new WArray(argv)};
                sm.newInstance(f.getName(), jarg);
            }
            catch (BreakEndException ex) {
                Return = 0;
            }
            catch (ExecException ex) {
                throw ex;
            }
            catch (BreakCmdException ex) {
                JavaObjectsExecutor.showException(defCmd, new BreakCmdException("Block name not found: " + ex.getMessage()));
                Return = 2;
            }
            catch (JOEException ex) {
                JavaObjectsExecutor.showException(defCmd, ex);
                Return = 2;
            }
            catch (FileNotFoundException ex) {
                JavaObjectsExecutor.showException(defCmd, ex);
                Return = 3;
            }
            catch (IOException ex) {
                JavaObjectsExecutor.showException(defCmd, ex);
                Return = 4;
            }
            Return = 0;
        } else {
            Return = 0;
            DefaultCommand defCmd = new DefaultCommand();
            File cwd = new File(System.getProperty("user.dir"));
            ScriptManager sm = new ScriptManager(cwd, (Executor)exec, (Object)defCmd);
            Object cmd = defCmd;
            String line = "";
            defCmd.println("JOE interactive ready, type 'exit' to exit the session");
            defCmd.println();
            Parser prg = new Parser(cmd, exec, "<stdin>");
            Block b = null;
            while (!"exit".equals(line)) {
                defCmd.print("joe> ");
                try {
                    line = defCmd.readLine().toString();
                }
                catch (IOException ex) {
                    JavaObjectsExecutor.showException(defCmd, ex);
                    Return = 4;
                    break;
                }
                ArrayDeque<Token> tokens = new ArrayDeque<Token>();
                Tokenizer tkzer = new Tokenizer();
                tkzer.tokenize(line.toCharArray(), tokens);
                try {
                    b = prg.compile(tokens);
                    try {
                        b.init();
                        cmd = prg.getCommand();
                    }
                    catch (ExecException ex) {
                        throw ex;
                    }
                    catch (JOEException ex) {
                        JavaObjectsExecutor.showException(defCmd, ex);
                    }
                    finally {
                        b.clear();
                    }
                }
                catch (JOEException ex) {
                    JavaObjectsExecutor.showException(defCmd, ex);
                }
            }
        }
        return Return;
    }
}

