/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.joe;

import com.veryant.joe.Block;
import com.veryant.joe.ExecMessage;
import com.veryant.joe.Executor;
import com.veryant.joe.JOEException;
import com.veryant.joe.Literals;
import com.veryant.joe.Message;
import com.veryant.joe.OuterBlock;
import com.veryant.joe.SingleVariableMessage;
import com.veryant.joe.Token;
import com.veryant.joe.TokenType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public class Parser {
    private Object command;
    final Block block;
    final OuterBlock outerBlock;
    final String fName;

    public Parser(Object cmds, Executor exec, String fn) {
        this.command = cmds;
        this.outerBlock = new OuterBlock(exec);
        this.block = this.outerBlock;
        this.fName = fn;
        this.block.setName(fn);
    }

    private Parser(Parser parent) {
        this.command = parent.command;
        this.outerBlock = parent.outerBlock;
        this.block = new Block(this.outerBlock.executor, parent.block);
        this.fName = parent.fName;
    }

    public Object getCommand() {
        return this.command;
    }

    public Block compile(ArrayDeque<Token> tks) throws JOEException {
        return this.compile(new TkStack(tks));
    }

    private void setBlockArguments(TkStack tokens) throws JOEException {
        Token tk;
        ArrayList<String> argv = new ArrayList<String>();
        do {
            tk = tokens.pop();
            if (tk.type != TokenType._WORD) break;
            argv.add(tk.word);
            tk = tokens.pop();
        } while (tk.type == TokenType._COMMA_);
        if (tk.type != TokenType._DOT_) {
            this.unexpectedToken(tk);
        }
        String[] args = new String[argv.size()];
        this.block.setArguments(argv.toArray(args));
    }

    public Block compile(TkStack tokens) throws JOEException {
        if (tokens.peek().type == TokenType._WORD) {
            Token name = tokens.pop();
            if (tokens.peek().type == TokenType._COLON_) {
                tokens.pop();
                this.setBlockArguments(tokens);
                this.block.setName(name.word);
            } else if (tokens.peek().type == TokenType._DOT_) {
                this.block.setName(name.word);
                tokens.push(name);
            } else {
                tokens.push(name);
            }
        } else if (tokens.peek().type == TokenType._COLON_) {
            tokens.pop();
            this.setBlockArguments(tokens);
        }
        while (tokens.size() > 0 && tokens.peek().type != TokenType._BRACE_CLOSE_) {
            this.block.add(this.assignment(tokens));
        }
        return this.block;
    }

    private Message assgnDyMsg(final String name, final Object val, final int row, final int col) {
        Message Return;
        if (val instanceof Message) {
            final Message msg = (Message)val;
            Return = new Message(){

                @Override
                public Object exec(Block blk) throws JOEException {
                    return blk.setVariable(name, msg.exec(blk));
                }

                @Override
                public int getRow() {
                    return row;
                }

                @Override
                public int getCol() {
                    return col;
                }

                public String toString() {
                    return name + ":={" + val + "}";
                }
            };
        } else {
            Return = new Message(){

                @Override
                public Object exec(Block blk) throws JOEException {
                    return blk.setVariable(name, val);
                }

                @Override
                public int getRow() {
                    return row;
                }

                @Override
                public int getCol() {
                    return col;
                }

                public String toString() {
                    return name + ":=" + val;
                }
            };
        }
        return Return;
    }

    private Message assignment(TkStack tokens) throws JOEException {
        Message Return;
        Token tk = tokens.pop();
        if (tokens.peek().type == TokenType._ASSIGN) {
            tokens.pop();
            Object val = this.message(tokens, tokens.pop());
            int row = tk.row;
            int col = tk.col;
            if (tk.type == TokenType._WORD) {
                String name = tk.word;
                Return = this.assgnDyMsg(name, val, row, col);
            } else {
                Return = null;
                this.unexpectedToken(tk);
            }
        } else {
            final Object val = this.message(tokens, tk);
            if (val instanceof Message) {
                Return = (Message)val;
            } else {
                final int row = tk.row;
                final int col = tk.col;
                Return = new Message(){

                    @Override
                    public Object exec(Block blk) throws JOEException {
                        return val;
                    }

                    @Override
                    public int getRow() {
                        return row;
                    }

                    @Override
                    public int getCol() {
                        return col;
                    }

                    public String toString() {
                        return val.toString();
                    }
                };
            }
        }
        return Return;
    }

    private Object message(TkStack tokens, Token tk) throws JOEException {
        String name = tk.word;
        Object receiver = this.getValue(tk);
        if (receiver == tk) {
            switch (tk.type) {
                case _PAR_OPEN_: {
                    receiver = this.message(tokens, tokens.pop());
                    this.parClose(tokens);
                    break;
                }
                case _BRACE_OPEN_: {
                    receiver = this.block(tk, tokens);
                    this.braceClose(tokens);
                    break;
                }
                case _DOT_: {
                    return null;
                }
                default: {
                    this.unexpectedToken(tk);
                }
            }
        }
        tk = tokens.pop();
        switch (tk.type) {
            case _WORD: {
                return this.arguments(tokens, receiver, tk);
            }
            case _PAR_CLOSE_: 
            case _BRACE_CLOSE_: {
                tokens.push(tk);
            }
            case _DOT_: 
            case _SEMICOLON_: {
                return receiver;
            }
        }
        this.unexpectedToken(tk);
        return null;
    }

    private Message block(final Token tk, TkStack tokens) throws JOEException {
        Parser parser = new Parser(this);
        final Block newBlock = parser.compile(tokens);
        final int blkIdx = this.block.getLastChild();
        Message Return = new Message(){

            @Override
            public Object exec(Block blk) throws JOEException {
                return blk.getChild(blkIdx);
            }

            @Override
            public int getRow() {
                return tk.row;
            }

            @Override
            public int getCol() {
                return tk.col;
            }

            public String toString() {
                return newBlock.toString();
            }
        };
        return Return;
    }

    private Message arguments(TkStack tokens, Object receiver, Token selector) throws JOEException {
        Message Return;
        Token tk;
        ArrayList<Object> args;
        block18: {
            args = new ArrayList<Object>();
            do {
                Object obj;
                if ((obj = this.getValue(tk = tokens.pop())) == tk) {
                    switch (tk.type) {
                        case _DOT_: {
                            tokens.push(tk);
                        }
                        case _SEMICOLON_: {
                            break block18;
                        }
                        case _PAR_CLOSE_: 
                        case _BRACE_CLOSE_: {
                            tokens.push(tk);
                            break block18;
                        }
                        case _PAR_OPEN_: {
                            if (tokens.peek().type == TokenType._PAR_CLOSE_) {
                                tokens.pop();
                                break block18;
                            }
                            args.add(this.message(tokens, tokens.pop()));
                            this.parClose(tokens);
                            break;
                        }
                        case _BRACE_OPEN_: {
                            args.add(this.block(tk, tokens));
                            this.braceClose(tokens);
                            break;
                        }
                        default: {
                            this.unexpectedToken(tk);
                            break;
                        }
                    }
                } else {
                    args.add(obj);
                }
                tk = tokens.pop();
            } while (tk.type == TokenType._COMMA_);
            tokens.push(tk);
        }
        if (args.size() == 0) {
            Return = new ExecMessage(receiver, selector, null, this.fName);
        } else {
            Object[] argsAr = args.toArray();
            Return = new ExecMessage(receiver, selector, argsAr, this.fName);
        }
        tk = tokens.pop();
        switch (tk.type) {
            case _WORD: {
                Return = this.arguments(tokens, Return, tk);
                break;
            }
            case _DOT_: 
            case _SEMICOLON_: {
                break;
            }
            case _PAR_CLOSE_: 
            case _BRACE_CLOSE_: {
                tokens.push(tk);
                break;
            }
            default: {
                this.unexpectedToken(tk);
            }
        }
        return Return;
    }

    private Object getValue(final Token tk) {
        switch (tk.type) {
            case _BANG_: {
                return this.command;
            }
            case _BANGBANG_: {
                return new Message(){

                    @Override
                    public Object exec(Block blk) {
                        return blk;
                    }

                    @Override
                    public int getRow() {
                        return tk.row;
                    }

                    @Override
                    public int getCol() {
                        return tk.col;
                    }

                    public String getName() {
                        return tk.word;
                    }

                    public String toString() {
                        return tk.word;
                    }
                };
            }
            case _STRING: {
                return Literals.getString(tk.word);
            }
            case _INTEGER: {
                return Literals.getInteger(tk.word);
            }
            case _FLOAT: {
                return Literals.getDecimal(tk.word);
            }
            case _WORD: {
                return new SingleVariableMessage(){

                    @Override
                    public Object exec(Block blk) {
                        return blk.getVariable(tk.word);
                    }

                    @Override
                    public int getRow() {
                        return tk.row;
                    }

                    @Override
                    public int getCol() {
                        return tk.col;
                    }

                    @Override
                    public String getName() {
                        return tk.word;
                    }

                    public String toString() {
                        return tk.word;
                    }
                };
            }
        }
        return tk;
    }

    private void parClose(TkStack tokens) throws JOEException {
        Token tk = tokens.pop();
        if (tk.type != TokenType._PAR_CLOSE_) {
            throw new JOEException("Expected close parenthesis, found " + tk.word, tk, this.fName);
        }
    }

    private void braceClose(TkStack tokens) throws JOEException {
        Token tk = tokens.pop();
        if (tk.type != TokenType._BRACE_CLOSE_) {
            throw new JOEException("Expected close brace, found " + tk.word, tk, this.fName);
        }
    }

    private void unexpectedToken(Token tk) throws JOEException {
        throw new JOEException("Unexpected token `" + tk.word + "`", tk, this.fName);
    }

    static class TkStack {
        private final ArrayDeque<Token> tokens;
        private int lRow;
        private int lCol;

        TkStack(ArrayDeque<Token> tks) {
            this.tokens = tks;
        }

        Token pop() {
            Token Return;
            try {
                Return = this.tokens.removeFirst();
                this.lRow = Return.row;
                this.lCol = Return.col;
            }
            catch (NoSuchElementException _ex) {
                Return = new Token("(end stream)", TokenType._DOT_, this.lRow, this.lCol);
            }
            return Return;
        }

        void push(Token tk) {
            this.tokens.addFirst(tk);
        }

        Token peek() {
            Token Return;
            try {
                Return = this.tokens.getFirst();
            }
            catch (NoSuchElementException _ex) {
                Return = new Token("(end stream)", TokenType._DOT_, this.lRow, this.lCol);
            }
            return Return;
        }

        int size() {
            return this.tokens.size();
        }

        public String toString() {
            return this.tokens.toString();
        }
    }
}

