/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.joe;

import com.veryant.joe.Block;
import com.veryant.joe.Executor;
import com.veryant.joe.JOEException;
import com.veryant.joe.OuterBlock;
import com.veryant.joe.Wrapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ScriptManager {
    private static final HashMap<Object, ScriptManager> scriptManagerMap = new HashMap();
    protected final URL entryPoint;
    protected final Executor executor;
    protected final Object command;
    protected final HashMap<String, Block> blocks = new HashMap();

    public static ScriptManager get(Object cmd) {
        return scriptManagerMap.get(cmd);
    }

    public static Block newInstance(Object cmd, String name, Object[] argv) throws IOException, JOEException {
        ScriptManager sm = ScriptManager.get(cmd);
        if (sm == null) {
            throw new RuntimeException("ScriptManager not found!");
        }
        return sm.newInstance(name, argv);
    }

    static URL getURL(File f) {
        try {
            return f.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public ScriptManager(URL ep, Executor exec, Object cmd) {
        this.entryPoint = ep;
        this.executor = exec;
        this.command = cmd;
        scriptManagerMap.put(this.command, this);
    }

    public ScriptManager(File ep, Executor exec, Object cmd) {
        this(ScriptManager.getURL(ep), exec, cmd);
    }

    private InputStream getStreamFromJar(String name) throws IOException {
        ZipEntry e;
        ZipInputStream zip = new ZipInputStream(this.entryPoint.openStream());
        while ((e = zip.getNextEntry()) != null) {
            String n = e.getName();
            if (!n.equals(name)) continue;
            return zip;
        }
        return null;
    }

    public URL getEntryPoint() {
        return this.entryPoint;
    }

    public URL getURL(String spec) throws MalformedURLException {
        return new URL(this.entryPoint, spec);
    }

    public InputStream getInputStream(String name) throws IOException {
        InputStream Return;
        File f;
        try {
            f = new File(this.entryPoint.toURI());
        }
        catch (URISyntaxException _ex) {
            throw new FileNotFoundException(this.entryPoint.getFile());
        }
        if (f.isDirectory()) {
            f = new File(f, name);
            Return = new FileInputStream(f);
        } else {
            Return = this.getStreamFromJar(name);
            if (Return == null) {
                throw new FileNotFoundException(name);
            }
        }
        return Return;
    }

    public Block newInstance(String name, Object[] argv) throws IOException, JOEException {
        Block Return = this.blocks.get(name);
        if (Return != null) {
            Return = (Block)Return.clone();
            if (argv != null) {
                for (int i = 0; i < argv.length; ++i) {
                    Wrapper wobj = Wrapper.newInstance(argv[i]);
                    if (wobj == null) continue;
                    argv[i] = wobj;
                }
            }
            Return.init(argv);
        } else {
            BufferedReader src = new BufferedReader(new InputStreamReader(this.getInputStream(name)));
            Return = OuterBlock.get(name, src, argv, this.command, this.executor);
            this.blocks.put(name, Return);
        }
        return Return;
    }
}

