/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.joe;

import com.veryant.joe.Token;
import com.veryant.joe.TokenType;
import java.util.ArrayDeque;

public class Tokenizer {
    public static final String rcsid = "$Id$";
    private ArrayDeque<Token> tokens;
    private StringBuilder word;
    private TokenType status = TokenType._INIT;
    private int cRow = 0;
    private int cCol = 0;

    private Token newToken(String w, TokenType t) {
        return new Token(w, t, this.cRow, this.cCol);
    }

    private boolean breakChar(char c) {
        boolean Return = true;
        switch (this.status) {
            case _INIT: {
                break;
            }
            case _INTEGER: {
                this.tokens.add(this.newToken(this.word.toString(), TokenType._INTEGER));
                this.word = null;
                this.status = TokenType._INIT;
                break;
            }
            case _FLOAT: {
                this.tokens.add(this.newToken(this.word.toString(), TokenType._FLOAT));
                this.word = null;
                this.status = TokenType._INIT;
                break;
            }
            case _WORD: {
                this.tokens.add(this.newToken(this.word.toString(), TokenType._WORD));
                this.word = null;
                this.status = TokenType._INIT;
                break;
            }
            case _STRING: {
                this.word.append(c);
                Return = false;
                break;
            }
            case _ML_COMMENT: {
                Return = false;
            }
        }
        return Return;
    }

    public boolean tokenize(char[] line, ArrayDeque<Token> t) {
        boolean Return = false;
        int idx = 0;
        int ila = 0;
        ++this.cRow;
        this.tokens = t;
        this.word = null;
        block50: for (idx = 0; idx < line.length; ++idx) {
            ila = this.cCol = idx + 1;
            switch (line[idx]) {
                case '\t': 
                case '\r': 
                case ' ': {
                    this.breakChar(line[idx]);
                    continue block50;
                }
                case '*': {
                    switch (this.status) {
                        case _ML_COMMENT: {
                            if (++idx < line.length && line[idx] == '/') {
                                this.status = TokenType._INIT;
                                break;
                            }
                            --idx;
                            break;
                        }
                        case _STRING: {
                            this.word.append(line[idx]);
                            break;
                        }
                        case _INIT: 
                        case _INTEGER: 
                        case _FLOAT: 
                        case _WORD: {
                            if (++idx < line.length && line[idx] == '>') {
                                idx = line.length;
                                break;
                            }
                            --idx;
                            if (this.status == TokenType._WORD) {
                                this.tokens.add(this.newToken(this.word.toString(), TokenType._WORD));
                            } else if (this.status == TokenType._INTEGER) {
                                this.tokens.add(this.newToken(this.word.toString(), TokenType._INTEGER));
                            } else if (this.status == TokenType._FLOAT) {
                                this.tokens.add(this.newToken(this.word.toString(), TokenType._FLOAT));
                            }
                            this.word = null;
                            this.status = TokenType._INIT;
                            this.tokens.add(this.newToken("multiply", TokenType._WORD));
                        }
                    }
                    continue block50;
                }
                case '=': {
                    if (!this.breakChar(line[idx])) continue block50;
                    this.tokens.add(this.newToken("equals", TokenType._WORD));
                    continue block50;
                }
                case '<': {
                    if (!this.breakChar(line[idx])) continue block50;
                    if (++idx < line.length && line[idx] == '=') {
                        this.tokens.add(this.newToken("le", TokenType._WORD));
                        continue block50;
                    }
                    if (idx < line.length && line[idx] == '>') {
                        this.tokens.add(this.newToken("ne", TokenType._WORD));
                        continue block50;
                    }
                    --idx;
                    this.tokens.add(this.newToken("lt", TokenType._WORD));
                    continue block50;
                }
                case '>': {
                    if (!this.breakChar(line[idx])) continue block50;
                    if (++idx < line.length && line[idx] == '=') {
                        this.tokens.add(this.newToken("ge", TokenType._WORD));
                        continue block50;
                    }
                    --idx;
                    this.tokens.add(this.newToken("gt", TokenType._WORD));
                    continue block50;
                }
                case ':': {
                    if (!this.breakChar(line[idx])) continue block50;
                    if (++idx < line.length && line[idx] == '=') {
                        this.tokens.add(this.newToken(":=", TokenType._ASSIGN));
                        continue block50;
                    }
                    --idx;
                    this.tokens.add(this.newToken(":", TokenType._COLON_));
                    continue block50;
                }
                case '-': {
                    if (!this.breakChar(line[idx])) continue block50;
                    if (++idx < line.length && line[idx] >= '0' && line[idx] <= '9') {
                        this.status = TokenType._INTEGER;
                        this.word = new StringBuilder(Character.toString(line[--idx]));
                        continue block50;
                    }
                    --idx;
                    this.tokens.add(this.newToken("subtract", TokenType._WORD));
                    continue block50;
                }
                case '+': {
                    if (!this.breakChar(line[idx])) continue block50;
                    this.tokens.add(this.newToken("add", TokenType._WORD));
                    continue block50;
                }
                case '/': {
                    if (!this.breakChar(line[idx])) continue block50;
                    if (++idx < line.length && line[idx] == '*') {
                        this.status = TokenType._ML_COMMENT;
                        continue block50;
                    }
                    --idx;
                    this.tokens.add(this.newToken("divide", TokenType._WORD));
                    continue block50;
                }
                case '%': {
                    if (!this.breakChar(line[idx])) continue block50;
                    this.tokens.add(this.newToken("mod", TokenType._WORD));
                    continue block50;
                }
                case '(': {
                    if (!this.breakChar(line[idx])) continue block50;
                    this.tokens.add(this.newToken("(", TokenType._PAR_OPEN_));
                    continue block50;
                }
                case ')': {
                    if (!this.breakChar(line[idx])) continue block50;
                    this.tokens.add(this.newToken(")", TokenType._PAR_CLOSE_));
                    continue block50;
                }
                case '{': {
                    if (!this.breakChar(line[idx])) continue block50;
                    this.tokens.add(this.newToken("{", TokenType._BRACE_OPEN_));
                    continue block50;
                }
                case '}': {
                    if (!this.breakChar(line[idx])) continue block50;
                    this.tokens.add(this.newToken("}", TokenType._BRACE_CLOSE_));
                    continue block50;
                }
                case ',': {
                    if (!this.breakChar(line[idx])) continue block50;
                    this.tokens.add(this.newToken(",", TokenType._COMMA_));
                    continue block50;
                }
                case ';': {
                    if (!this.breakChar(line[idx])) continue block50;
                    this.tokens.add(this.newToken(";", TokenType._SEMICOLON_));
                    continue block50;
                }
                case '.': {
                    if (this.status == TokenType._INTEGER && ila < line.length && line[ila] >= '0' && line[ila] <= '9') {
                        this.word.append('.');
                        this.status = TokenType._FLOAT;
                        continue block50;
                    }
                    if (!this.breakChar(line[idx])) continue block50;
                    this.tokens.add(this.newToken(".", TokenType._DOT_));
                    continue block50;
                }
                case '!': {
                    if (!this.breakChar(line[idx])) continue block50;
                    if (ila < line.length && line[ila] == '!') {
                        this.tokens.add(this.newToken("!!", TokenType._BANGBANG_));
                        ++idx;
                        continue block50;
                    }
                    this.tokens.add(this.newToken("!", TokenType._BANG_));
                    continue block50;
                }
                case '\"': {
                    switch (this.status) {
                        case _ML_COMMENT: {
                            break;
                        }
                        case _INTEGER: 
                        case _FLOAT: 
                        case _WORD: {
                            this.tokens.add(this.newToken(this.word.toString(), this.status));
                        }
                        case _INIT: {
                            this.status = TokenType._STRING;
                            this.word = new StringBuilder();
                            break;
                        }
                        case _STRING: {
                            if (++idx < line.length && line[idx] == '\"') {
                                this.word.append(line[idx]);
                                break;
                            }
                            --idx;
                            this.tokens.add(this.newToken(this.word.toString(), TokenType._STRING));
                            this.word = new StringBuilder();
                            this.status = TokenType._INIT;
                        }
                    }
                    continue block50;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    switch (this.status) {
                        case _ML_COMMENT: {
                            break;
                        }
                        case _INIT: {
                            this.status = TokenType._INTEGER;
                            this.word = new StringBuilder(Character.toString(line[idx]));
                            break;
                        }
                        case _INTEGER: 
                        case _FLOAT: 
                        case _WORD: 
                        case _STRING: {
                            this.word.append(line[idx]);
                        }
                    }
                    continue block50;
                }
                case 'E': 
                case 'e': {
                    if ((this.status == TokenType._INTEGER || this.status == TokenType._FLOAT) && ila < line.length && line[ila] >= '0' && line[ila] <= '9') {
                        this.word.append('e');
                        this.status = TokenType._FLOAT;
                        continue block50;
                    }
                }
                default: {
                    switch (this.status) {
                        case _ML_COMMENT: {
                            continue block50;
                        }
                        case _INIT: {
                            if (idx == 0 && line[0] == '#' && line.length > 1 && line[1] == '!') {
                                idx = line.length;
                                continue block50;
                            }
                            this.word = new StringBuilder(Character.toString(line[idx]));
                            this.status = TokenType._WORD;
                            continue block50;
                        }
                        case _INTEGER: 
                        case _FLOAT: {
                            this.breakChar('\u0000');
                            this.word = new StringBuilder(Character.toString(line[idx]));
                            this.status = TokenType._WORD;
                            continue block50;
                        }
                        case _WORD: 
                        case _STRING: {
                            this.word.append(line[idx]);
                        }
                    }
                }
            }
        }
        switch (this.status) {
            case _INIT: 
            case _ML_COMMENT: {
                break;
            }
            case _INTEGER: 
            case _FLOAT: 
            case _WORD: {
                this.tokens.add(this.newToken(this.word.toString(), this.status));
                this.word = null;
                this.status = TokenType._INIT;
                break;
            }
            case _STRING: {
                this.tokens.add(this.newToken("\"" + this.word.toString(), TokenType._UNCLOSED_STRING));
                this.status = TokenType._INIT;
            }
        }
        return Return;
    }
}

