/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.joe;

import com.veryant.joe.InternalObject;
import com.veryant.joe.WArray;
import com.veryant.joe.WBoolean;
import com.veryant.joe.WDouble;
import com.veryant.joe.WInteger;
import com.veryant.joe.WLong;
import com.veryant.joe.WShort;
import com.veryant.joe.WString;
import java.lang.reflect.Array;
import java.util.HashMap;

public abstract class Wrapper
implements InternalObject {
    private static final HashMap<Class, Type> mapping = new HashMap();

    public static Wrapper newInstance(Object obj) {
        if (obj != null) {
            Class<?> clazz = obj.getClass();
            Type t = mapping.get(clazz);
            if (t != null) {
                switch (t) {
                    case BOOLEAN: {
                        return new WBoolean((Boolean)obj);
                    }
                    case BYTE: {
                        return new WLong(((Byte)obj).longValue());
                    }
                    case CHAR: {
                        return new WLong(((Character)obj).charValue());
                    }
                    case SHORT: {
                        return new WShort(((Short)obj).shortValue());
                    }
                    case INT: {
                        return new WInteger(((Integer)obj).intValue());
                    }
                    case LONG: {
                        return new WLong((Long)obj);
                    }
                    case FLOAT: {
                        return new WDouble(((Float)obj).doubleValue());
                    }
                    case DOUBLE: {
                        return new WDouble((Double)obj);
                    }
                    case STRING: {
                        return new WString((String)obj);
                    }
                    case OBJECT_ARRAY: {
                        return new WArray(obj);
                    }
                }
            } else if (clazz.isArray()) {
                Class<?> compClazz = clazz.getComponentType();
                if (compClazz.isPrimitive()) {
                    int len = Array.getLength(obj);
                    Object[] objArray = new Object[len];
                    if (Integer.TYPE.equals(compClazz)) {
                        for (int i = 0; i < len; ++i) {
                            objArray[i] = ((int[])obj)[i];
                        }
                    } else if (Double.TYPE.equals(compClazz)) {
                        for (int i = 0; i < len; ++i) {
                            objArray[i] = ((double[])obj)[i];
                        }
                    } else if (Float.TYPE.equals(compClazz)) {
                        for (int i = 0; i < len; ++i) {
                            objArray[i] = Float.valueOf(((float[])obj)[i]);
                        }
                    } else if (Long.TYPE.equals(compClazz)) {
                        for (int i = 0; i < len; ++i) {
                            objArray[i] = ((long[])obj)[i];
                        }
                    } else if (Short.TYPE.equals(compClazz)) {
                        for (int i = 0; i < len; ++i) {
                            objArray[i] = ((short[])obj)[i];
                        }
                    } else if (Character.TYPE.equals(compClazz)) {
                        for (int i = 0; i < len; ++i) {
                            objArray[i] = Character.valueOf(((char[])obj)[i]);
                        }
                    } else if (Byte.TYPE.equals(compClazz)) {
                        for (int i = 0; i < len; ++i) {
                            objArray[i] = ((byte[])obj)[i];
                        }
                    } else {
                        for (int i = 0; i < len; ++i) {
                            objArray[i] = ((boolean[])obj)[i];
                        }
                    }
                    obj = objArray;
                }
                return new WArray(obj);
            }
        }
        return null;
    }

    abstract Type type();

    public abstract Object getWrapped();

    static {
        mapping.put(Boolean.class, Type.BOOLEAN);
        mapping.put(Byte.class, Type.BYTE);
        mapping.put(Character.class, Type.CHAR);
        mapping.put(Short.class, Type.SHORT);
        mapping.put(Integer.class, Type.INT);
        mapping.put(Long.class, Type.LONG);
        mapping.put(Float.class, Type.FLOAT);
        mapping.put(Double.class, Type.DOUBLE);
        mapping.put(String.class, Type.STRING);
        mapping.put(Object[].class, Type.OBJECT_ARRAY);
    }

    static enum Type {
        BOOLEAN,
        BYTE,
        CHAR,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        STRING,
        OBJECT_ARRAY;

    }
}

