/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.factory.objects;

import java.awt.BasicStroke;
import org.jfree.xml.factory.objects.AbstractObjectDescription;
import org.jfree.xml.factory.objects.ObjectFactoryException;

public class BasicStrokeObjectDescription
extends AbstractObjectDescription {
    public BasicStrokeObjectDescription() {
        super(BasicStroke.class);
        this.setParameterDefinition("value", String.class);
        this.setParameterDefinition("width", Float.class);
        this.setParameterDefinition("dashes", Float[].class);
    }

    private float getFloatParameter(String param) {
        String p = (String)this.getParameter(param);
        if (p == null) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(p);
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    @Override
    public Object createObject() {
        float width = this.getFloatParameter("value");
        if (width > 0.0f) {
            return new BasicStroke(width);
        }
        Float realWidth = (Float)this.getParameter("width");
        Float[] dashes = (Float[])this.getParameter("dashes");
        if (realWidth == null || dashes == null) {
            return null;
        }
        float[] dashesPrimitive = new float[dashes.length];
        for (int i = 0; i < dashes.length; ++i) {
            Float dash = dashes[i];
            dashesPrimitive[i] = dash.floatValue();
        }
        return new BasicStroke(realWidth.floatValue(), 2, 0, 10.0f, dashesPrimitive, 0.0f);
    }

    @Override
    public void setParameterFromObject(Object o) throws ObjectFactoryException {
        if (!(o instanceof BasicStroke)) {
            throw new ObjectFactoryException("Expected object of type BasicStroke");
        }
        BasicStroke bs = (BasicStroke)o;
        this.setParameter("value", String.valueOf(bs.getLineWidth()));
    }
}

