/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.factory.objects;

import java.text.DateFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.jfree.xml.factory.objects.BeanObjectDescription;
import org.jfree.xml.factory.objects.ObjectFactoryException;

public class SimpleDateFormatObjectDescription
extends BeanObjectDescription {
    public SimpleDateFormatObjectDescription() {
        this(SimpleDateFormat.class);
    }

    public SimpleDateFormatObjectDescription(Class className) {
        this(className, true);
    }

    public SimpleDateFormatObjectDescription(Class className, boolean init) {
        super(className, false);
        this.setParameterDefinition("2DigitYearStart", Date.class);
        this.setParameterDefinition("calendar", Calendar.class);
        this.setParameterDefinition("dateFormatSymbols", DateFormatSymbols.class);
        this.setParameterDefinition("lenient", Boolean.TYPE);
        this.setParameterDefinition("numberFormat", NumberFormat.class);
        this.setParameterDefinition("localizedPattern", String.class);
        this.setParameterDefinition("pattern", String.class);
        this.ignoreParameter("localizedPattern");
        this.ignoreParameter("pattern");
    }

    @Override
    public void setParameterFromObject(Object o) throws ObjectFactoryException {
        super.setParameterFromObject(o);
        SimpleDateFormat format = (SimpleDateFormat)o;
        this.setParameter("localizedPattern", format.toLocalizedPattern());
        this.setParameter("pattern", format.toPattern());
    }

    @Override
    public Object createObject() {
        SimpleDateFormat format = (SimpleDateFormat)super.createObject();
        if (this.getParameter("pattern") != null) {
            format.applyPattern((String)this.getParameter("pattern"));
        }
        if (this.getParameter("localizedPattern") != null) {
            format.applyLocalizedPattern((String)this.getParameter("localizedPattern"));
        }
        return format;
    }
}

