/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.updater;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class DirectoryCleaner {
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.exit(1);
        }
        Thread.sleep(1000L);
        long timestamp = Long.parseLong(args[0]);
        for (int i = 1; i < args.length; ++i) {
            for (File f : new File(args[i]).listFiles()) {
                DirectoryCleaner.delete(f, timestamp);
            }
        }
    }

    static boolean delete(File file, long timestamp) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int deleted = 0;
            for (File f : files) {
                if (!DirectoryCleaner.delete(f, timestamp)) continue;
                ++deleted;
            }
            if (deleted == files.length) {
                return file.delete();
            }
            return false;
        }
        if (file.lastModified() < timestamp) {
            boolean ret = file.delete();
            if (!ret) {
                try {
                    FileOutputStream out = new FileOutputStream(file);
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return ret;
        }
        return false;
    }
}

